/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetRewindable;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.util.Convert;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.apache.jena.atlas.lib.MultiMap;
import org.apache.jena.atlas.lib.MultiMapToList;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.server.SystemState;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;

public class FusekiLib {
    public static ContentType getContentType(HttpAction action) {
        return FusekiLib.getContentType(action.request);
    }

    public static ContentType getContentType(HttpServletRequest request) {
        String contentTypeHeader = request.getContentType();
        if (contentTypeHeader == null) {
            return null;
        }
        return ContentType.create(contentTypeHeader);
    }

    public static Lang getLangFromAction(HttpAction action, Lang dft) {
        String contentTypeHeader = action.request.getContentType();
        if (contentTypeHeader == null) {
            return dft;
        }
        return RDFLanguages.contentTypeToLang(contentTypeHeader);
    }

    static String fmtRequest(HttpServletRequest request) {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append(request.getMethod());
        sbuff.append(" ");
        sbuff.append(Convert.decWWWForm(request.getRequestURL()));
        String qs = request.getQueryString();
        if (qs != null) {
            String tmp = request.getQueryString();
            tmp = Convert.decWWWForm(tmp);
            tmp = tmp.replace('\n', ' ');
            tmp = tmp.replace('\r', ' ');
            sbuff.append("?").append(tmp);
        }
        return sbuff.toString();
    }

    public static MultiMap<String, String> parseQueryString(HttpServletRequest req) {
        MultiMapToList<String, String> map = MultiMapToList.create();
        if (req.getQueryString() != null) {
            String[] params = req.getQueryString().split("&");
            for (int i = 0; i < params.length; ++i) {
                String p = params[i];
                String[] x = p.split("=", 2);
                String name = null;
                String value = null;
                if (x.length == 0) {
                    name = p;
                    value = "";
                } else if (x.length == 1) {
                    name = x[0];
                    value = "";
                } else {
                    name = x[0];
                    value = x[1];
                }
                map.put(name, value);
            }
        }
        return map;
    }

    public static String safeParameter(HttpServletRequest request, String pName) {
        String value = request.getParameter(pName);
        value = value.replace("\r", "");
        value = value.replace("\n", "");
        return value;
    }

    public static void addDataInto(Graph data, DatasetGraph dsg, Node graphName) {
        if (graphName == null) {
            graphName = Quad.defaultGraphNodeGenerated;
        }
        ExtendedIterator<Triple> iter = data.find(Node.ANY, Node.ANY, Node.ANY);
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            dsg.add(graphName, t.getSubject(), t.getPredicate(), t.getObject());
        }
        PrefixMapping pmapSrc = data.getPrefixMapping();
        PrefixMapping pmapDest = dsg.getDefaultGraph().getPrefixMapping();
        pmapDest.setNsPrefixes(pmapSrc);
    }

    public static void addDataInto(DatasetGraph src, DatasetGraph dest) {
        Iterator<Quad> iter = src.find(Node.ANY, Node.ANY, Node.ANY, Node.ANY);
        while (iter.hasNext()) {
            Quad q = iter.next();
            dest.add(q);
        }
        PrefixMapping pmapSrc = src.getDefaultGraph().getPrefixMapping();
        PrefixMapping pmapDest = dest.getDefaultGraph().getPrefixMapping();
        pmapDest.withDefaultMappings(pmapSrc);
    }

    public static ResultSet query(String string, Model m) {
        return FusekiLib.query(string, m, null, null);
    }

    public static ResultSet query(String string, Dataset ds) {
        return FusekiLib.query(string, ds, null, null);
    }

    public static ResultSet query(String string, Model m, String varName, RDFNode value) {
        Query query2 = QueryFactory.create(SystemState.PREFIXES + string);
        QuerySolutionMap initValues = null;
        if (varName != null) {
            initValues = FusekiLib.querySolution(varName, value);
        }
        try (QueryExecution qExec = QueryExecutionFactory.create(query2, m, (QuerySolution)initValues);){
            ResultSetRewindable resultSetRewindable = ResultSetFactory.copyResults(qExec.execSelect());
            return resultSetRewindable;
        }
    }

    public static ResultSet query(String string, Dataset ds, String varName, RDFNode value) {
        Query query2 = QueryFactory.create(SystemState.PREFIXES + string);
        QuerySolutionMap initValues = null;
        if (varName != null) {
            initValues = FusekiLib.querySolution(varName, value);
        }
        try (QueryExecution qExec = QueryExecutionFactory.create(query2, ds, (QuerySolution)initValues);){
            ResultSetRewindable resultSetRewindable = ResultSetFactory.copyResults(qExec.execSelect());
            return resultSetRewindable;
        }
    }

    private static QuerySolutionMap querySolution(String varName, RDFNode value) {
        QuerySolutionMap qsm = new QuerySolutionMap();
        FusekiLib.querySolution(qsm, varName, value);
        return qsm;
    }

    public static QuerySolutionMap querySolution(QuerySolutionMap qsm, String varName, RDFNode value) {
        qsm.add(varName, value);
        return qsm;
    }

    public static RDFNode getOne(Resource svc, String property) {
        ResultSet rs = FusekiLib.query("SELECT * { ?svc " + property + " ?x}", svc.getModel(), "svc", (RDFNode)svc);
        if (!rs.hasNext()) {
            throw new FusekiConfigException("No property '" + property + "' for service " + FusekiLib.nodeLabel(svc));
        }
        RDFNode x = rs.next().get("x");
        if (rs.hasNext()) {
            throw new FusekiConfigException("Multiple properties '" + property + "' for service " + FusekiLib.nodeLabel(svc));
        }
        return x;
    }

    public static String nodeLabel(RDFNode n) {
        if (n == null) {
            return "<null>";
        }
        if (n instanceof Resource) {
            return FusekiLib.strForResource((Resource)n);
        }
        Literal lit = (Literal)n;
        return lit.getLexicalForm();
    }

    public static String strForResource(Resource r) {
        return FusekiLib.strForResource(r, r.getModel());
    }

    public static String strForResource(Resource r, PrefixMapping pm) {
        RDFNode n;
        if (r == null) {
            return "NULL ";
        }
        if (r.hasProperty(RDFS.label) && (n = r.getProperty(RDFS.label).getObject()) instanceof Literal) {
            return ((Literal)n).getString();
        }
        if (r.isAnon()) {
            return "<<blank node>>";
        }
        if (pm == null) {
            pm = r.getModel();
        }
        return FusekiLib.strForURI(r.getURI(), pm);
    }

    public static String strForURI(String uri, PrefixMapping pm) {
        String x;
        if (pm != null && !(x = pm.shortForm(uri)).equals(uri)) {
            return x;
        }
        return "<" + uri + ">";
    }
}

