/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.SystemARQ;
import com.hp.hpl.jena.sparql.lib.Metadata;
import com.hp.hpl.jena.sparql.mgt.SystemInfo;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.MappingRegistry;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.transaction.TransactionManager;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.jena.fuseki.FusekiLogging;
import org.apache.jena.riot.RIOT;
import org.apache.jena.riot.system.stream.LocatorFTP;
import org.apache.jena.riot.system.stream.LocatorHTTP;
import org.apache.jena.riot.system.stream.StreamManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fuseki {
    public static String PATH = "org.apache.jena.fuseki";
    public static String FusekiIRI = "http://jena.apache.org/Fuseki";
    public static String FusekiSymbolIRI = "http://jena.apache.org/fuseki#";
    public static String PagesStatic = "pages";
    public static final String BaseParserSPARQL = "http://server/unset-base/";
    public static final String BaseUpload = "http://server/unset-base/";
    private static String metadataLocation = "org/apache/jena/fuseki/fuseki-properties.xml";
    private static Metadata metadata = Fuseki.initMetadata();
    public static final String NAME = "Fuseki";
    public static final String VERSION = metadata.get(PATH + ".version", "development");
    public static final String BUILD_DATE = metadata.get(PATH + ".build.datetime", "unknown");
    public static final String serverHttpName = "Fuseki (" + VERSION + ")";
    public static final String actionLogName = PATH + ".Fuseki";
    public static final Logger actionLog = LoggerFactory.getLogger(actionLogName);
    public static final String requestLogName = PATH + ".Request";
    public static final Logger requestLog = LoggerFactory.getLogger(requestLogName);
    public static final String adminLogName = PATH + ".Admin";
    public static final Logger adminLog = LoggerFactory.getLogger(adminLogName);
    public static final String builderLogName = PATH + ".Builder";
    public static final Logger builderLog = LoggerFactory.getLogger(builderLogName);
    public static final String validationLogName = PATH + ".Validate";
    public static final Logger validationLog = LoggerFactory.getLogger(adminLogName);
    public static final String serverLogName = PATH + ".Server";
    public static final Logger serverLog = LoggerFactory.getLogger(serverLogName);
    public static final String servletRequestLogName = PATH + ".Servlet";
    public static final String configLogName = PATH + ".Config";
    public static final Logger configLog = LoggerFactory.getLogger(configLogName);
    public static boolean verboseLogging = false;
    public static final StreamManager webStreamManager = new StreamManager();
    public static String DFT_FUSEKI_HOME;
    public static String DFT_FUSEKI_BASE;
    private static boolean initialized;
    private static final long startMillis;
    private static final Calendar cal;
    private static final String startDateTime;

    private static Metadata initMetadata() {
        Metadata m = new Metadata();
        m.addMetadata(metadataLocation);
        return m;
    }

    public static long serverUptimeMillis() {
        return System.currentTimeMillis() - startMillis;
    }

    public static long serverUptimeSeconds() {
        long x = System.currentTimeMillis() - startMillis;
        return TimeUnit.MILLISECONDS.toSeconds(x);
    }

    public static String serverStartedAt() {
        return startDateTime;
    }

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        FusekiLogging.setLogging();
        ARQ.init();
        SystemInfo sysInfo = new SystemInfo(FusekiIRI, PATH, VERSION, BUILD_DATE);
        SystemARQ.registerSubSystem(sysInfo);
        RIOT.init();
        TDB.init();
        MappingRegistry.addPrefixMapping("fuseki", FusekiSymbolIRI);
        TDB.setOptimizerWarningFlag(false);
        TransactionManager.QueueBatchSize = 0;
    }

    public static Context getContext() {
        return ARQ.getContext();
    }

    static {
        webStreamManager.addLocator(new LocatorHTTP());
        webStreamManager.addLocator(new LocatorFTP());
        DFT_FUSEKI_HOME = ".";
        DFT_FUSEKI_BASE = ".";
        initialized = false;
        startMillis = System.currentTimeMillis();
        cal = Calendar.getInstance(TimeZone.getTimeZone("00:00"));
        cal.setTimeInMillis(startMillis);
        startDateTime = Utils.calendarToXSDDateTimeString(cal);
        Fuseki.init();
    }
}

