/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.logging;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogManager;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;
import org.slf4j.Logger;

public class LogCtl {
    private static String log4Jsetup = StrUtils.strjoinNL("## Plain output to stdout", "log4j.appender.jena.plain=org.apache.log4j.ConsoleAppender", "log4j.appender.jena.plain.target=System.out", "log4j.appender.jena.plain.layout=org.apache.log4j.PatternLayout", "log4j.appender.jena.plain.layout.ConversionPattern=%m%n", "## Plain output with level, to stderr", "log4j.appender.jena.plainlevel=org.apache.log4j.ConsoleAppender", "log4j.appender.jena.plainlevel.target=System.err", "log4j.appender.jena.plainlevel.layout=org.apache.log4j.PatternLayout", "log4j.appender.jena.plainlevel.layout.ConversionPattern=%-5p %m%n", "## Everything", "log4j.rootLogger=INFO, jena.plainlevel", "log4j.logger.com.hp.hpl.jena=WARN", "log4j.logger.org.openjena=WARN", "log4j.logger.org.apache.jena=WARN", "log4j.logger.org.apache.jena.tdb.loader=INFO", "## Parser output", "log4j.additivity.org.apache.jena.riot=false", "log4j.logger.org.apache.jena.riot=INFO, jena.plainlevel ");
    static String defaultProperties = StrUtils.strjoinNL("handlers=org.openjena.atlas.logging.java.ConsoleHandlerStdout", "org.apache.atlas.jena.logging.java.ConsoleHandlerStdout.level=INFO", "java.util.logging.ConsoleHandler.formatter=atlas.logging.java.TextFormatter");

    public static void enable(Logger logger) {
        LogCtl.enable(logger.getName());
    }

    public static void enable(String logger) {
        LogCtl.set(logger, "all");
    }

    public static void set(Logger logger, String level) {
        LogCtl.set(logger.getName(), level);
    }

    public static void set(Class<?> logger, String level) {
        LogCtl.set(logger.getName(), level);
    }

    public static void set(String logger, String level) {
        org.apache.log4j.Level level1 = org.apache.log4j.Level.ALL;
        Level level2 = Level.ALL;
        if (level.equalsIgnoreCase("info")) {
            level1 = org.apache.log4j.Level.INFO;
            level2 = Level.INFO;
        }
        if (level.equalsIgnoreCase("debug")) {
            level1 = org.apache.log4j.Level.DEBUG;
            level2 = Level.FINE;
        }
        if (level.equalsIgnoreCase("warn")) {
            level1 = org.apache.log4j.Level.WARN;
            level2 = Level.WARNING;
        }
        if (level.equalsIgnoreCase("error")) {
            level1 = org.apache.log4j.Level.ERROR;
            level2 = Level.SEVERE;
        }
        LogCtl.logLevel(logger, level1, level2);
    }

    public static void logLevel(String logger, org.apache.log4j.Level level1, Level level2) {
        if (level1 != null) {
            org.apache.log4j.LogManager.getLogger(logger).setLevel(level1);
        }
        if (level2 != null) {
            java.util.logging.Logger.getLogger(logger).setLevel(level2);
        }
    }

    public static void enable(Class<?> logger) {
        org.apache.log4j.LogManager.getLogger(logger).setLevel(org.apache.log4j.Level.ALL);
        java.util.logging.Logger.getLogger(logger.getName()).setLevel(Level.ALL);
    }

    public static void disable(String logger) {
        org.apache.log4j.LogManager.getLogger(logger).setLevel(org.apache.log4j.Level.OFF);
        java.util.logging.Logger.getLogger(logger).setLevel(Level.OFF);
    }

    public static void disable(Class<?> logger) {
        org.apache.log4j.LogManager.getLogger(logger).setLevel(org.apache.log4j.Level.OFF);
        java.util.logging.Logger.getLogger(logger.getName()).setLevel(Level.OFF);
    }

    public static void setInfo(String logger) {
        org.apache.log4j.LogManager.getLogger(logger).setLevel(org.apache.log4j.Level.INFO);
        java.util.logging.Logger.getLogger(logger).setLevel(Level.INFO);
    }

    public static void setInfo(Class<?> logger) {
        org.apache.log4j.LogManager.getLogger(logger).setLevel(org.apache.log4j.Level.INFO);
        java.util.logging.Logger.getLogger(logger.getName()).setLevel(Level.INFO);
    }

    public static void setWarn(String logger) {
        org.apache.log4j.LogManager.getLogger(logger).setLevel(org.apache.log4j.Level.WARN);
        java.util.logging.Logger.getLogger(logger).setLevel(Level.WARNING);
    }

    public static void setWarn(Class<?> logger) {
        org.apache.log4j.LogManager.getLogger(logger).setLevel(org.apache.log4j.Level.WARN);
        java.util.logging.Logger.getLogger(logger.getName()).setLevel(Level.WARNING);
    }

    public static void setError(String logger) {
        org.apache.log4j.LogManager.getLogger(logger).setLevel(org.apache.log4j.Level.ERROR);
        java.util.logging.Logger.getLogger(logger).setLevel(Level.SEVERE);
    }

    public static void setError(Class<?> logger) {
        org.apache.log4j.LogManager.getLogger(logger).setLevel(org.apache.log4j.Level.ERROR);
        java.util.logging.Logger.getLogger(logger.getName()).setLevel(Level.SEVERE);
    }

    public static void setLog4j() {
        String fn;
        File f;
        if (System.getProperty("log4j.configuration") == null && (f = new File(fn = "log4j.properties")).exists()) {
            System.setProperty("log4j.configuration", "file:" + fn);
        }
    }

    public static void setLog4j(String filename) {
        if (filename.toLowerCase().endsWith(".xml")) {
            DOMConfigurator.configure(filename);
        } else {
            PropertyConfigurator.configure(filename);
        }
    }

    public static void setCmdLogging() {
        LogCtl.setCmdLogging(log4Jsetup);
    }

    public static void setCmdLogging(String defaultConfig) {
        if (System.getProperty("log4j.configuration") == null) {
            LogCtl.resetLogging(defaultConfig);
        }
    }

    public static void resetLogging(String config) {
        Properties p = new Properties();
        ByteArrayInputStream in = new ByteArrayInputStream(StrUtils.asUTF8bytes(config));
        try {
            p.load(in);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        PropertyConfigurator.configure(p);
        System.setProperty("log4j.configuration", "set");
    }

    public static void setJavaLogging() {
        LogCtl.setJavaLogging("logging.properties");
    }

    public static void setJavaLogging(String file) {
        try {
            FileInputStream details = new FileInputStream(file);
            LogManager.getLogManager().readConfiguration(details);
        }
        catch (Exception ex) {
            throw new AtlasException(ex);
        }
    }

    public static void setJavaLoggingDft() {
        try {
            ByteArrayInputStream details = new ByteArrayInputStream(defaultProperties.getBytes("UTF-8"));
            LogManager.getLogManager().readConfiguration(details);
        }
        catch (Exception ex) {
            throw new AtlasException(ex);
        }
    }
}

