/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.iterator.Action;
import org.apache.jena.atlas.iterator.FilterUnique;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.logging.Log;

public class ListUtils {
    private ListUtils() {
    }

    public static <T> List<T> unique(List<T> list) {
        Iter iter = Iter.iter(list.iterator());
        return iter.filter(new FilterUnique()).toList();
    }

    public static List<Integer> asList(int ... values) {
        ArrayList<Integer> x = new ArrayList<Integer>();
        for (int v : values) {
            x.add(v);
        }
        return x;
    }

    public static <T> String str(T[] array) {
        StringBuilder buff = new StringBuilder();
        String sep = "[";
        for (T anArray : array) {
            buff.append(sep);
            sep = ", ";
            buff.append(anArray);
        }
        buff.append("]");
        return buff.toString();
    }

    public static String str(int[] array) {
        StringBuilder buff = new StringBuilder();
        String sep = "[";
        for (int anArray : array) {
            buff.append(sep);
            sep = ", ";
            buff.append(anArray);
        }
        buff.append("]");
        return buff.toString();
    }

    public static String str(long[] array) {
        StringBuilder buff = new StringBuilder();
        String sep = "[";
        for (long anArray : array) {
            buff.append(sep);
            sep = ", ";
            buff.append(anArray);
        }
        buff.append("]");
        return buff.toString();
    }

    public static <T> void print(IndentedWriter out, List<T> list) {
        ListUtils.print(out, list, " ");
    }

    public static <T> void print(final IndentedWriter out, List<T> list, final String sep) {
        Action output = new Action<T>(){
            boolean first = true;

            @Override
            public void apply(T item) {
                if (!this.first) {
                    out.print(sep);
                }
                out.print(item.toString());
                this.first = false;
            }
        };
        Iter.apply(list, output);
    }

    public static <T> List<List<T>> permute(List<T> c) {
        if (c.size() > 5) {
            Log.warn(ListUtils.class, "Attempt to permute more than 5 items - think again");
            return null;
        }
        ArrayList<List<T>> x = new ArrayList<List<T>>();
        if (c.size() == 1) {
            x.add(c);
            return x;
        }
        for (T obj : c) {
            ArrayList<T> c2 = new ArrayList<T>(c);
            c2.remove(obj);
            List<List<T>> x2 = ListUtils.permute(c2);
            for (List<T> x3 : x2) {
                x3.add(0, obj);
                x.add(x3);
            }
        }
        return x;
    }
}

