/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload.servlet;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.UploadContext;

public class ServletRequestContext
implements UploadContext {
    private final HttpServletRequest request;

    public ServletRequestContext(HttpServletRequest request) {
        this.request = request;
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    @Deprecated
    public int getContentLength() {
        return this.request.getContentLength();
    }

    public long contentLength() {
        long size;
        try {
            size = Long.parseLong(this.request.getHeader("Content-length"));
        }
        catch (NumberFormatException e2) {
            size = this.request.getContentLength();
        }
        return size;
    }

    public InputStream getInputStream() throws IOException {
        return this.request.getInputStream();
    }

    public String toString() {
        return String.format("ContentLength=%s, ContentType=%s", this.contentLength(), this.getContentType());
    }
}

