/*
 * Decompiled with CFR 0.152.
 */
package examples;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ReadWrite;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.sparql.util.QueryExecUtils;
import com.hp.hpl.jena.tdb.TDBFactory;
import java.io.File;
import java.io.IOException;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.query.spatial.EntityDefinition;
import org.apache.jena.query.spatial.SpatialDatasetFactory;
import org.apache.jena.query.spatial.SpatialIndex;
import org.apache.jena.query.spatial.SpatialIndexLucene;
import org.apache.jena.query.spatial.SpatialQuery;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenaSpatialExample1 {
    static Logger log;
    private static final String LUCENE_INDEX_PATH = "target/test/TDBDatasetWithLuceneSpatialIndex";
    private static final File LUCENE_INDEX_DIR;
    private static final String LUCENE_TDB_PATH = "target/test/TDB";
    private static final File LUCENE_TDB_DIR;
    private static final String SOLR_DATA_PATH = "src/test/resources/SolrHome/SolrARQCollection/data";
    private static final File SOLR_DATA_DIR;

    public static void main(String ... argv) throws IOException {
        Dataset spatialDataset = JenaSpatialExample1.initInMemoryDatasetWithLuceneSpatitalIndex(LUCENE_INDEX_DIR);
        JenaSpatialExample1.loadData(spatialDataset, "src/test/resources/geoarq-data-1.ttl");
        JenaSpatialExample1.queryData(spatialDataset);
        JenaSpatialExample1.destroy(spatialDataset);
    }

    private static void destroy(Dataset spatialDataset) {
        SpatialIndex index = (SpatialIndex)spatialDataset.getContext().get(SpatialQuery.spatialIndex);
        if (index instanceof SpatialIndexLucene) {
            JenaSpatialExample1.deleteOldFiles(LUCENE_INDEX_DIR);
            JenaSpatialExample1.deleteOldFiles(LUCENE_TDB_DIR);
        }
    }

    private static void emptyAndDeleteDirectory(File dir) {
        File[] contents = dir.listFiles();
        if (contents != null) {
            for (File content : contents) {
                if (content.isDirectory()) {
                    JenaSpatialExample1.emptyAndDeleteDirectory(content);
                    continue;
                }
                content.delete();
            }
        }
        dir.delete();
    }

    private static Dataset initInMemoryDatasetWithLuceneSpatitalIndex(File indexDir) throws IOException {
        SpatialQuery.init();
        JenaSpatialExample1.deleteOldFiles(indexDir);
        indexDir.mkdirs();
        return JenaSpatialExample1.createDatasetByCode(indexDir);
    }

    private static Dataset initTDBDatasetWithLuceneSpatitalIndex(File indexDir, File TDBDir) throws IOException {
        SpatialQuery.init();
        JenaSpatialExample1.deleteOldFiles(indexDir);
        JenaSpatialExample1.deleteOldFiles(TDBDir);
        indexDir.mkdirs();
        TDBDir.mkdir();
        return JenaSpatialExample1.createDatasetByCode(indexDir, TDBDir);
    }

    private static void deleteOldFiles(File indexDir) {
        if (indexDir.exists()) {
            JenaSpatialExample1.emptyAndDeleteDirectory(indexDir);
        }
    }

    private static Dataset createDatasetByCode(File indexDir) throws IOException {
        Dataset ds1 = DatasetFactory.createMem();
        return JenaSpatialExample1.joinDataset(ds1, indexDir);
    }

    private static Dataset createDatasetByCode(File indexDir, File TDBDir) throws IOException {
        Dataset ds1 = TDBFactory.createDataset(TDBDir.getAbsolutePath());
        return JenaSpatialExample1.joinDataset(ds1, indexDir);
    }

    private static Dataset joinDataset(Dataset baseDataset, File indexDir) throws IOException {
        EntityDefinition entDef = new EntityDefinition("entityField", "geoField");
        entDef.setSpatialContextFactory("com.spatial4j.core.context.jts.JtsSpatialContextFactory");
        entDef.addSpatialPredicatePair(ResourceFactory.createResource("http://localhost/jena_example/#latitude_1"), ResourceFactory.createResource("http://localhost/jena_example/#longitude_1"));
        entDef.addSpatialPredicatePair(ResourceFactory.createResource("http://localhost/jena_example/#latitude_2"), ResourceFactory.createResource("http://localhost/jena_example/#longitude_2"));
        entDef.addWKTPredicate(ResourceFactory.createResource("http://localhost/jena_example/#wkt_1"));
        entDef.addWKTPredicate(ResourceFactory.createResource("http://localhost/jena_example/#wkt_2"));
        FSDirectory dir = FSDirectory.open(indexDir);
        Dataset ds = SpatialDatasetFactory.createLucene(baseDataset, (Directory)dir, entDef);
        return ds;
    }

    public static Dataset createLuceneAssembler() {
        log.info("Construct lucene spatial dataset using an assembler description");
        Dataset ds = DatasetFactory.assemble("src/test/resources/spatial-config.ttl", "http://localhost/jena_example/#spatial_dataset");
        return ds;
    }

    public static Dataset createSolrAssembler() {
        log.info("Construct solr spatial dataset using an assembler description");
        Dataset ds = DatasetFactory.assemble("src/test/resources/spatial-solr-config.ttl", "http://localhost/jena_example/#spatial_dataset");
        return ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadData(Dataset spatialDataset, String file) {
        log.info("Start loading");
        long startTime = System.nanoTime();
        spatialDataset.begin(ReadWrite.WRITE);
        try {
            Model m = spatialDataset.getDefaultModel();
            RDFDataMgr.read(m, file);
            spatialDataset.commit();
        }
        finally {
            spatialDataset.end();
        }
        long finishTime = System.nanoTime();
        double time = (double)(finishTime - startTime) / 1000000.0;
        log.info(String.format("Finish loading - %.2fms", time));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queryData(Dataset spatialDataset) {
        QueryExecution qexec;
        Query q;
        log.info("START");
        long startTime = System.nanoTime();
        String pre = StrUtils.strjoinNL("PREFIX : <http://example/>", "PREFIX spatial: <http://jena.apache.org/spatial#>", "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>");
        System.out.println("nearby");
        String qs = StrUtils.strjoinNL("SELECT * ", " { ?s spatial:nearby (51.3000 -2.71000 100.0 'miles') ;", "      rdfs:label ?label", " }");
        spatialDataset.begin(ReadWrite.READ);
        try {
            Query q2 = QueryFactory.create(pre + "\n" + qs);
            QueryExecution qexec2 = QueryExecutionFactory.create(q2, spatialDataset);
            QueryExecUtils.executeQuery(q2, qexec2);
        }
        finally {
            spatialDataset.end();
        }
        long finishTime = System.nanoTime();
        double time = (double)(finishTime - startTime) / 1000000.0;
        log.info(String.format("FINISH - %.2fms", time));
        System.out.println("withinCircle");
        startTime = System.nanoTime();
        qs = StrUtils.strjoinNL("SELECT * ", " { ?s spatial:withinCircle (51.3000 -2.71000 100.0 'miles' 3) ;", "      rdfs:label ?label", " }");
        spatialDataset.begin(ReadWrite.READ);
        try {
            q = QueryFactory.create(pre + "\n" + qs);
            qexec = QueryExecutionFactory.create(q, spatialDataset);
            QueryExecUtils.executeQuery(q, qexec);
        }
        finally {
            spatialDataset.end();
        }
        finishTime = System.nanoTime();
        time = (double)(finishTime - startTime) / 1000000.0;
        log.info(String.format("FINISH - %.2fms", time));
        System.out.println("withinBox");
        startTime = System.nanoTime();
        qs = StrUtils.strjoinNL("SELECT * ", " { ?s spatial:withinBox (51.1000 -4.0000 51.4000 0.0000 -1) ;", "      rdfs:label ?label", " }");
        spatialDataset.begin(ReadWrite.READ);
        try {
            q = QueryFactory.create(pre + "\n" + qs);
            qexec = QueryExecutionFactory.create(q, spatialDataset);
            QueryExecUtils.executeQuery(q, qexec);
        }
        finally {
            spatialDataset.end();
        }
        finishTime = System.nanoTime();
        time = (double)(finishTime - startTime) / 1000000.0;
        log.info(String.format("FINISH - %.2fms", time));
        System.out.println("interesectBox");
        startTime = System.nanoTime();
        qs = StrUtils.strjoinNL("SELECT * ", " { ?s spatial:intersectBox (51.1000 -4.0000 51.4000 0.0000) ;", "      rdfs:label ?label", " }");
        spatialDataset.begin(ReadWrite.READ);
        try {
            q = QueryFactory.create(pre + "\n" + qs);
            qexec = QueryExecutionFactory.create(q, spatialDataset);
            QueryExecUtils.executeQuery(q, qexec);
        }
        finally {
            spatialDataset.end();
        }
        finishTime = System.nanoTime();
        time = (double)(finishTime - startTime) / 1000000.0;
        log.info(String.format("FINISH - %.2fms", time));
        System.out.println("north");
        startTime = System.nanoTime();
        qs = StrUtils.strjoinNL("SELECT * ", " { ?s spatial:north (51.3000 0.0000) ;", "      rdfs:label ?label", " }");
        spatialDataset.begin(ReadWrite.READ);
        try {
            q = QueryFactory.create(pre + "\n" + qs);
            qexec = QueryExecutionFactory.create(q, spatialDataset);
            QueryExecUtils.executeQuery(q, qexec);
        }
        finally {
            spatialDataset.end();
        }
        finishTime = System.nanoTime();
        time = (double)(finishTime - startTime) / 1000000.0;
        log.info(String.format("FINISH - %.2fms", time));
        System.out.println("south");
        startTime = System.nanoTime();
        qs = StrUtils.strjoinNL("SELECT * ", " { ?s spatial:south (51.3000 0.0000) ;", "      rdfs:label ?label", " }");
        spatialDataset.begin(ReadWrite.READ);
        try {
            q = QueryFactory.create(pre + "\n" + qs);
            qexec = QueryExecutionFactory.create(q, spatialDataset);
            QueryExecUtils.executeQuery(q, qexec);
        }
        finally {
            spatialDataset.end();
        }
        finishTime = System.nanoTime();
        time = (double)(finishTime - startTime) / 1000000.0;
        log.info(String.format("FINISH - %.2fms", time));
        System.out.println("east");
        startTime = System.nanoTime();
        qs = StrUtils.strjoinNL("SELECT * ", " { ?s spatial:east (51.3000 0.0000) ;", "      rdfs:label ?label", " }");
        spatialDataset.begin(ReadWrite.READ);
        try {
            q = QueryFactory.create(pre + "\n" + qs);
            qexec = QueryExecutionFactory.create(q, spatialDataset);
            QueryExecUtils.executeQuery(q, qexec);
        }
        finally {
            spatialDataset.end();
        }
        finishTime = System.nanoTime();
        time = (double)(finishTime - startTime) / 1000000.0;
        log.info(String.format("FINISH - %.2fms", time));
        System.out.println("west");
        startTime = System.nanoTime();
        qs = StrUtils.strjoinNL("SELECT * ", " { ?s spatial:west (51.3000 0.0000) ;", "      rdfs:label ?label", " }");
        spatialDataset.begin(ReadWrite.READ);
        try {
            q = QueryFactory.create(pre + "\n" + qs);
            qexec = QueryExecutionFactory.create(q, spatialDataset);
            QueryExecUtils.executeQuery(q, qexec);
        }
        finally {
            spatialDataset.end();
        }
        finishTime = System.nanoTime();
        time = (double)(finishTime - startTime) / 1000000.0;
        log.info(String.format("FINISH - %.2fms", time));
        System.out.println("west2");
        startTime = System.nanoTime();
        qs = StrUtils.strjoinNL("SELECT * ", " { ?s spatial:withinBox (51.1 -180.0000 51.9 0.0000) ;", "      rdfs:label ?label", " }");
        spatialDataset.begin(ReadWrite.READ);
        try {
            q = QueryFactory.create(pre + "\n" + qs);
            qexec = QueryExecutionFactory.create(q, spatialDataset);
            QueryExecUtils.executeQuery(q, qexec);
        }
        finally {
            spatialDataset.end();
        }
        finishTime = System.nanoTime();
        time = (double)(finishTime - startTime) / 1000000.0;
        log.info(String.format("FINISH - %.2fms", time));
    }

    static {
        LogCtl.setLog4j();
        log = LoggerFactory.getLogger("JenaSpatialExample");
        LUCENE_INDEX_DIR = new File(LUCENE_INDEX_PATH);
        LUCENE_TDB_DIR = new File(LUCENE_TDB_PATH);
        SOLR_DATA_DIR = new File(SOLR_DATA_PATH);
    }
}

