/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store.tupletable;

import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.tdb.store.tupletable.TupleIndex;
import java.util.Iterator;
import org.apache.jena.atlas.lib.ColumnMap;
import org.apache.jena.atlas.lib.Tuple;

public abstract class TupleIndexBase
implements TupleIndex {
    private static final boolean Check = false;
    protected final ColumnMap colMap;
    protected final int tupleLength;
    private final String name;

    protected TupleIndexBase(int N, ColumnMap colMapping, String name) {
        this.tupleLength = N;
        this.colMap = colMapping;
        this.name = name;
    }

    protected abstract boolean performAdd(Tuple<NodeId> var1);

    protected abstract boolean performDelete(Tuple<NodeId> var1);

    protected abstract Iterator<Tuple<NodeId>> performFind(Tuple<NodeId> var1);

    @Override
    public final boolean add(Tuple<NodeId> tuple) {
        return this.performAdd(tuple);
    }

    @Override
    public final boolean delete(Tuple<NodeId> tuple) {
        return this.performDelete(tuple);
    }

    @Override
    public final Iterator<Tuple<NodeId>> find(Tuple<NodeId> pattern) {
        return this.performFind(pattern);
    }

    @Override
    public final int weight(Tuple<NodeId> pattern) {
        for (int i = 0; i < this.tupleLength; ++i) {
            NodeId X = this.colMap.fetchSlot(i, pattern);
            if (!this.undef(X)) continue;
            return i;
        }
        return this.tupleLength;
    }

    @Override
    public final String getMapping() {
        return this.colMap.getLabel();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final int getTupleLength() {
        return this.tupleLength;
    }

    @Override
    public final ColumnMap getColumnMap() {
        return this.colMap;
    }

    protected final boolean undef(NodeId x) {
        return NodeId.isAny(x);
    }

    public String toString() {
        return "index:" + this.getName();
    }
}

