/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store.nodetable;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.sse.SSEParseException;
import com.hp.hpl.jena.tdb.lib.NodeLib;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.riot.out.NodeFmtLib;

public class NodecLib {
    private static final char MarkerChar = '_';
    private static final char[] invalidIRIChars = new char[]{'_', ' '};

    private static String encode(Node node) {
        return NodecLib.encode(node, null);
    }

    private static String encode(Node node, PrefixMapping pmap) {
        String x;
        if (node.isBlank()) {
            return "_:" + node.getBlankNodeLabel();
        }
        if (node.isURI() && (x = StrUtils.encodeHex(node.getURI(), '_', invalidIRIChars)) != node.getURI()) {
            node = NodeFactory.createURI(x);
        }
        return NodeFmtLib.str(node);
    }

    private static Node decode(String s) {
        return NodecLib.decode(s, null);
    }

    private static Node decode(String s, PrefixMapping pmap) {
        if (s.startsWith("_:")) {
            s = s.substring(2);
            return NodeFactory.createAnon(new AnonId(s));
        }
        if (s.startsWith("<")) {
            s = s.substring(1, s.length() - 1);
            s = StrUtils.decodeHex(s, '_');
            return NodeFactory.createURI(s);
        }
        try {
            Node n = SSE.parseNode(s, pmap);
            return n;
        }
        catch (SSEParseException ex) {
            Log.fatal(NodeLib.class, "decode: Failed to parse: " + s);
            throw ex;
        }
    }
}

