/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.tdb.lib.TupleLib;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.tdb.store.TableBase;
import com.hp.hpl.jena.tdb.store.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.store.tupletable.TupleIndex;
import com.hp.hpl.jena.tdb.sys.DatasetControl;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.NullIterator;
import org.apache.jena.atlas.iterator.Transform;
import org.apache.jena.atlas.lib.Tuple;

public class TripleTable
extends TableBase {
    private static Transform<Tuple<Node>, Triple> action = new Transform<Tuple<Node>, Triple>(){

        @Override
        public Triple convert(Tuple<Node> item) {
            return new Triple(item.get(0), item.get(1), item.get(2));
        }
    };

    public TripleTable(TupleIndex[] indexes, NodeTable nodeTable, DatasetControl policy) {
        super(3, indexes, nodeTable, policy);
    }

    public boolean add(Triple triple) {
        return this.add(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public boolean add(Node s, Node p, Node o) {
        return this.table.addRow(s, p, o);
    }

    public boolean delete(Triple triple) {
        return this.delete(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public boolean delete(Node s, Node p, Node o) {
        return this.table.deleteRow(s, p, o);
    }

    public Iterator<Triple> find(Node s, Node p, Node o) {
        Iterator<Tuple<NodeId>> iter = this.table.findAsNodeIds(s, p, o);
        if (iter == null) {
            return new NullIterator<Triple>();
        }
        Iterator<Triple> iter2 = TupleLib.convertToTriples(this.table.getNodeTable(), iter);
        return iter2;
    }

    public void clearTriples() {
        this.table.clear();
    }
}

