/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.core.DatasetPrefixStorage;
import com.hp.hpl.jena.sparql.graph.GraphPrefixesProjection;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.store.nodetupletable.NodeTupleTable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Tuple;
import org.apache.jena.atlas.logging.Log;

public class DatasetPrefixesTDB
implements DatasetPrefixStorage {
    static final RecordFactory factory = new RecordFactory(24, 0);
    static final String unamedGraphURI = "";
    private final NodeTupleTable nodeTupleTable;

    public DatasetPrefixesTDB(NodeTupleTable nodeTupleTable) {
        this.nodeTupleTable = nodeTupleTable;
    }

    @Override
    public synchronized void insertPrefix(String graphName, String prefix, String uri) {
        Node g = NodeFactory.createURI(graphName);
        Node p = NodeFactory.createLiteral(prefix);
        Node u = NodeFactory.createURI(uri);
        this.nodeTupleTable.addRow(g, p, u);
    }

    @Override
    public Set<String> graphNames() {
        Iterator<Tuple<Node>> iter = this.nodeTupleTable.find(new Node[]{null, null, null});
        HashSet<String> x = new HashSet<String>();
        while (iter.hasNext()) {
            x.add(iter.next().get(0).getURI());
        }
        Iter.close(iter);
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String readPrefix(String graphName, String prefix) {
        Node g = NodeFactory.createURI(graphName);
        Node p = NodeFactory.createLiteral(prefix);
        Iterator<Tuple<Node>> iter = this.nodeTupleTable.find(g, p, null);
        try {
            if (!iter.hasNext()) {
                String string = null;
                return string;
            }
            Tuple<Node> t = iter.next();
            Node uri = t.get(2);
            String string = uri.getURI();
            return string;
        }
        finally {
            Iter.close(iter);
        }
    }

    @Override
    public synchronized String readByURI(String graphName, String uriStr) {
        Node g = NodeFactory.createURI(graphName);
        Node u = NodeFactory.createURI(uriStr);
        Iterator<Tuple<Node>> iter = this.nodeTupleTable.find(g, null, u);
        if (!iter.hasNext()) {
            return null;
        }
        Node prefix = iter.next().get(1);
        Iter.close(iter);
        return prefix.getLiteralLexicalForm();
    }

    @Override
    public synchronized Map<String, String> readPrefixMap(String graphName) {
        HashMap<String, String> map = new HashMap<String, String>();
        Node g = NodeFactory.createURI(graphName);
        Iterator<Tuple<Node>> iter = this.nodeTupleTable.find(g, null, null);
        while (iter.hasNext()) {
            try {
                Tuple<Node> t = iter.next();
                String prefix = t.get(1).getLiteralLexicalForm();
                String uri = t.get(2).getURI();
                map.put(prefix, uri);
            }
            catch (Exception ex) {
                Log.warn(this, "Mangled prefix map: graph name=" + graphName, (Throwable)ex);
            }
        }
        Iter.close(iter);
        return map;
    }

    @Override
    public synchronized void loadPrefixMapping(String graphName, PrefixMapping pmap) {
        Node g = NodeFactory.createURI(graphName);
        Iterator<Tuple<Node>> iter = this.nodeTupleTable.find(g, null, null);
        while (iter.hasNext()) {
            Tuple<Node> t = iter.next();
            String prefix = t.get(1).getLiteralLexicalForm();
            String uri = t.get(2).getURI();
            pmap.setNsPrefix(prefix, uri);
        }
        Iter.close(iter);
    }

    @Override
    public synchronized void removeFromPrefixMap(String graphName, String prefix) {
        Node g = NodeFactory.createURI(graphName);
        Node p = NodeFactory.createLiteral(prefix);
        Iterator<Tuple<Node>> iter = this.nodeTupleTable.find(g, p, null);
        List<Tuple<Node>> list = Iter.toList(iter);
        Iter.close(iter);
        for (Tuple<Node> tuple : list) {
            this.nodeTupleTable.deleteRow(g, p, tuple.get(2));
        }
    }

    public NodeTupleTable getNodeTupleTable() {
        return this.nodeTupleTable;
    }

    @Override
    public PrefixMapping getPrefixMapping() {
        return this.getPrefixMapping(unamedGraphURI);
    }

    @Override
    public PrefixMapping getPrefixMapping(String graphName) {
        GraphPrefixesProjection pm = new GraphPrefixesProjection(graphName, this);
        pm.getNsPrefixMap();
        return pm;
    }

    @Override
    public void close() {
        this.nodeTupleTable.close();
    }

    @Override
    public void sync() {
        this.nodeTupleTable.sync();
    }
}

