/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.setup;

import com.hp.hpl.jena.tdb.base.block.FileMode;
import com.hp.hpl.jena.tdb.index.IndexParams;
import com.hp.hpl.jena.tdb.setup.StoreParamsBuilder;
import com.hp.hpl.jena.tdb.setup.StoreParamsConst;
import com.hp.hpl.jena.tdb.setup.StoreParamsDynamic;
import java.util.Objects;
import org.apache.jena.atlas.lib.StrUtils;

public class StoreParams
implements IndexParams,
StoreParamsDynamic {
    final StoreParamsBuilder.Item<FileMode> fileMode;
    final StoreParamsBuilder.Item<Integer> blockReadCacheSize;
    final StoreParamsBuilder.Item<Integer> blockWriteCacheSize;
    final StoreParamsBuilder.Item<Integer> Node2NodeIdCacheSize;
    final StoreParamsBuilder.Item<Integer> NodeId2NodeCacheSize;
    final StoreParamsBuilder.Item<Integer> NodeMissCacheSize;
    final StoreParamsBuilder.Item<Integer> blockSize;
    final StoreParamsBuilder.Item<String> indexNode2Id;
    final StoreParamsBuilder.Item<String> indexId2Node;
    final StoreParamsBuilder.Item<String> primaryIndexTriples;
    final StoreParamsBuilder.Item<String[]> tripleIndexes;
    final StoreParamsBuilder.Item<String> primaryIndexQuads;
    final StoreParamsBuilder.Item<String[]> quadIndexes;
    final StoreParamsBuilder.Item<String> primaryIndexPrefix;
    final StoreParamsBuilder.Item<String[]> prefixIndexes;
    final StoreParamsBuilder.Item<String> indexPrefix;
    final StoreParamsBuilder.Item<String> prefixNode2Id;
    final StoreParamsBuilder.Item<String> prefixId2Node;

    public static StoreParamsBuilder builder() {
        return StoreParamsBuilder.create();
    }

    public static StoreParamsBuilder builder(StoreParams params) {
        return StoreParamsBuilder.create(params);
    }

    StoreParams(StoreParamsBuilder.Item<FileMode> fileMode, StoreParamsBuilder.Item<Integer> blockSize, StoreParamsBuilder.Item<Integer> blockReadCacheSize, StoreParamsBuilder.Item<Integer> blockWriteCacheSize, StoreParamsBuilder.Item<Integer> node2NodeIdCacheSize, StoreParamsBuilder.Item<Integer> nodeId2NodeCacheSize, StoreParamsBuilder.Item<Integer> nodeMissCacheSize, StoreParamsBuilder.Item<String> indexNode2Id, StoreParamsBuilder.Item<String> indexId2Node, StoreParamsBuilder.Item<String> primaryIndexTriples, StoreParamsBuilder.Item<String[]> tripleIndexes, StoreParamsBuilder.Item<String> primaryIndexQuads, StoreParamsBuilder.Item<String[]> quadIndexes, StoreParamsBuilder.Item<String> primaryIndexPrefix, StoreParamsBuilder.Item<String[]> prefixIndexes, StoreParamsBuilder.Item<String> indexPrefix, StoreParamsBuilder.Item<String> prefixNode2Id, StoreParamsBuilder.Item<String> prefixId2Node) {
        this.fileMode = fileMode;
        this.blockSize = blockSize;
        this.blockReadCacheSize = blockReadCacheSize;
        this.blockWriteCacheSize = blockWriteCacheSize;
        this.Node2NodeIdCacheSize = node2NodeIdCacheSize;
        this.NodeId2NodeCacheSize = nodeId2NodeCacheSize;
        this.NodeMissCacheSize = nodeMissCacheSize;
        this.indexNode2Id = indexNode2Id;
        this.indexId2Node = indexId2Node;
        this.primaryIndexTriples = primaryIndexTriples;
        this.tripleIndexes = tripleIndexes;
        this.primaryIndexQuads = primaryIndexQuads;
        this.quadIndexes = quadIndexes;
        this.primaryIndexPrefix = primaryIndexPrefix;
        this.prefixIndexes = prefixIndexes;
        this.indexPrefix = indexPrefix;
        this.prefixNode2Id = prefixNode2Id;
        this.prefixId2Node = prefixId2Node;
    }

    public static StoreParams getDftStoreParams() {
        return StoreParamsConst.dftStoreParams;
    }

    public static StoreParams getSmallStoreParams() {
        return StoreParamsConst.smallStoreParams;
    }

    @Override
    public FileMode getFileMode() {
        return (FileMode)((Object)this.fileMode.value);
    }

    @Override
    public boolean isSetFileMode() {
        return this.fileMode.isSet;
    }

    @Override
    public Integer getBlockSize() {
        return (Integer)this.blockSize.value;
    }

    @Override
    public Integer getBlockReadCacheSize() {
        return (Integer)this.blockReadCacheSize.value;
    }

    @Override
    public boolean isSetBlockReadCacheSize() {
        return this.blockReadCacheSize.isSet;
    }

    @Override
    public Integer getBlockWriteCacheSize() {
        return (Integer)this.blockWriteCacheSize.value;
    }

    @Override
    public boolean isSetBlockWriteCacheSize() {
        return this.blockWriteCacheSize.isSet;
    }

    @Override
    public Integer getNode2NodeIdCacheSize() {
        return (Integer)this.Node2NodeIdCacheSize.value;
    }

    @Override
    public boolean isSetNodeId2NodeCacheSize() {
        return this.NodeId2NodeCacheSize.isSet;
    }

    @Override
    public boolean isSetNode2NodeIdCacheSize() {
        return this.Node2NodeIdCacheSize.isSet;
    }

    @Override
    public Integer getNodeId2NodeCacheSize() {
        return (Integer)this.NodeId2NodeCacheSize.value;
    }

    @Override
    public Integer getNodeMissCacheSize() {
        return (Integer)this.NodeMissCacheSize.value;
    }

    @Override
    public boolean isSetNodeMissCacheSize() {
        return this.NodeMissCacheSize.isSet;
    }

    public String getIndexNode2Id() {
        return (String)this.indexNode2Id.value;
    }

    public String getIndexId2Node() {
        return (String)this.indexId2Node.value;
    }

    public String getPrimaryIndexTriples() {
        return (String)this.primaryIndexTriples.value;
    }

    public String[] getTripleIndexes() {
        return (String[])this.tripleIndexes.value;
    }

    public String getPrimaryIndexQuads() {
        return (String)this.primaryIndexQuads.value;
    }

    public String[] getQuadIndexes() {
        return (String[])this.quadIndexes.value;
    }

    public String getPrimaryIndexPrefix() {
        return (String)this.primaryIndexPrefix.value;
    }

    public String[] getPrefixIndexes() {
        return (String[])this.prefixIndexes.value;
    }

    public String getIndexPrefix() {
        return (String)this.indexPrefix.value;
    }

    public String getPrefixNode2Id() {
        return (String)this.prefixNode2Id.value;
    }

    public String getPrefixId2Node() {
        return (String)this.prefixId2Node.value;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        this.fmt(buff, "fileMode", this.getFileMode().toString(), this.fileMode.isSet);
        this.fmt(buff, "blockSize", this.getBlockSize(), this.blockSize.isSet);
        this.fmt(buff, "readCacheSize", this.getBlockReadCacheSize(), this.blockReadCacheSize.isSet);
        this.fmt(buff, "writeCacheSize", this.getBlockWriteCacheSize(), this.blockWriteCacheSize.isSet);
        this.fmt(buff, "Node2NodeIdCacheSize", this.getNode2NodeIdCacheSize(), this.Node2NodeIdCacheSize.isSet);
        this.fmt(buff, "NodeId2NodeCacheSize", this.getNodeId2NodeCacheSize(), this.NodeId2NodeCacheSize.isSet);
        this.fmt(buff, "NodeMissCacheSize", this.getNodeMissCacheSize(), this.NodeMissCacheSize.isSet);
        this.fmt(buff, "indexNode2Id", this.getIndexNode2Id(), this.indexNode2Id.isSet);
        this.fmt(buff, "indexId2Node", this.getIndexId2Node(), this.indexId2Node.isSet);
        this.fmt(buff, "primaryIndexTriples", this.getPrimaryIndexTriples(), this.primaryIndexTriples.isSet);
        this.fmt(buff, "tripleIndexes", this.getTripleIndexes(), this.tripleIndexes.isSet);
        this.fmt(buff, "primaryIndexQuads", this.getPrimaryIndexQuads(), this.primaryIndexQuads.isSet);
        this.fmt(buff, "quadIndexes", this.getQuadIndexes(), this.quadIndexes.isSet);
        this.fmt(buff, "primaryIndexPrefix", this.getPrimaryIndexPrefix(), this.primaryIndexPrefix.isSet);
        this.fmt(buff, "prefixIndexes", this.getPrefixIndexes(), this.prefixIndexes.isSet);
        this.fmt(buff, "indexPrefix", this.getIndexPrefix(), this.indexPrefix.isSet);
        this.fmt(buff, "prefixNode2Id", this.getPrefixNode2Id(), this.prefixNode2Id.isSet);
        this.fmt(buff, "prefixId2Node", this.getPrefixId2Node(), this.prefixId2Node.isSet);
        return buff.toString();
    }

    private void fmt(StringBuilder buff, String name, String[] strings, boolean isSet) {
        String dftStr = "";
        if (!isSet) {
            dftStr = "dft:";
        }
        buff.append(String.format("%-20s   %s[%s]\n", name, dftStr, StrUtils.strjoin(", ", strings)));
    }

    private void fmt(StringBuilder buff, String name, String value, boolean isSet) {
        String dftStr = "";
        if (!isSet) {
            dftStr = "dft:";
        }
        buff.append(String.format("%-20s   %s%s\n", name, dftStr, value));
    }

    private void fmt(StringBuilder buff, String name, int value, boolean isSet) {
        String dftStr = "";
        if (!isSet) {
            dftStr = "dft:";
        }
        buff.append(String.format("%-20s   %s%s\n", name, dftStr, value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.Node2NodeIdCacheSize == null ? 0 : this.Node2NodeIdCacheSize.hashCode());
        result = 31 * result + (this.NodeId2NodeCacheSize == null ? 0 : this.NodeId2NodeCacheSize.hashCode());
        result = 31 * result + (this.NodeMissCacheSize == null ? 0 : this.NodeMissCacheSize.hashCode());
        result = 31 * result + (this.blockReadCacheSize == null ? 0 : this.blockReadCacheSize.hashCode());
        result = 31 * result + (this.blockSize == null ? 0 : this.blockSize.hashCode());
        result = 31 * result + (this.blockWriteCacheSize == null ? 0 : this.blockWriteCacheSize.hashCode());
        result = 31 * result + (this.fileMode == null ? 0 : this.fileMode.hashCode());
        result = 31 * result + (this.indexId2Node == null ? 0 : this.indexId2Node.hashCode());
        result = 31 * result + (this.indexNode2Id == null ? 0 : this.indexNode2Id.hashCode());
        result = 31 * result + (this.indexPrefix == null ? 0 : this.indexPrefix.hashCode());
        result = 31 * result + (this.prefixId2Node == null ? 0 : this.prefixId2Node.hashCode());
        result = 31 * result + (this.prefixIndexes == null ? 0 : this.prefixIndexes.hashCode());
        result = 31 * result + (this.prefixNode2Id == null ? 0 : this.prefixNode2Id.hashCode());
        result = 31 * result + (this.primaryIndexPrefix == null ? 0 : this.primaryIndexPrefix.hashCode());
        result = 31 * result + (this.primaryIndexQuads == null ? 0 : this.primaryIndexQuads.hashCode());
        result = 31 * result + (this.primaryIndexTriples == null ? 0 : this.primaryIndexTriples.hashCode());
        result = 31 * result + (this.quadIndexes == null ? 0 : this.quadIndexes.hashCode());
        result = 31 * result + (this.tripleIndexes == null ? 0 : this.tripleIndexes.hashCode());
        return result;
    }

    public static boolean sameValues(StoreParams params1, StoreParams params2) {
        if (params1 == null && params2 == null) {
            return true;
        }
        if (params1 == null) {
            return false;
        }
        if (params2 == null) {
            return false;
        }
        if (!StoreParams.sameValues(params1.fileMode, params2.fileMode)) {
            return false;
        }
        if (!StoreParams.sameValues(params1.blockReadCacheSize, params2.blockReadCacheSize)) {
            return false;
        }
        if (!StoreParams.sameValues(params1.blockWriteCacheSize, params2.blockWriteCacheSize)) {
            return false;
        }
        if (!StoreParams.sameValues(params1.Node2NodeIdCacheSize, params2.Node2NodeIdCacheSize)) {
            return false;
        }
        if (!StoreParams.sameValues(params1.NodeId2NodeCacheSize, params2.NodeId2NodeCacheSize)) {
            return false;
        }
        if (!StoreParams.sameValues(params1.NodeMissCacheSize, params2.NodeMissCacheSize)) {
            return false;
        }
        if (!StoreParams.sameValues(params1.blockSize, params2.blockSize)) {
            return false;
        }
        if (!StoreParams.sameValues(params1.indexNode2Id, params2.indexNode2Id)) {
            return false;
        }
        if (!StoreParams.sameValues(params1.indexId2Node, params2.indexId2Node)) {
            return false;
        }
        if (!StoreParams.sameValues(params1.primaryIndexTriples, params2.primaryIndexTriples)) {
            return false;
        }
        if (!StoreParams.sameValues(params1.tripleIndexes, params2.tripleIndexes)) {
            return false;
        }
        if (!StoreParams.sameValues(params1.primaryIndexQuads, params2.primaryIndexQuads)) {
            return false;
        }
        if (!StoreParams.sameValues(params1.quadIndexes, params2.quadIndexes)) {
            return false;
        }
        if (!StoreParams.sameValues(params1.primaryIndexPrefix, params2.primaryIndexPrefix)) {
            return false;
        }
        if (!StoreParams.sameValues(params1.prefixIndexes, params2.prefixIndexes)) {
            return false;
        }
        if (!StoreParams.sameValues(params1.indexPrefix, params2.indexPrefix)) {
            return false;
        }
        if (!StoreParams.sameValues(params1.prefixNode2Id, params2.prefixNode2Id)) {
            return false;
        }
        return StoreParams.sameValues(params1.prefixId2Node, params2.prefixId2Node);
    }

    private static <X> boolean sameValues(StoreParamsBuilder.Item<X> item1, StoreParamsBuilder.Item<X> item2) {
        return Objects.deepEquals(item1.value, item2.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StoreParams other = (StoreParams)obj;
        if (this.Node2NodeIdCacheSize == null ? other.Node2NodeIdCacheSize != null : !this.Node2NodeIdCacheSize.equals(other.Node2NodeIdCacheSize)) {
            return false;
        }
        if (this.NodeId2NodeCacheSize == null ? other.NodeId2NodeCacheSize != null : !this.NodeId2NodeCacheSize.equals(other.NodeId2NodeCacheSize)) {
            return false;
        }
        if (this.NodeMissCacheSize == null ? other.NodeMissCacheSize != null : !this.NodeMissCacheSize.equals(other.NodeMissCacheSize)) {
            return false;
        }
        if (this.blockReadCacheSize == null ? other.blockReadCacheSize != null : !this.blockReadCacheSize.equals(other.blockReadCacheSize)) {
            return false;
        }
        if (this.blockSize == null ? other.blockSize != null : !this.blockSize.equals(other.blockSize)) {
            return false;
        }
        if (this.blockWriteCacheSize == null ? other.blockWriteCacheSize != null : !this.blockWriteCacheSize.equals(other.blockWriteCacheSize)) {
            return false;
        }
        if (this.fileMode == null ? other.fileMode != null : !this.fileMode.equals(other.fileMode)) {
            return false;
        }
        if (this.indexId2Node == null ? other.indexId2Node != null : !this.indexId2Node.equals(other.indexId2Node)) {
            return false;
        }
        if (this.indexNode2Id == null ? other.indexNode2Id != null : !this.indexNode2Id.equals(other.indexNode2Id)) {
            return false;
        }
        if (this.indexPrefix == null ? other.indexPrefix != null : !this.indexPrefix.equals(other.indexPrefix)) {
            return false;
        }
        if (this.prefixId2Node == null ? other.prefixId2Node != null : !this.prefixId2Node.equals(other.prefixId2Node)) {
            return false;
        }
        if (this.prefixIndexes == null ? other.prefixIndexes != null : !this.prefixIndexes.equals(other.prefixIndexes)) {
            return false;
        }
        if (this.prefixNode2Id == null ? other.prefixNode2Id != null : !this.prefixNode2Id.equals(other.prefixNode2Id)) {
            return false;
        }
        if (this.primaryIndexPrefix == null ? other.primaryIndexPrefix != null : !this.primaryIndexPrefix.equals(other.primaryIndexPrefix)) {
            return false;
        }
        if (this.primaryIndexQuads == null ? other.primaryIndexQuads != null : !this.primaryIndexQuads.equals(other.primaryIndexQuads)) {
            return false;
        }
        if (this.primaryIndexTriples == null ? other.primaryIndexTriples != null : !this.primaryIndexTriples.equals(other.primaryIndexTriples)) {
            return false;
        }
        if (this.quadIndexes == null ? other.quadIndexes != null : !this.quadIndexes.equals(other.quadIndexes)) {
            return false;
        }
        return !(this.tripleIndexes == null ? other.tripleIndexes != null : !this.tripleIndexes.equals(other.tripleIndexes));
    }
}

