/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.setup;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.engine.main.QC;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.base.file.FileSet;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.index.IndexBuilder;
import com.hp.hpl.jena.tdb.index.RangeIndexBuilder;
import com.hp.hpl.jena.tdb.setup.BuilderStdDB;
import com.hp.hpl.jena.tdb.setup.DatasetBuilderStd;
import com.hp.hpl.jena.tdb.setup.NodeTableBuilder;
import com.hp.hpl.jena.tdb.setup.StoreParams;
import com.hp.hpl.jena.tdb.setup.TupleIndexBuilder;
import com.hp.hpl.jena.tdb.solver.OpExecutorTDB1;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.DatasetPrefixesTDB;
import com.hp.hpl.jena.tdb.store.QuadTable;
import com.hp.hpl.jena.tdb.store.TripleTable;
import com.hp.hpl.jena.tdb.store.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.store.nodetupletable.NodeTupleTableConcrete;
import com.hp.hpl.jena.tdb.store.tupletable.TupleIndex;
import com.hp.hpl.jena.tdb.sys.DatasetControl;
import com.hp.hpl.jena.tdb.sys.DatasetControlMRSW;
import org.apache.jena.atlas.lib.ColumnMap;
import org.apache.jena.atlas.lib.StrUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DatasetBuilderBasic {
    private static final Logger log = LoggerFactory.getLogger(DatasetBuilderBasic.class);
    private NodeTableBuilder nodeTableBuilder;
    private TupleIndexBuilder tupleIndexBuilder;
    private StoreParams params;

    private DatasetBuilderBasic(IndexBuilder indexBuilder, RangeIndexBuilder rangeIndexBuilder) {
        BuilderStdDB.ObjectFileBuilderStd objectFileBuilder = new BuilderStdDB.ObjectFileBuilderStd();
        this.nodeTableBuilder = new BuilderStdDB.NodeTableBuilderStd(indexBuilder, objectFileBuilder);
        this.tupleIndexBuilder = new BuilderStdDB.TupleIndexBuilderStd(rangeIndexBuilder);
    }

    private DatasetGraphTDB build(Location location, StoreParams config) {
        DatasetControl policy = this.createConcurrencyPolicy();
        this.params = config;
        if (config == null) {
            this.params = StoreParams.getDftStoreParams();
        }
        NodeTable nodeTable = this.makeNodeTable(location, this.params.getIndexNode2Id(), this.params.getIndexId2Node(), -1, -1, -1);
        TripleTable tripleTable = this.makeTripleTable(location, nodeTable, policy);
        QuadTable quadTable = this.makeQuadTable(location, nodeTable, policy);
        DatasetPrefixesTDB prefixes = this.makePrefixTable(location, policy);
        ReorderTransformation transform = this.chooseReorderTransformation(location);
        DatasetGraphTDB dsg = new DatasetGraphTDB(tripleTable, quadTable, prefixes, transform, null);
        dsg.getContext().set(ARQ.optFilterPlacementBGP, false);
        QC.setFactory(dsg.getContext(), OpExecutorTDB1.OpExecFactoryTDB);
        return dsg;
    }

    private DatasetControl createConcurrencyPolicy() {
        return new DatasetControlMRSW();
    }

    private ReorderTransformation chooseReorderTransformation(Location location) {
        return DatasetBuilderStd.chooseOptimizer(location);
    }

    protected NodeTable makeNodeTable(Location location, String indexNode2Id, String indexId2Node, int sizeNode2NodeIdCache, int sizeNodeId2NodeCache, int sizeNodeMissCache) {
        FileSet fsNodeToId = new FileSet(location, indexNode2Id);
        FileSet fsId2Node = new FileSet(location, indexId2Node);
        NodeTable nt = this.nodeTableBuilder.buildNodeTable(fsNodeToId, fsId2Node, this.params);
        return nt;
    }

    private TripleTable makeTripleTable(Location location, NodeTable nodeTable, DatasetControl policy) {
        String primary = this.params.getPrimaryIndexTriples();
        String[] indexes = this.params.getTripleIndexes();
        if (indexes.length != 3) {
            DatasetBuilderBasic.error(log, "Wrong number of triple table indexes: " + StrUtils.strjoin(",", indexes));
        }
        log.debug("Triple table: " + primary + " :: " + StrUtils.strjoin(",", indexes));
        TupleIndex[] tripleIndexes = this.makeTupleIndexes(location, primary, indexes);
        if (tripleIndexes.length != indexes.length) {
            DatasetBuilderBasic.error(log, "Wrong number of triple table tuples indexes: " + tripleIndexes.length);
        }
        TripleTable tripleTable = new TripleTable(tripleIndexes, nodeTable, policy);
        return tripleTable;
    }

    private QuadTable makeQuadTable(Location location, NodeTable nodeTable, DatasetControl policy) {
        String primary = this.params.getPrimaryIndexQuads();
        String[] indexes = this.params.getQuadIndexes();
        if (indexes.length != 6) {
            DatasetBuilderBasic.error(log, "Wrong number of quad table indexes: " + StrUtils.strjoin(",", indexes));
        }
        log.debug("Quad table: " + primary + " :: " + StrUtils.strjoin(",", indexes));
        TupleIndex[] quadIndexes = this.makeTupleIndexes(location, primary, indexes);
        if (quadIndexes.length != indexes.length) {
            DatasetBuilderBasic.error(log, "Wrong number of quad table tuples indexes: " + quadIndexes.length);
        }
        QuadTable quadTable = new QuadTable(quadIndexes, nodeTable, policy);
        return quadTable;
    }

    private DatasetPrefixesTDB makePrefixTable(Location location, DatasetControl policy) {
        String primary = this.params.getPrimaryIndexPrefix();
        String[] indexes = this.params.getPrefixIndexes();
        TupleIndex[] prefixIndexes = this.makeTupleIndexes(location, primary, indexes, new String[]{this.params.getIndexPrefix()});
        if (prefixIndexes.length != 1) {
            DatasetBuilderBasic.error(log, "Wrong number of triple table tuples indexes: " + prefixIndexes.length);
        }
        String pnNode2Id = this.params.getPrefixNode2Id();
        String pnId2Node = this.params.getPrefixId2Node();
        NodeTable prefixNodes = this.makeNodeTable(location, pnNode2Id, pnId2Node, -1, -1, -1);
        NodeTupleTableConcrete prefixTable = new NodeTupleTableConcrete(primary.length(), prefixIndexes, prefixNodes, policy);
        DatasetPrefixesTDB prefixes = new DatasetPrefixesTDB(prefixTable);
        log.debug("Prefixes: " + primary + " :: " + StrUtils.strjoin(",", indexes));
        return prefixes;
    }

    private TupleIndex[] makeTupleIndexes(Location location, String primary, String[] indexNames) {
        return this.makeTupleIndexes(location, primary, indexNames, indexNames);
    }

    private TupleIndex[] makeTupleIndexes(Location location, String primary, String[] indexNames, String[] filenames) {
        if (primary.length() != 3 && primary.length() != 4) {
            DatasetBuilderBasic.error(log, "Bad primary key length: " + primary.length());
        }
        int indexRecordLen = primary.length() * 8;
        TupleIndex[] indexes = new TupleIndex[indexNames.length];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = this.makeTupleIndex(location, filenames[i], primary, indexNames[i]);
        }
        return indexes;
    }

    private TupleIndex makeTupleIndex(Location location, String name, String primary, String indexOrder) {
        FileSet fs = new FileSet(location, name);
        ColumnMap colMap = new ColumnMap(primary, indexOrder);
        return this.tupleIndexBuilder.buildTupleIndex(fs, colMap, indexOrder, this.params);
    }

    private static void error(Logger log, String msg) {
        if (log != null) {
            log.error(msg);
        }
        throw new TDBException(msg);
    }
}

