/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.assembler;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.assembler.exceptions.AssemblerException;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.sparql.util.graph.GraphUtils;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.TDBFactory;
import com.hp.hpl.jena.tdb.assembler.DatasetAssemblerTDB;
import com.hp.hpl.jena.tdb.assembler.IndexAssembler;
import com.hp.hpl.jena.tdb.assembler.VocabTDB;
import com.hp.hpl.jena.tdb.base.file.Location;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.riot.out.NodeFmtLib;

public class TDBGraphAssembler
extends AssemblerBase
implements Assembler {
    static IndexAssembler indexAssembler = null;

    @Override
    public Model open(Assembler a, Resource root, Mode mode) {
        Dataset ds;
        TDB.init();
        String locationDir = GraphUtils.getStringValue(root, VocabTDB.pLocation);
        Resource dataset = GraphUtils.getResourceValue(root, VocabTDB.pDataset);
        if (locationDir != null && dataset != null) {
            throw new AssemblerException(root, "Both location and dataset given: exactly one required");
        }
        if (locationDir == null && dataset == null) {
            throw new AssemblerException(root, "Must give location or refer to a dataset description");
        }
        String graphName = null;
        if (root.hasProperty(VocabTDB.pGraphName1)) {
            graphName = GraphUtils.getAsStringValue(root, VocabTDB.pGraphName1);
        }
        if (root.hasProperty(VocabTDB.pGraphName2)) {
            graphName = GraphUtils.getAsStringValue(root, VocabTDB.pGraphName2);
        }
        if (root.hasProperty(VocabTDB.pIndex)) {
            Log.warn(this, "Custom indexes not implemented yet - ignored");
        }
        if (locationDir != null) {
            Location location = Location.create(locationDir);
            ds = TDBFactory.createDataset(location);
        } else {
            ds = DatasetAssemblerTDB.make(dataset);
        }
        try {
            if (graphName != null) {
                return ds.getNamedModel(graphName);
            }
            return ds.getDefaultModel();
        }
        catch (RuntimeException ex) {
            ex.printStackTrace(System.err);
            throw ex;
        }
    }

    private void indexes(Resource root) {
        StmtIterator sIter = root.listProperties(VocabTDB.pIndex);
        while (sIter.hasNext()) {
            RDFNode obj = sIter.nextStatement().getObject();
            if (obj.isLiteral()) {
                String desc = ((Literal)obj).getString();
                System.out.printf("Index: %s\n", desc);
                System.out.flush();
                continue;
            }
            throw new TDBException("Wrong format for tdb:index: should be a string: found: " + NodeFmtLib.displayStr(obj));
        }
        System.out.flush();
        throw new TDBException("Custom indexes turned off");
    }
}

