/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.ReadWrite;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.tdb.StoreConnection;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.TDBFactory;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.transaction.DatasetGraphTxn;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;

public class TDBBackup {
    public static void backup(Location location, String backupfile) {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(backupfile));){
            TDBBackup.backup(location, out);
        }
        catch (FileNotFoundException e2) {
            Log.warn(TDBBackup.class, "File not found: " + backupfile);
            throw new TDBException("File not found: " + backupfile);
        }
        catch (IOException e3) {
            IO.exception(e3);
        }
    }

    public static void backup(Location location, OutputStream backupfile) {
        Dataset ds = TDBFactory.createDataset(location);
        StoreConnection sConn = StoreConnection.make(location);
        DatasetGraphTxn dsg = sConn.begin(ReadWrite.READ, "backup");
        RDFDataMgr.write(backupfile, (DatasetGraph)dsg, Lang.NQUADS);
        dsg.end();
    }
}

