/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_Literal;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.NodeToLabelMap;
import com.hp.hpl.jena.sparql.util.NodeToLabelMapBNode;
import com.hp.hpl.jena.sparql.util.NodeUtils;
import com.hp.hpl.jena.vocabulary.XSD;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIFactory;

public class FmtUtils {
    static final String indentPrefix = "  ";
    public static boolean multiLineExpr = false;
    public static boolean printOpName = true;
    static NodeToLabelMap bNodeMap = new NodeToLabelMapBNode("b", false);
    private static int relFlags = 9;
    private static Pattern schemePattern = Pattern.compile("[A-Za-z]+:");
    static boolean applyUnicodeEscapes = false;

    public static SerializationContext sCxt() {
        return FmtUtils.sCxt(ARQConstants.getGlobalPrefixMap());
    }

    public static SerializationContext sCxt(PrefixMapping pmap) {
        return new SerializationContext(pmap);
    }

    public static String stringForTriple(Triple triple) {
        StringBuilder result = new StringBuilder();
        FmtUtils.stringForNode(result, triple.getSubject());
        result.append(" ");
        FmtUtils.stringForNode(result, triple.getPredicate());
        result.append(" ");
        FmtUtils.stringForNode(result, triple.getObject());
        return result.toString();
    }

    public static String stringForTriple(Triple triple, PrefixMapping prefixMap) {
        return FmtUtils.stringForTriple(triple, FmtUtils.sCxt(prefixMap));
    }

    public static String stringForTriple(Triple triple, SerializationContext sCxt) {
        StringBuilder result = new StringBuilder();
        FmtUtils.stringForTriple(result, triple, sCxt);
        return result.toString();
    }

    public static void stringForTriple(StringBuilder result, Triple triple, SerializationContext sCxt) {
        FmtUtils.stringForNode(result, triple.getSubject(), sCxt);
        result.append(" ");
        FmtUtils.stringForNode(result, triple.getPredicate(), sCxt);
        result.append(" ");
        FmtUtils.stringForNode(result, triple.getObject(), sCxt);
    }

    public static String stringForQuad(Quad quad, PrefixMapping prefixMap) {
        return FmtUtils.stringForQuad(quad, FmtUtils.sCxt(prefixMap));
    }

    public static String stringForQuad(Quad quad) {
        StringBuilder sb = new StringBuilder();
        if (quad.getGraph() != null) {
            sb.append(FmtUtils.stringForNode(quad.getGraph()));
            sb.append(" ");
        }
        FmtUtils.stringForNode(sb, quad.getSubject());
        sb.append(" ");
        FmtUtils.stringForNode(sb, quad.getPredicate());
        sb.append(" ");
        FmtUtils.stringForNode(sb, quad.getObject());
        return sb.toString();
    }

    public static String stringForQuad(Quad quad, SerializationContext sCxt) {
        StringBuilder sb = new StringBuilder();
        FmtUtils.stringForQuad(sb, quad, sCxt);
        return sb.toString();
    }

    public static void stringForQuad(StringBuilder sb, Quad quad, SerializationContext sCxt) {
        if (quad.getGraph() != null) {
            sb.append(FmtUtils.stringForNode(quad.getGraph(), sCxt));
            sb.append(" ");
        }
        FmtUtils.stringForNode(sb, quad.getSubject(), sCxt);
        sb.append(" ");
        FmtUtils.stringForNode(sb, quad.getPredicate(), sCxt);
        sb.append(" ");
        FmtUtils.stringForNode(sb, quad.getObject(), sCxt);
    }

    public static void formatPattern(IndentedWriter out, BasicPattern pattern, SerializationContext sCxt) {
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        for (Triple triple : pattern) {
            if (!first) {
                buffer.append("\n");
            }
            FmtUtils.stringForTriple(buffer, triple, sCxt);
            buffer.append(" .");
            out.print(buffer.toString());
            buffer.setLength(0);
            first = false;
        }
    }

    public static String stringForObject(Object obj) {
        if (obj == null) {
            return "<<null>>";
        }
        if (obj instanceof RDFNode) {
            return FmtUtils.stringForRDFNode((RDFNode)obj);
        }
        if (obj instanceof Node) {
            return FmtUtils.stringForNode((Node)obj);
        }
        return obj.toString();
    }

    public static String stringForRDFNode(RDFNode obj) {
        Model m = null;
        if (obj instanceof Resource) {
            m = obj.getModel();
        }
        return FmtUtils.stringForRDFNode(obj, FmtUtils.newSerializationContext(m));
    }

    public static String stringForRDFNode(RDFNode obj, SerializationContext context) {
        return FmtUtils.stringForNode(obj.asNode(), context);
    }

    public static String stringForLiteral(Node_Literal literal, SerializationContext context) {
        StringBuilder result = new StringBuilder();
        FmtUtils.stringForLiteral(result, literal, context);
        return result.toString();
    }

    public static void stringForLiteral(StringBuilder result, Node_Literal literal, SerializationContext context) {
        String datatype = literal.getLiteralDatatypeURI();
        String lang = literal.getLiteralLanguage();
        String s = literal.getLiteralLexicalForm();
        if (datatype != null && (context == null || context.getUsePlainLiterals())) {
            if (datatype.equals(XSD.integer.getURI())) {
                try {
                    String s1 = s;
                    if (s.startsWith("+")) {
                        s1 = s.substring(1);
                    }
                    new BigInteger(s1);
                    result.append(s);
                    return;
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (datatype.equals(XSD.decimal.getURI()) && s.indexOf(46) > 0) {
                try {
                    new BigDecimal(s);
                    result.append(s);
                    return;
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (datatype.equals(XSD.xdouble.getURI()) && (s.indexOf(101) >= 0 || s.indexOf(69) >= 0)) {
                try {
                    Double.parseDouble(s);
                    result.append(s);
                    return;
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (datatype.equals(XSD.xboolean.getURI()) && (s.equals("true") || s.equals("false"))) {
                result.append(s);
                return;
            }
        }
        result.append("\"");
        FmtUtils.stringEsc(result, s, true);
        result.append("\"");
        if (NodeUtils.isSimpleString(literal)) {
            return;
        }
        if (NodeUtils.isLangString(literal)) {
            result.append("@");
            result.append(lang);
            return;
        }
        if (datatype != null) {
            result.append("^^");
            FmtUtils.stringForURI(result, datatype, context);
        }
    }

    public static String stringForString(String str2) {
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("\"");
        FmtUtils.stringEsc(sbuff, str2, true);
        sbuff.append("\"");
        return sbuff.toString();
    }

    public static String stringForResource(Resource r) {
        return FmtUtils.stringForResource(r, FmtUtils.newSerializationContext(r.getModel()));
    }

    public static String stringForResource(Resource r, SerializationContext context) {
        return FmtUtils.stringForNode(r.asNode(), context);
    }

    public static String stringForNode(Node n) {
        StringBuilder sb = new StringBuilder();
        FmtUtils.stringForNode(sb, n, ARQConstants.getGlobalPrefixMap());
        return sb.toString();
    }

    public static void stringForNode(StringBuilder result, Node n) {
        FmtUtils.stringForNode(result, n, ARQConstants.getGlobalPrefixMap());
    }

    public static String stringForNode(Node n, PrefixMapping prefixMap) {
        StringBuilder sb = new StringBuilder();
        FmtUtils.stringForNode(sb, n, FmtUtils.newSerializationContext(prefixMap));
        return sb.toString();
    }

    public static void stringForNode(StringBuilder result, Node n, PrefixMapping prefixMap) {
        FmtUtils.stringForNode(result, n, FmtUtils.newSerializationContext(prefixMap));
    }

    public static String stringForNode(Node n, Prologue prologue) {
        StringBuilder sb = new StringBuilder();
        FmtUtils.stringForNode(sb, n, FmtUtils.newSerializationContext(prologue));
        return sb.toString();
    }

    public static String stringForNode(Node n, SerializationContext context) {
        StringBuilder sb = new StringBuilder();
        FmtUtils.stringForNode(sb, n, context);
        return sb.toString();
    }

    public static void stringForNode(StringBuilder result, Node n, SerializationContext context) {
        String str2;
        if (n == null) {
            result.append("<<null>>");
            return;
        }
        if (context != null && context.getBNodeMap() != null && (str2 = context.getBNodeMap().asString(n)) != null) {
            result.append(str2);
            return;
        }
        if (n.isBlank()) {
            result.append("_:").append(n.getBlankNodeLabel());
        } else if (n.isLiteral()) {
            FmtUtils.stringForLiteral(result, (Node_Literal)n, context);
        } else if (n.isURI()) {
            String uri = n.getURI();
            FmtUtils.stringForURI(result, uri, context);
        } else if (n.isVariable()) {
            result.append("?").append(n.getName());
        } else if (n.equals(Node.ANY)) {
            result.append("ANY");
        } else {
            Log.warn(FmtUtils.class, "Failed to turn a node into a string: " + n);
            result.append(n.toString());
        }
    }

    public static String stringForURI(String uri) {
        StringBuilder sb = new StringBuilder();
        FmtUtils.stringForURI(sb, uri);
        return sb.toString();
    }

    public static void stringForURI(StringBuilder target, String uri) {
        target.append("<");
        FmtUtils.stringEsc(target, uri);
        target.append(">");
    }

    public static String stringForURI(String uri, Prologue prologue) {
        return FmtUtils.stringForURI(uri, prologue.getBaseURI(), prologue.getPrefixMapping());
    }

    public static String stringForURI(String uri, String baseIRI) {
        return FmtUtils.stringForURI(uri, baseIRI, null);
    }

    public static String stringForURI(String uri, SerializationContext context) {
        if (context == null) {
            return FmtUtils.stringForURI(uri, null, null);
        }
        return FmtUtils.stringForURI(uri, context.getBaseIRI(), context.getPrefixMapping());
    }

    public static void stringForURI(StringBuilder result, String uri, SerializationContext context) {
        if (context == null) {
            FmtUtils.stringForURI(result, uri, null, null);
        } else {
            FmtUtils.stringForURI(result, uri, context.getBaseIRI(), context.getPrefixMapping());
        }
    }

    public static String stringForURI(String uri, PrefixMapping mapping) {
        return FmtUtils.stringForURI(uri, null, mapping);
    }

    public static String stringForURI(String uri, String base, PrefixMapping mapping) {
        StringBuilder result = new StringBuilder();
        FmtUtils.stringForURI(result, uri, base, mapping);
        return result.toString();
    }

    public static void stringForURI(StringBuilder result, String uri, String base, PrefixMapping mapping) {
        String x;
        String pname;
        if (mapping != null && (pname = FmtUtils.prefixFor(uri, mapping)) != null) {
            result.append(pname);
            return;
        }
        if (base != null && (x = FmtUtils.abbrevByBase(uri, base)) != null) {
            result.append("<");
            result.append(x);
            result.append(">");
            return;
        }
        FmtUtils.stringForURI(result, uri);
    }

    public static String abbrevByBase(String uri, String base) {
        if (FmtUtils.hasScheme(uri)) {
            return uri;
        }
        IRI baseIRI = IRIFactory.jenaImplementation().construct(base);
        IRI rel = baseIRI.relativize(uri, relFlags);
        String r = rel.toString();
        return r;
    }

    private static boolean hasScheme(String uriStr) {
        return schemePattern.matcher(uriStr).matches();
    }

    private static String prefixFor(String uri, PrefixMapping mapping) {
        if (mapping == null) {
            return null;
        }
        String pname = mapping.shortForm(uri);
        if (pname != uri && FmtUtils.checkValidPrefixName(pname)) {
            return pname;
        }
        pname = mapping.qnameFor(uri);
        if (pname != null && FmtUtils.checkValidPrefixName(pname)) {
            return pname;
        }
        return null;
    }

    private static boolean checkValidPrefixName(String prefixedName) {
        int i = prefixedName.indexOf(58);
        if (i < 0) {
            throw new ARQInternalErrorException("Broken short form -- " + prefixedName);
        }
        String p = prefixedName.substring(0, i);
        String x = prefixedName.substring(i + 1);
        return FmtUtils.checkValidPrefix(p) && FmtUtils.checkValidLocalname(x);
    }

    private static boolean checkValidPrefix(String prefixStr) {
        if (prefixStr.startsWith("_")) {
            return false;
        }
        return FmtUtils.checkValidLocalname(prefixStr);
    }

    private static boolean checkValidLocalname(String localname2) {
        if (localname2.length() == 0) {
            return true;
        }
        for (int idx = 0; idx < localname2.length(); ++idx) {
            char ch = localname2.charAt(idx);
            if (FmtUtils.validPNameChar(ch)) continue;
            return false;
        }
        if (localname2.endsWith(".")) {
            return false;
        }
        return !localname2.startsWith(".");
    }

    private static boolean validPNameChar(char ch) {
        if (Character.isLetterOrDigit(ch)) {
            return true;
        }
        if (ch == '.') {
            return true;
        }
        if (ch == '-') {
            return true;
        }
        return ch == '_';
    }

    public static String stringEsc(String s) {
        return FmtUtils.stringEsc(s, true);
    }

    public static String stringEsc(String s, boolean singleLineString) {
        StringBuilder sb = new StringBuilder();
        FmtUtils.stringEsc(sb, s, singleLineString);
        return sb.toString();
    }

    public static void stringEsc(StringBuilder sbuff, String s) {
        FmtUtils.stringEsc(sbuff, s, true);
    }

    public static void stringEsc(StringBuilder sbuff, String s, boolean singleLineString) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '\"') {
                sbuff.append('\\');
                sbuff.append(c);
                continue;
            }
            if (singleLineString && (c == '\n' || c == '\r' || c == '\f' || c == '\t')) {
                if (c == '\n') {
                    sbuff.append("\\n");
                }
                if (c == '\t') {
                    sbuff.append("\\t");
                }
                if (c == '\r') {
                    sbuff.append("\\r");
                }
                if (c != '\f') continue;
                sbuff.append("\\f");
                continue;
            }
            if (!applyUnicodeEscapes) {
                sbuff.append(c);
                continue;
            }
            if (c >= ' ' && c < '\u007f') {
                sbuff.append(c);
                continue;
            }
            String hexstr = Integer.toHexString(c).toUpperCase(Locale.ROOT);
            sbuff.append("\\u");
            for (int pad = 4 - hexstr.length(); pad > 0; --pad) {
                sbuff.append("0");
            }
            sbuff.append(hexstr);
        }
    }

    public static void resetBNodeLabels() {
        bNodeMap = new NodeToLabelMapBNode("b", false);
    }

    private static SerializationContext newSerializationContext(PrefixMapping prefixMapping) {
        return new SerializationContext(prefixMapping, bNodeMap);
    }

    private static SerializationContext newSerializationContext(Prologue prologue) {
        return new SerializationContext(prologue, bNodeMap);
    }
}

