/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.pfunction.library;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.query.QueryBuildException;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.pfunction.PropFuncArg;
import com.hp.hpl.jena.sparql.pfunction.PropFuncArgType;
import com.hp.hpl.jena.sparql.pfunction.PropertyFunctionEval;
import com.hp.hpl.jena.sparql.util.IterLib;
import com.hp.hpl.jena.sparql.util.NodeUtils;
import com.hp.hpl.jena.sparql.util.Utils;
import org.apache.jena.atlas.logging.Log;

public class splitIRI
extends PropertyFunctionEval {
    public splitIRI() {
        super(PropFuncArgType.PF_ARG_SINGLE, PropFuncArgType.PF_ARG_LIST);
    }

    @Override
    public void build(PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        if (argSubject.isList()) {
            throw new QueryBuildException(Utils.className(this) + "Subject must be a single node or variable, not a list");
        }
        if (!argObject.isList()) {
            throw new QueryBuildException(Utils.className(this) + "Object must be a list of two elements");
        }
        if (argObject.getArgList().size() != 2) {
            throw new QueryBuildException(Utils.className(this) + "Object is a list but it has " + argObject.getArgList().size() + " elements - should be 2");
        }
    }

    @Override
    public QueryIterator execEvaluated(Binding binding, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        try {
            if (argSubject.getArg().isLiteral() || argSubject.getArg().isBlank()) {
                return IterLib.noResults(execCxt);
            }
            if (argSubject.getArg().isURI()) {
                return this.subjectIsIRI(argSubject.getArg(), argObject, binding, execCxt);
            }
            return this.subjectIsVariable(argSubject.getArg(), argObject, execCxt);
        }
        catch (QueryException ex) {
            Log.warn(this, "Unexpected problems in splitIRI: " + ex.getMessage());
            return null;
        }
    }

    private QueryIterator subjectIsIRI(Node subject, PropFuncArg argObject, Binding binding, ExecutionContext execCxt) {
        String namespace2 = subject.getNameSpace();
        String localname2 = subject.getLocalName();
        Node namespaceNode = argObject.getArg(0);
        Node localnameNode = argObject.getArg(1);
        BindingMap b = null;
        if (Var.isVar(namespaceNode) || Var.isVar(localnameNode)) {
            b = BindingFactory.create(binding);
        }
        if (Var.isVar(namespaceNode)) {
            b.add(Var.alloc(namespaceNode), NodeFactory.createURI(namespace2));
            if (localnameNode.isVariable() && namespaceNode.getName() == localnameNode.getName()) {
                localnameNode = NodeFactory.createURI(namespace2);
            }
        } else {
            String ns = null;
            if (namespaceNode.isURI()) {
                ns = namespaceNode.getURI();
            }
            if (namespaceNode.isLiteral()) {
                ns = NodeUtils.stringLiteral(namespaceNode);
            }
            if (ns == null || !ns.equals(namespace2)) {
                return IterLib.noResults(execCxt);
            }
        }
        if (Var.isVar(localnameNode)) {
            b.add(Var.alloc(localnameNode), NodeFactory.createLiteral(localname2));
        } else {
            String lc = NodeUtils.stringLiteral(localnameNode);
            if (lc == null || !lc.equals(localname2)) {
                return IterLib.noResults(execCxt);
            }
        }
        Binding b2 = b == null ? binding : b;
        return IterLib.result(b, execCxt);
    }

    private QueryIterator subjectIsVariable(Node arg, PropFuncArg argObject, ExecutionContext execCxt) {
        Log.warn(this, "Subject to property function splitURI is not a bound nor a constant.");
        return IterLib.noResults(execCxt);
    }
}

