/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.lang;

import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.sparql.lang.UpdateParser;
import com.hp.hpl.jena.sparql.lang.arq.ARQParser;
import com.hp.hpl.jena.sparql.lang.arq.ParseException;
import com.hp.hpl.jena.sparql.lang.arq.TokenMgrError;
import com.hp.hpl.jena.sparql.modify.UpdateSink;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import org.slf4j.LoggerFactory;

public class ParserARQUpdate
extends UpdateParser {
    @Override
    protected void parse$(UpdateSink sink, String queryString) {
        StringReader r = new StringReader(queryString);
        this._parse(sink, r);
    }

    @Override
    protected void parse$(UpdateSink sink, Reader r) {
        this._parse(sink, r);
    }

    public void parse(UpdateSink sink, Reader r) {
        if (r instanceof FileReader) {
            LoggerFactory.getLogger(this.getClass()).warn("FileReader passed to ParserSPARQLUpdate.parse - use a FileInputStream");
        }
        this._parse(sink, r);
    }

    private void _parse(UpdateSink sink, Reader r) {
        ARQParser parser = null;
        try {
            parser = new ARQParser(r);
            parser.setUpdateSink(sink);
            parser.UpdateUnit();
        }
        catch (ParseException ex) {
            throw new QueryParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginColumn);
        }
        catch (TokenMgrError tErr) {
            int col = parser.token.endColumn;
            int line = parser.token.endLine;
            throw new QueryParseException(tErr.getMessage(), line, col);
        }
        catch (QueryException ex) {
            throw ex;
        }
        catch (JenaException ex) {
            throw new QueryException(ex.getMessage(), ex);
        }
    }
}

