/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.main;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Substitute;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterBlockTriples;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPeek;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterRoot;
import com.hp.hpl.jena.sparql.engine.main.StageBuilder;
import com.hp.hpl.jena.sparql.engine.main.StageGenerator;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.ReorderLib;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.ReorderProc;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import com.hp.hpl.jena.sparql.mgt.Explain;
import com.hp.hpl.jena.sparql.util.Utils;
import org.apache.jena.atlas.logging.Log;

public class StageGeneratorGeneric
implements StageGenerator {
    private static final ReorderTransformation reorderFixed = ReorderLib.fixed();

    @Override
    public QueryIterator execute(BasicPattern pattern, QueryIterator input, ExecutionContext execCxt) {
        if (input == null) {
            Log.fatal(this, "Null input to " + Utils.classShortName(this.getClass()));
        }
        Graph graph = execCxt.getActiveGraph();
        ReorderTransformation reorder = reorderFixed;
        StageGenerator executor = StageBuilder.executeInline;
        return this.execute(pattern, reorder, executor, input, execCxt);
    }

    protected QueryIterator execute(BasicPattern pattern, ReorderTransformation reorder, StageGenerator execution, QueryIterator input, ExecutionContext execCxt) {
        Explain.explain(pattern, execCxt.getContext());
        if (!input.hasNext()) {
            return input;
        }
        if (reorder != null && pattern.size() >= 2) {
            BasicPattern bgp2 = pattern;
            if (!(input instanceof QueryIterRoot)) {
                QueryIterPeek peek = QueryIterPeek.create(input, execCxt);
                Binding b = peek.peek();
                input = peek;
                bgp2 = Substitute.substitute(pattern, b);
                ReorderProc reorderProc = reorder.reorderIndexes(bgp2);
                pattern = reorderProc.reorder(pattern);
            }
        }
        Explain.explain("Reorder/generic", pattern, execCxt.getContext());
        return QueryIterBlockTriples.create(input, pattern, execCxt);
    }
}

