/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.path.P_Link;
import com.hp.hpl.jena.sparql.path.Path;
import org.apache.jena.atlas.logging.Log;

public final class TriplePath {
    private final Node subject;
    private final Node predicate;
    private final Path path;
    private final Node object;
    private Triple triple = null;
    private int hash = -1;

    public TriplePath(Node s, Path path, Node o) {
        this.subject = s;
        this.object = o;
        if (path instanceof P_Link) {
            this.predicate = ((P_Link)path).getNode();
            this.triple = new Triple(this.subject, this.predicate, o);
        } else {
            this.predicate = null;
        }
        this.path = path;
    }

    public TriplePath(Triple triple) {
        this.subject = triple.getSubject();
        Node p = triple.getPredicate();
        if (p.isURI()) {
            this.path = new P_Link(triple.getPredicate());
            this.predicate = p;
        } else {
            this.path = null;
            this.predicate = triple.getPredicate();
        }
        this.object = triple.getObject();
        this.triple = triple;
        if (triple.getPredicate() == null) {
            Log.warn(this, "Triple predicate is null");
        }
    }

    public Node getSubject() {
        return this.subject;
    }

    public Path getPath() {
        return this.path;
    }

    public Node getPredicate() {
        return this.predicate;
    }

    public Node getObject() {
        return this.object;
    }

    public boolean isTriple() {
        return this.triple != null || this.predicate != null;
    }

    public Triple asTriple() {
        if (this.triple != null) {
            return this.triple;
        }
        if (this.path instanceof P_Link) {
            this.triple = new Triple(this.subject, ((P_Link)this.path).getNode(), this.object);
        }
        return this.triple;
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.hash = this.isTriple() ? this.asTriple().hashCode() : this.subject.hashCode() << 2 ^ this.path.hashCode() ^ this.object.hashCode() << 1;
        }
        return this.hash;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TriplePath)) {
            return false;
        }
        TriplePath tp = (TriplePath)other;
        if (tp.isTriple() ^ this.isTriple()) {
            return false;
        }
        if (this.isTriple()) {
            return this.asTriple().equals(tp.asTriple());
        }
        return this.subject.equals(tp.subject) && this.object.equals(tp.object) && this.path.equals(tp.path);
    }

    public String toString() {
        if (this.path != null) {
            return this.subject + " (" + this.path + ") " + this.object;
        }
        return this.subject + " " + this.predicate + " " + this.object;
    }
}

