/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.optimize;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVars;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.op.Op1;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpConditional;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinctReduced;
import com.hp.hpl.jena.sparql.algebra.op.OpExtend;
import com.hp.hpl.jena.sparql.algebra.op.OpExtendAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpSequence;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprLib;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.util.VarUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.jena.atlas.lib.CollectionUtils;
import org.apache.jena.atlas.lib.DS;
import org.apache.jena.atlas.lib.Lib;

public class TransformFilterPlacement
extends TransformCopy {
    static final ExprList emptyList = ExprList.emptyList;
    static final Placement noChangePlacement = null;
    private final boolean includeBGPs;
    static boolean pushRightAsWellAsLeft = true;

    private static Placement result(Op op, ExprList remaining) {
        if (op == null) {
            return null;
        }
        return new Placement(op, remaining);
    }

    private Placement resultNoChange(Op original) {
        return noChangePlacement;
    }

    private boolean isNoChange(Placement placement) {
        return placement == noChangePlacement;
    }

    public static Op transform(ExprList exprs, BasicPattern bgp) {
        Op op;
        Placement placement = TransformFilterPlacement.placeBGP(exprs, bgp);
        Op op2 = op = placement == null ? new OpBGP(bgp) : placement.op;
        if (placement != null) {
            op = TransformFilterPlacement.buildFilter(placement.unplaced, op);
        }
        return op;
    }

    public static Op transform(ExprList exprs, Node graphNode, BasicPattern bgp) {
        Op op;
        Placement placement = TransformFilterPlacement.placeQuadPattern(exprs, graphNode, bgp);
        Op op2 = op = placement == null ? new OpQuadPattern(graphNode, bgp) : placement.op;
        if (placement != null) {
            op = TransformFilterPlacement.buildFilter(placement.unplaced, op);
        }
        return op;
    }

    public TransformFilterPlacement() {
        this(true);
    }

    public TransformFilterPlacement(boolean includeBGPs) {
        this.includeBGPs = includeBGPs;
    }

    public static Placement filterPlacement$(ExprList exprs, Op op) {
        TransformFilterPlacement t = new TransformFilterPlacement();
        return t.transform(exprs, op);
    }

    @Override
    public Op transform(OpFilter opFilter, Op x) {
        Placement placement;
        ExprList exprs = opFilter.getExprs();
        ExprList exprs2 = null;
        for (Expr expr : exprs) {
            if (ExprLib.isStable(expr)) continue;
            if (exprs2 == null) {
                exprs2 = new ExprList();
            }
            exprs2.add(expr);
        }
        if (exprs2 != null) {
            ExprList exprs1 = new ExprList();
            for (Expr expr : exprs) {
                if (!ExprLib.isStable(expr)) continue;
                exprs1.add(expr);
            }
            exprs = exprs1;
        }
        if ((placement = this.transform(exprs, x)) == null) {
            return super.transform(opFilter, x);
        }
        Op op = TransformFilterPlacement.buildFilter(placement);
        if (exprs2 != null) {
            op = OpFilter.filter(exprs2, op);
        }
        return op;
    }

    private Op transformOpAlways(ExprList exprs, Op x) {
        Placement placement = this.transform(exprs, x);
        if (placement == null) {
            return TransformFilterPlacement.buildFilter(exprs, x);
        }
        return TransformFilterPlacement.buildFilter(placement);
    }

    private Placement transform(ExprList exprs, Op input) {
        Placement placement = noChangePlacement;
        if (input instanceof OpBGP) {
            placement = this.placeOrWrapBGP(exprs, (OpBGP)input);
        } else if (input instanceof OpQuadPattern) {
            placement = this.placeOrWrapQuadPattern(exprs, (OpQuadPattern)input);
        } else if (input instanceof OpSequence) {
            placement = this.placeSequence(exprs, (OpSequence)input);
        } else if (input instanceof OpJoin) {
            placement = this.placeJoin(exprs, (OpJoin)input);
        } else if (input instanceof OpConditional) {
            placement = this.placeConditional(exprs, (OpConditional)input);
        } else if (input instanceof OpLeftJoin) {
            placement = this.placeLeftJoin(exprs, (OpLeftJoin)input);
        } else if (input instanceof OpFilter) {
            placement = this.placeFilter(exprs, (OpFilter)input);
        } else if (input instanceof OpUnion) {
            placement = this.placeUnion(exprs, (OpUnion)input);
        } else if (input instanceof OpExtend) {
            placement = this.placeExtend(exprs, (OpExtend)input);
        } else if (input instanceof OpAssign) {
            placement = this.placeAssign(exprs, (OpAssign)input);
        } else if (input instanceof OpProject) {
            placement = this.placeProject(exprs, (OpProject)input);
        } else if (input instanceof OpDistinctReduced) {
            placement = this.placeDistinctReduced(exprs, (OpDistinctReduced)input);
        } else if (input instanceof OpTable) {
            placement = this.placeTable(exprs, (OpTable)input);
        }
        return placement;
    }

    private Placement placeFilter(ExprList exprs, OpFilter input) {
        Op op = input.getSubOp();
        ExprList exprsInner = input.getExprs();
        ExprList exprsOuter = exprs;
        Placement p = this.transform(exprsOuter, input.getSubOp());
        if (p != null) {
            op = p.op;
            exprsOuter = p.unplaced;
        }
        Op f = OpFilter.filter(exprsInner, op);
        return new Placement(f, exprsOuter);
    }

    private Placement placeOrWrapBGP(ExprList exprs, OpBGP x) {
        return this.placeOrWrapBGP(exprs, x.getPattern());
    }

    private Placement placeOrWrapBGP(ExprList exprsIn, BasicPattern pattern) {
        if (this.includeBGPs) {
            return TransformFilterPlacement.placeBGP(exprsIn, pattern);
        }
        return this.wrapBGP(exprsIn, pattern);
    }

    private static Placement placeBGP(ExprList exprsIn, BasicPattern pattern) {
        ExprList exprs = ExprList.copy(exprsIn);
        Set<Var> patternVarsScope = DS.set();
        Op op = TransformFilterPlacement.insertAnyFilter$(exprs, patternVarsScope, null);
        for (Triple triple : pattern) {
            OpBGP opBGP = TransformFilterPlacement.getBGP(op);
            if (opBGP == null) {
                opBGP = new OpBGP();
                op = OpSequence.create(op, opBGP);
            }
            opBGP.getPattern().add(triple);
            VarUtils.addVarsFromTriple(patternVarsScope, triple);
            op = TransformFilterPlacement.insertAnyFilter$(exprs, patternVarsScope, op);
        }
        return TransformFilterPlacement.result(op, exprs);
    }

    private Placement wrapBGP(ExprList exprsIn, BasicPattern pattern) {
        Set<Var> vs = DS.set();
        VarUtils.addVars(vs, pattern);
        ExprList pushed = new ExprList();
        ExprList unpushed = new ExprList();
        for (Expr e2 : exprsIn) {
            Set<Var> eVars = e2.getVarsMentioned();
            if (vs.containsAll(eVars)) {
                pushed.add(e2);
                continue;
            }
            unpushed.add(e2);
        }
        if (pushed.size() == 0) {
            return null;
        }
        return new Placement(OpFilter.filter(pushed, (Op)new OpBGP(pattern)), unpushed);
    }

    private static OpBGP getBGP(Op op) {
        Op opTop;
        OpSequence opSeq;
        List<Op> x;
        if (op instanceof OpBGP) {
            return (OpBGP)op;
        }
        if (op instanceof OpSequence && (x = (opSeq = (OpSequence)op).getElements()).size() > 0 && (opTop = x.get(x.size() - 1)) instanceof OpBGP) {
            return (OpBGP)opTop;
        }
        return null;
    }

    private Placement placeOrWrapQuadPattern(ExprList exprs, OpQuadPattern pattern) {
        return this.placeOrWrapQuadPattern(exprs, pattern.getGraphNode(), pattern.getBasicPattern());
    }

    private Placement placeOrWrapQuadPattern(ExprList exprsIn, Node graphNode, BasicPattern pattern) {
        if (this.includeBGPs) {
            return TransformFilterPlacement.placeQuadPattern(exprsIn, graphNode, pattern);
        }
        return TransformFilterPlacement.wrapQuadPattern(exprsIn, graphNode, pattern);
    }

    private static Placement placeQuadPattern(ExprList exprsIn, Node graphNode, BasicPattern pattern) {
        ExprList exprs = ExprList.copy(exprsIn);
        Set<Var> patternVarsScope = DS.set();
        Op op = TransformFilterPlacement.insertAnyFilter$(exprs, patternVarsScope, null);
        if (Var.isVar(graphNode)) {
            VarUtils.addVar(patternVarsScope, Var.alloc(graphNode));
        }
        for (Triple triple : pattern) {
            OpQuadPattern opQuad = TransformFilterPlacement.getQuads(op);
            if (opQuad == null) {
                opQuad = new OpQuadPattern(graphNode, new BasicPattern());
                op = OpSequence.create(op, opQuad);
            }
            opQuad.getBasicPattern().add(triple);
            VarUtils.addVarsFromTriple(patternVarsScope, triple);
            op = TransformFilterPlacement.insertAnyFilter$(exprs, patternVarsScope, op);
        }
        return TransformFilterPlacement.result(op, exprs);
    }

    private static Placement wrapQuadPattern(ExprList exprsIn, Node graphNode, BasicPattern pattern) {
        Set<Var> vs = DS.set();
        VarUtils.addVars(vs, pattern);
        if (Var.isVar(graphNode)) {
            vs.add(Var.alloc(graphNode));
        }
        ExprList pushed = new ExprList();
        ExprList unpushed = new ExprList();
        for (Expr e2 : exprsIn) {
            Set<Var> eVars = e2.getVarsMentioned();
            if (vs.containsAll(eVars)) {
                pushed.add(e2);
                continue;
            }
            unpushed.add(e2);
        }
        if (pushed.size() == 0) {
            return null;
        }
        return new Placement(OpFilter.filter(pushed, (Op)new OpQuadPattern(graphNode, pattern)), unpushed);
    }

    private static OpQuadPattern getQuads(Op op) {
        Op opTop;
        OpSequence opSeq;
        List<Op> x;
        if (op instanceof OpQuadPattern) {
            return (OpQuadPattern)op;
        }
        if (op instanceof OpSequence && (x = (opSeq = (OpSequence)op).getElements()).size() > 0 && (opTop = x.get(x.size() - 1)) instanceof OpQuadPattern) {
            return (OpQuadPattern)opTop;
        }
        return null;
    }

    private Placement placeSequence(ExprList exprsIn, OpSequence opSequence) {
        ExprList exprs = ExprList.copy(exprsIn);
        Set<Var> varScope = DS.set();
        List<Op> ops = opSequence.getElements();
        Op op = null;
        for (Op op1 : ops) {
            op = TransformFilterPlacement.insertAnyFilter$(exprs, varScope, op);
            Op seqElt = op1;
            Placement p = this.transform(exprs, seqElt);
            if (p != null) {
                exprs = p.unplaced;
                seqElt = p.op;
            }
            varScope.addAll(this.fixedVars(seqElt));
            op = OpSequence.create(op, seqElt);
        }
        return TransformFilterPlacement.result(op, exprs);
    }

    private Placement placeJoin(ExprList exprs, OpJoin opJoin) {
        Op left = opJoin.getLeft();
        Op right = opJoin.getRight();
        Set<Var> leftVars = this.fixedVars(left);
        Set<Var> rightVars = this.fixedVars(right);
        ExprList unpushed = new ExprList();
        ExprList pushLeft = new ExprList();
        ExprList pushRight = new ExprList();
        for (Expr expr : exprs) {
            Set<Var> vars = expr.getVarsMentioned();
            boolean pushed = false;
            if (leftVars.containsAll(vars)) {
                pushLeft.add(expr);
                pushed = true;
            }
            if (pushed && !pushRightAsWellAsLeft) continue;
            if (rightVars.containsAll(vars)) {
                pushRight.add(expr);
                pushed = true;
            }
            if (pushed) continue;
            unpushed.add(expr);
        }
        if (pushLeft.isEmpty() && pushRight.isEmpty()) {
            return null;
        }
        Op opLeftNew = left;
        if (!pushLeft.isEmpty()) {
            opLeftNew = this.transformOpAlways(pushLeft, opLeftNew);
        }
        Op opRightNew = right;
        if (!pushRight.isEmpty()) {
            opRightNew = this.transformOpAlways(pushRight, opRightNew);
        }
        Op op = OpJoin.create(opLeftNew, opRightNew);
        return TransformFilterPlacement.result(op, unpushed);
    }

    private Placement placeConditional(ExprList exprs, OpConditional opConditional) {
        Op left = opConditional.getLeft();
        Op right = opConditional.getRight();
        Placement nLeft = this.transform(exprs, left);
        if (nLeft == null) {
            return TransformFilterPlacement.result(opConditional, exprs);
        }
        OpConditional op = new OpConditional(nLeft.op, right);
        return TransformFilterPlacement.result(op, nLeft.unplaced);
    }

    private Placement placeLeftJoin(ExprList exprs, OpLeftJoin opLeftJoin) {
        Op left = opLeftJoin.getLeft();
        Op right = opLeftJoin.getRight();
        Placement nLeft = this.transform(exprs, left);
        if (nLeft == null) {
            return TransformFilterPlacement.result(opLeftJoin, exprs);
        }
        Op op = OpLeftJoin.create(nLeft.op, right, opLeftJoin.getExprs());
        return TransformFilterPlacement.result(op, nLeft.unplaced);
    }

    private Placement placeUnion(ExprList exprs, OpUnion input) {
        Op newRight;
        Op left = input.getLeft();
        Placement pLeft = this.transform(exprs, left);
        Op right = input.getRight();
        Placement pRight = this.transform(exprs, right);
        ExprList exprs2 = null;
        for (Expr expr : exprs) {
            boolean unplacedLeft = pLeft == null || pLeft.unplaced.getList().contains(expr);
            boolean unplacedRight = pRight == null || pRight.unplaced.getList().contains(expr);
            boolean placed = !unplacedLeft && !unplacedRight;
            if (placed) continue;
            if (exprs2 == null) {
                exprs2 = new ExprList();
            }
            exprs2.add(expr);
        }
        Op newLeft = pLeft == null ? left : pLeft.op;
        Op op = newRight = pRight == null ? right : pRight.op;
        if (exprs2 == null) {
            exprs2 = emptyList;
        }
        Op op2 = OpUnion.create(newLeft, newRight);
        return TransformFilterPlacement.result(op2, exprs2);
    }

    private Placement placeExtend(ExprList exprs, OpExtend input) {
        return this.processExtendAssign(exprs, input);
    }

    private Placement placeAssign(ExprList exprs, OpAssign input) {
        return this.processExtendAssign(exprs, input);
    }

    private Placement processExtendAssign(ExprList exprs, OpExtendAssign input) {
        List<Var> vars1 = input.getVarExprList().getVars();
        Op subOp = input.getSubOp();
        ExprList remaining = exprs;
        Placement p = this.transform(exprs, input.getSubOp());
        if (p != null) {
            subOp = p.op;
            remaining = p.unplaced;
        }
        Set<Var> subVars = OpVars.fixedVars(subOp);
        subVars.addAll(input.getVarExprList().getVars());
        ExprList wrapping = new ExprList();
        ExprList unplaced = new ExprList();
        for (Expr expr : remaining) {
            Set<Var> exprVars = expr.getVarsMentioned();
            if (subVars.containsAll(exprVars)) {
                wrapping.add(expr);
                continue;
            }
            unplaced.add(expr);
        }
        Op result = input.copy(subOp);
        if (!wrapping.isEmpty()) {
            result = OpFilter.filter(wrapping, result);
        }
        return TransformFilterPlacement.result(result, unplaced);
    }

    private Placement placeProject(ExprList exprs, OpProject input) {
        List<Var> varsProject = input.getVars();
        ExprList pushed = new ExprList();
        ExprList unpushed = new ExprList();
        for (Expr expr : exprs) {
            Set<Var> exprVars = expr.getVarsMentioned();
            if (varsProject.containsAll(exprVars)) {
                pushed.add(expr);
                continue;
            }
            unpushed.add(expr);
        }
        if (pushed.isEmpty()) {
            return this.resultNoChange(input);
        }
        return this.processSubOp1(pushed, unpushed, input);
    }

    private Placement processSubOp1(ExprList pushed, ExprList unpushed, Op1 input) {
        Op opSub = input.getSubOp();
        Placement subPlacement = this.transform(pushed, opSub);
        if (subPlacement == null) {
            Op op1 = input.getSubOp();
            if (pushed != null && !pushed.isEmpty()) {
                op1 = OpFilter.filter(pushed, op1);
            }
            Op1 op2 = input.copy(op1);
            return TransformFilterPlacement.result(op2, unpushed);
        }
        Op op_a = OpFilter.filter(subPlacement.unplaced, subPlacement.op);
        op_a = input.copy(op_a);
        return TransformFilterPlacement.result(op_a, unpushed);
    }

    private Placement placeDistinctReduced(ExprList exprs, OpDistinctReduced input) {
        Op subOp = input.getSubOp();
        Placement p = this.transform(exprs, subOp);
        if (p == null) {
            return this.resultNoChange(input);
        }
        Op op = p.op;
        op = input.copy(op);
        return TransformFilterPlacement.result(op, p.unplaced);
    }

    private Placement placeTable(ExprList exprs, OpTable input) {
        exprs = ExprList.copy(exprs);
        Op op = TransformFilterPlacement.insertAnyFilter$(exprs, input.getTable().getVars(), input);
        return TransformFilterPlacement.result(op, exprs);
    }

    private Set<Var> fixedVars(Op op) {
        return OpVars.fixedVars(op);
    }

    private static Op insertAnyFilter$(ExprList unplacedExprs, Collection<Var> patternVarsScope, Op op) {
        Iterator<Expr> iter = unplacedExprs.iterator();
        while (iter.hasNext()) {
            Expr expr = iter.next();
            Set<Var> exprVars = expr.getVarsMentioned();
            if (!patternVarsScope.containsAll(exprVars)) continue;
            if (op == null) {
                op = OpTable.unit();
            }
            op = OpFilter.filter(expr, op);
            iter.remove();
        }
        return op;
    }

    private static <T> boolean disjoint(Collection<T> collection, Collection<T> possibleElts) {
        return CollectionUtils.disjoint(collection, possibleElts);
    }

    private static Op buildFilter(Placement placement) {
        if (placement == null) {
            return null;
        }
        if (placement.unplaced.isEmpty()) {
            return placement.op;
        }
        return TransformFilterPlacement.buildFilter(placement.unplaced, placement.op);
    }

    private static Op buildFilter(ExprList exprs, Op op) {
        if (exprs == null || exprs.isEmpty()) {
            return op;
        }
        for (Expr expr : exprs) {
            if (op == null) {
                op = OpTable.unit();
            }
            op = OpFilter.filter(expr, op);
        }
        return op;
    }

    public static class Placement {
        public final Op op;
        public final ExprList unplaced;

        public Placement(Op op, ExprList remaining) {
            this.op = op;
            this.unplaced = remaining;
        }

        public String toString() {
            return "" + this.op + " : " + this.unplaced;
        }

        public int hashCode() {
            return 31 * Lib.hashCodeObject(this.op, 1) + Lib.hashCodeObject(this.unplaced);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Placement other = (Placement)obj;
            return Lib.equal(this.op, other.op) && Lib.equal(this.unplaced, other.unplaced);
        }
    }
}

