/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.core;

import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdUtils;
import com.github.jsonldjava.core.RDFDataset;
import com.github.jsonldjava.core.UniqueNamer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RDFDatasetUtils {
    private static final Pattern UCHAR_MATCHED = Pattern.compile("\\u005C(?:([tbnrf\\\"'])|(?:u(" + com.github.jsonldjava.core.Regex.HEX + "{4}))|(?:U(" + com.github.jsonldjava.core.Regex.HEX + "{8})))");

    @Deprecated
    static List<Object> graphToRDF(Map<String, Object> graph, UniqueNamer namer) {
        ArrayList<Object> rval = new ArrayList<Object>();
        for (String id : graph.keySet()) {
            Map node = (Map)graph.get(id);
            ArrayList properties = new ArrayList(node.keySet());
            Collections.sort(properties);
            for (String property : properties) {
                Object items = node.get(property);
                if ("@type".equals(property)) {
                    property = "http://www.w3.org/1999/02/22-rdf-syntax-ns#type";
                } else if (JsonLdUtils.isKeyword(property)) continue;
                for (Object item : (List)items) {
                    LinkedHashMap<String, Object> subject = new LinkedHashMap<String, Object>();
                    if (id.indexOf("_:") == 0) {
                        subject.put("type", "blank node");
                        subject.put("value", namer.getName(id));
                    } else {
                        subject.put("type", "IRI");
                        subject.put("value", id);
                    }
                    LinkedHashMap<String, Object> predicate = new LinkedHashMap<String, Object>();
                    predicate.put("type", "IRI");
                    predicate.put("value", property);
                    if (JsonLdUtils.isList(item).booleanValue()) {
                        RDFDatasetUtils.listToRDF((List)((Map)item).get("@list"), namer, subject, predicate, rval);
                        continue;
                    }
                    Object object = RDFDatasetUtils.objectToRDF(item, namer);
                    LinkedHashMap<String, Object> tmp = new LinkedHashMap<String, Object>();
                    tmp.put("subject", subject);
                    tmp.put("predicate", predicate);
                    tmp.put("object", object);
                    rval.add(tmp);
                }
            }
        }
        return rval;
    }

    private static void listToRDF(List<Object> list, UniqueNamer namer, Map<String, Object> subject, Map<String, Object> predicate, List<Object> triples) {
        LinkedHashMap<String, Object> first = new LinkedHashMap<String, Object>();
        first.put("type", "IRI");
        first.put("value", "http://www.w3.org/1999/02/22-rdf-syntax-ns#first");
        LinkedHashMap<String, Object> rest = new LinkedHashMap<String, Object>();
        rest.put("type", "IRI");
        rest.put("value", "http://www.w3.org/1999/02/22-rdf-syntax-ns#rest");
        LinkedHashMap<String, String> nil = new LinkedHashMap<String, String>();
        nil.put("type", "IRI");
        nil.put("value", "http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
        for (Object item : list) {
            LinkedHashMap<String, Object> blankNode2 = new LinkedHashMap<String, Object>();
            blankNode2.put("type", "blank node");
            blankNode2.put("value", namer.getName());
            LinkedHashMap<String, Map<String, Object>> tmp = new LinkedHashMap<String, Map<String, Object>>();
            tmp.put("subject", subject);
            tmp.put("predicate", predicate);
            tmp.put("object", blankNode2);
            triples.add(tmp);
            subject = blankNode2;
            predicate = first;
            Object object = RDFDatasetUtils.objectToRDF(item, namer);
            LinkedHashMap<String, Object> tmp2 = new LinkedHashMap<String, Object>();
            tmp2.put("subject", subject);
            tmp2.put("predicate", predicate);
            tmp2.put("object", object);
            triples.add(tmp2);
            predicate = rest;
        }
        LinkedHashMap<String, Map<String, Object>> tmp = new LinkedHashMap<String, Map<String, Object>>();
        tmp.put("subject", subject);
        tmp.put("predicate", predicate);
        tmp.put("object", nil);
        triples.add(tmp);
    }

    private static Object objectToRDF(Object item, UniqueNamer namer) {
        LinkedHashMap<String, String> object = new LinkedHashMap<String, String>();
        if (JsonLdUtils.isValue(item).booleanValue()) {
            object.put("type", "literal");
            Object value = ((Map)item).get("@value");
            Object datatype = ((Map)item).get("@type");
            if (value instanceof Boolean || value instanceof Number) {
                if (value instanceof Boolean) {
                    object.put("value", value.toString());
                    object.put("datatype", datatype == null ? "http://www.w3.org/2001/XMLSchema#boolean" : datatype);
                } else if (value instanceof Double || value instanceof Float) {
                    DecimalFormat df = new DecimalFormat("0.0###############E0");
                    object.put("value", df.format(value));
                    object.put("datatype", datatype == null ? "http://www.w3.org/2001/XMLSchema#double" : datatype);
                } else {
                    DecimalFormat df = new DecimalFormat("0");
                    object.put("value", df.format(value));
                    object.put("datatype", datatype == null ? "http://www.w3.org/2001/XMLSchema#integer" : datatype);
                }
            } else if (((Map)item).containsKey("@language")) {
                object.put("value", (String)value);
                object.put("datatype", datatype == null ? "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString" : datatype);
                object.put("language", (String)((Map)item).get("@language"));
            } else {
                object.put("value", (String)value);
                object.put("datatype", datatype == null ? "http://www.w3.org/2001/XMLSchema#string" : datatype);
            }
        } else {
            String id;
            String string = id = JsonLdUtils.isObject(item) != false ? (String)((Map)item).get("@id") : (String)item;
            if (id.indexOf("_:") == 0) {
                object.put("type", "blank node");
                object.put("value", namer.getName(id));
            } else {
                object.put("type", "IRI");
                object.put("value", id);
            }
        }
        return object;
    }

    public static String toNQuads(RDFDataset dataset) {
        ArrayList<String> quads = new ArrayList<String>();
        for (String graphName : dataset.graphNames()) {
            List<RDFDataset.Quad> triples = dataset.getQuads(graphName);
            if ("@default".equals(graphName)) {
                graphName = null;
            }
            for (RDFDataset.Quad triple : triples) {
                quads.add(RDFDatasetUtils.toNQuad(triple, graphName));
            }
        }
        Collections.sort(quads);
        String rval = "";
        for (String quad : quads) {
            rval = rval + quad;
        }
        return rval;
    }

    static String toNQuad(RDFDataset.Quad triple, String graphName, String bnode2) {
        RDFDataset.Node s = triple.getSubject();
        RDFDataset.Node p = triple.getPredicate();
        RDFDataset.Node o = triple.getObject();
        String quad = "";
        quad = s.isIRI() ? quad + "<" + RDFDatasetUtils.escape(s.getValue()) + ">" : (bnode2 != null ? quad + (bnode2.equals(s.getValue()) ? "_:a" : "_:z") : quad + s.getValue());
        quad = p.isIRI() ? quad + " <" + RDFDatasetUtils.escape(p.getValue()) + "> " : quad + " " + RDFDatasetUtils.escape(p.getValue()) + " ";
        if (o.isIRI()) {
            quad = quad + "<" + RDFDatasetUtils.escape(o.getValue()) + ">";
        } else if (o.isBlankNode()) {
            quad = bnode2 != null ? quad + (bnode2.equals(o.getValue()) ? "_:a" : "_:z") : quad + o.getValue();
        } else {
            String escaped = RDFDatasetUtils.escape(o.getValue());
            quad = quad + "\"" + escaped + "\"";
            if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#langString".equals(o.getDatatype())) {
                quad = quad + "@" + o.getLanguage();
            } else if (!"http://www.w3.org/2001/XMLSchema#string".equals(o.getDatatype())) {
                quad = quad + "^^<" + RDFDatasetUtils.escape(o.getDatatype()) + ">";
            }
        }
        if (graphName != null) {
            quad = graphName.indexOf("_:") != 0 ? quad + " <" + RDFDatasetUtils.escape(graphName) + ">" : (bnode2 != null ? quad + " _:g" : quad + " " + graphName);
        }
        quad = quad + " .\n";
        return quad;
    }

    static String toNQuad(RDFDataset.Quad triple, String graphName) {
        return RDFDatasetUtils.toNQuad(triple, graphName, null);
    }

    public static String unescape(String str2) {
        String rval = str2;
        if (str2 != null) {
            Matcher m = UCHAR_MATCHED.matcher(str2);
            block10: while (m.find()) {
                String uni = m.group(0);
                if (m.group(1) == null) {
                    String hex = m.group(2) != null ? m.group(2) : m.group(3);
                    int v = Integer.parseInt(hex, 16);
                    if (v > 65535) {
                        int vt = v - 65536;
                        int vh = vt >> 10;
                        int v1 = vt & 0x3FF;
                        int w1 = 55296 + vh;
                        int w2 = 56320 + v1;
                        StringBuffer b = new StringBuffer();
                        b.appendCodePoint(w1);
                        b.appendCodePoint(w2);
                        uni = b.toString();
                    } else {
                        uni = Character.toString((char)v);
                    }
                } else {
                    char c = m.group(1).charAt(0);
                    switch (c) {
                        case 'b': {
                            uni = "\b";
                            break;
                        }
                        case 'n': {
                            uni = "\n";
                            break;
                        }
                        case 't': {
                            uni = "\t";
                            break;
                        }
                        case 'f': {
                            uni = "\f";
                            break;
                        }
                        case 'r': {
                            uni = "\r";
                            break;
                        }
                        case '\'': {
                            uni = "'";
                            break;
                        }
                        case '\"': {
                            uni = "\"";
                            break;
                        }
                        case '\\': {
                            uni = "\\";
                            break;
                        }
                        default: {
                            continue block10;
                        }
                    }
                }
                String pat = Pattern.quote(m.group(0));
                String x = Integer.toHexString(uni.charAt(0));
                rval = rval.replaceAll(pat, uni);
            }
        }
        return rval;
    }

    public static String escape(String str2) {
        String rval = "";
        block9: for (int i = 0; i < str2.length(); ++i) {
            char hi = str2.charAt(i);
            if (hi <= '\b' || hi == '\u000b' || hi == '\f' || hi >= '\u000e' && hi <= '\u001f' || hi >= '\u007f' && hi <= '\u00a0' || hi >= '\u024f' && !Character.isHighSurrogate(hi)) {
                rval = rval + String.format("\\u%04x", hi);
                continue;
            }
            if (Character.isHighSurrogate(hi)) {
                char lo = str2.charAt(++i);
                int c = (hi << 10) + lo + -56613888;
                rval = rval + String.format("\\U%08x", c);
                continue;
            }
            switch (hi) {
                case '\b': {
                    rval = rval + "\\b";
                    continue block9;
                }
                case '\n': {
                    rval = rval + "\\n";
                    continue block9;
                }
                case '\t': {
                    rval = rval + "\\t";
                    continue block9;
                }
                case '\f': {
                    rval = rval + "\\f";
                    continue block9;
                }
                case '\r': {
                    rval = rval + "\\r";
                    continue block9;
                }
                case '\"': {
                    rval = rval + "\\\"";
                    continue block9;
                }
                case '\\': {
                    rval = rval + "\\\\";
                    continue block9;
                }
                default: {
                    rval = rval + hi;
                }
            }
        }
        return rval;
    }

    public static RDFDataset parseNQuads(String input) throws JsonLdError {
        RDFDataset dataset = new RDFDataset();
        String[] lines = Regex.EOLN.split(input);
        int lineNumber = 0;
        for (String line : lines) {
            RDFDataset.Node object;
            ++lineNumber;
            if (Regex.EMPTY.matcher(line).matches()) continue;
            Matcher match = Regex.QUAD.matcher(line);
            if (!match.matches()) {
                throw new JsonLdError(JsonLdError.Error.SYNTAX_ERROR, "Error while parsing N-Quads; invalid quad. line:" + lineNumber);
            }
            RDFDataset.Node subject = match.group(1) != null ? new RDFDataset.IRI(RDFDatasetUtils.unescape(match.group(1))) : new RDFDataset.BlankNode(RDFDatasetUtils.unescape(match.group(2)));
            RDFDataset.IRI predicate = new RDFDataset.IRI(RDFDatasetUtils.unescape(match.group(3)));
            if (match.group(4) != null) {
                object = new RDFDataset.IRI(RDFDatasetUtils.unescape(match.group(4)));
            } else if (match.group(5) != null) {
                object = new RDFDataset.BlankNode(RDFDatasetUtils.unescape(match.group(5)));
            } else {
                String language = RDFDatasetUtils.unescape(match.group(8));
                String datatype = match.group(7) != null ? RDFDatasetUtils.unescape(match.group(7)) : (match.group(8) != null ? "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString" : "http://www.w3.org/2001/XMLSchema#string");
                String unescaped = RDFDatasetUtils.unescape(match.group(6));
                object = new RDFDataset.Literal(unescaped, datatype, language);
            }
            String name = "@default";
            if (match.group(9) != null) {
                name = RDFDatasetUtils.unescape(match.group(9));
            } else if (match.group(10) != null) {
                name = RDFDatasetUtils.unescape(match.group(10));
            }
            RDFDataset.Quad triple = new RDFDataset.Quad(subject, predicate, object, name);
            if (!dataset.containsKey(name)) {
                ArrayList<RDFDataset.Quad> tmp = new ArrayList<RDFDataset.Quad>();
                tmp.add(triple);
                dataset.put(name, tmp);
                continue;
            }
            List triples = (List)dataset.get(name);
            if (triples.contains(triple)) continue;
            triples.add(triple);
        }
        return dataset;
    }

    private static class Regex {
        public static final Pattern IRI = Pattern.compile("(?:<([^>]*)>)");
        public static final Pattern BNODE = Pattern.compile("(_:(?:[A-Za-z][A-Za-z0-9]*))");
        public static final Pattern PLAIN = Pattern.compile("\"([^\"\\\\]*(?:\\\\.[^\"\\\\]*)*)\"");
        public static final Pattern DATATYPE = Pattern.compile("(?:\\^\\^" + IRI + ")");
        public static final Pattern LANGUAGE = Pattern.compile("(?:@([a-z]+(?:-[a-zA-Z0-9]+)*))");
        public static final Pattern LITERAL = Pattern.compile("(?:" + PLAIN + "(?:" + DATATYPE + "|" + LANGUAGE + ")?)");
        public static final Pattern WS = Pattern.compile("[ \\t]+");
        public static final Pattern WSO = Pattern.compile("[ \\t]*");
        public static final Pattern EOLN = Pattern.compile("(?:\r\n)|(?:\n)|(?:\r)");
        public static final Pattern EMPTY = Pattern.compile("^" + WSO + "$");
        public static final Pattern SUBJECT = Pattern.compile("(?:" + IRI + "|" + BNODE + ")" + WS);
        public static final Pattern PROPERTY = Pattern.compile(IRI.pattern() + WS.pattern());
        public static final Pattern OBJECT = Pattern.compile("(?:" + IRI + "|" + BNODE + "|" + LITERAL + ")" + WSO);
        public static final Pattern GRAPH = Pattern.compile("(?:\\.|(?:(?:" + IRI + "|" + BNODE + ")" + WSO + "\\.))");
        public static final Pattern QUAD = Pattern.compile("^" + WSO + SUBJECT + PROPERTY + OBJECT + GRAPH + WSO + "$");

        private Regex() {
        }
    }
}

