/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.main.sys;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.jena.base.module.Subsystem;
import org.apache.jena.fuseki.main.sys.FusekiModule;

public class FusekiModules {
    private static Set<FusekiModule> registry = null;
    private static Subsystem<FusekiModule> subsystem = null;

    public static void load() {
        if (registry == null) {
            FusekiModules.reload();
        }
    }

    public static void reload() {
        registry = ConcurrentHashMap.newKeySet();
        subsystem = new Subsystem(FusekiModule.class);
        subsystem.initialize();
        subsystem.forEach(registry::add);
    }

    public static void add(FusekiModule module) {
        FusekiModules.load();
        module.start();
        registry.add(module);
    }

    public static void remove(FusekiModule module) {
        registry.remove(module);
        module.stop();
    }

    public static boolean contains(FusekiModule module) {
        return registry.contains(module);
    }

    static void forEachModule(Consumer<FusekiModule> action) {
        if (registry == null) {
            FusekiModules.load();
        }
        if (registry == null || registry.isEmpty()) {
            return;
        }
        registry.forEach(action);
    }
}

