/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.main.cmds;

import arq.cmdline.CmdARQ;
import arq.cmdline.ModAssembler;
import arq.cmdline.ModDatasetAssembler;
import java.net.BindException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import jena.cmd.ArgDecl;
import jena.cmd.ArgModuleGeneral;
import jena.cmd.CmdException;
import org.apache.jena.assembler.exceptions.AssemblerException;
import org.apache.jena.atlas.json.JSON;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.lib.DateTimeUtils;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.atlas.web.AuthScheme;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.main.FusekiServer;
import org.apache.jena.fuseki.main.cmds.PlatformInfo;
import org.apache.jena.fuseki.main.cmds.ServerConfig;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.servlets.SPARQL_QueryGeneral;
import org.apache.jena.fuseki.validation.DataValidator;
import org.apache.jena.fuseki.validation.IRIValidator;
import org.apache.jena.fuseki.validation.QueryValidator;
import org.apache.jena.fuseki.validation.UpdateValidator;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.system.Txn;
import org.apache.jena.tdb.TDBFactory;
import org.apache.jena.tdb2.DatabaseMgr;
import org.slf4j.Logger;

public class FusekiMain
extends CmdARQ {
    private static int defaultPort = 3030;
    private static int defaultHttpsPort = 3043;
    private static ArgDecl argMem = new ArgDecl(false, new String[]{"mem"});
    private static ArgDecl argUpdate = new ArgDecl(false, new String[]{"update", "allowUpdate"});
    private static ArgDecl argFile = new ArgDecl(true, new String[]{"file"});
    private static ArgDecl argTDB2mode = new ArgDecl(false, new String[]{"tdb2"});
    private static ArgDecl argMemTDB = new ArgDecl(false, new String[]{"memtdb", "memTDB", "tdbmem"});
    private static ArgDecl argTDB = new ArgDecl(true, new String[]{"loc", "location", "tdb"});
    private static ArgDecl argEmpty = new ArgDecl(false, new String[]{"empty", "no-dataset"});
    private static ArgDecl argGeneralQuerySvc = new ArgDecl(true, new String[]{"general"});
    private static ArgDecl argPort = new ArgDecl(true, new String[]{"port"});
    private static ArgDecl argLocalhost = new ArgDecl(false, new String[]{"localhost", "local"});
    private static ArgDecl argTimeout = new ArgDecl(true, new String[]{"timeout"});
    private static ArgDecl argConfig = new ArgDecl(true, new String[]{"config", "conf"});
    private static ArgDecl argGZip = new ArgDecl(true, new String[]{"gzip"});
    private static ArgDecl argBase = new ArgDecl(true, new String[]{"base", "files"});
    private static ArgDecl argWithPing = new ArgDecl(false, new String[]{"withPing", "ping"});
    private static ArgDecl argWithStats = new ArgDecl(false, new String[]{"withStats", "stats"});
    private static ArgDecl argAuth = new ArgDecl(true, new String[]{"auth"});
    private static ArgDecl argHttps = new ArgDecl(true, new String[]{"https"});
    private static ArgDecl argHttpsPort = new ArgDecl(true, new String[]{"httpsPort", "httpsport", "sport"});
    private static ArgDecl argPasswdFile = new ArgDecl(true, new String[]{"passwd"});
    private static ArgDecl argRealm = new ArgDecl(true, new String[]{"realm"});
    private static ArgDecl argSparqler = new ArgDecl(true, new String[]{"sparqler"});
    private static ArgDecl argValidators = new ArgDecl(false, new String[]{"validators"});
    private static ModDatasetAssembler modDataset = new ModDatasetAssembler();
    private final ServerConfig serverConfig = new ServerConfig();
    private boolean useTDB2;
    static String argUsage = "[--config=FILE] [--mem|--desc=AssemblerFile|--file=FILE] [--port PORT] /DatasetPathName";

    public static FusekiServer build(String ... argv) {
        FusekiMain inner = new FusekiMain(argv);
        inner.process();
        return inner.buildServer();
    }

    static void run(String ... argv) {
        JenaSystem.init();
        new FusekiMain(argv).mainRun();
    }

    protected FusekiMain(String ... argv) {
        super(argv);
        this.getUsage().startCategory("Fuseki Main");
        this.addModule((ArgModuleGeneral)modDataset);
        this.add(argMem, "--mem", "Create an in-memory, non-persistent dataset for the server");
        this.add(argFile, "--file=FILE", "Create an in-memory, non-persistent dataset for the server, initialised with the contents of the file");
        this.add(argTDB2mode, "--tdb2", "Use TDB2 for command line persistent datasets (dfault is TDB1)");
        this.add(argTDB, "--loc=DIR", "Use an existing TDB database (or create if does not exist)");
        this.add(argMemTDB, "--memTDB", "Create an in-memory, non-persistent dataset using TDB (testing only)");
        this.add(argEmpty);
        this.add(argPort, "--port", "Listen on this port number");
        this.add(argLocalhost, "--localhost", "Listen only on the localhost interface");
        this.add(argTimeout, "--timeout=", "Global timeout applied to queries (value in ms) -- format is X[,Y] ");
        this.add(argUpdate, "--update", "Allow updates (via SPARQL Update and SPARQL HTTP Update)");
        this.add(argConfig, "--config=", "Use a configuration file to determine the services");
        this.add(argGZip, "--gzip=on|off", "Enable GZip compression (HTTP Accept-Encoding) if request header set");
        this.add(argBase, "--base=DIR", "Directory for static content");
        this.add(argSparqler, "--sparqler=DIR", "Run with SPARQLer services Directory for static content");
        this.add(argValidators, "--validators", "Install validators");
        this.add(argGeneralQuerySvc, "--general=", "Add a general SPARQL endpoint (without a dataset)");
        this.add(argAuth, "--auth=[basic|Digest]", "Run the server using basic or digest authentication (dft: digest).");
        this.add(argHttps, "--https=CONF", "https certificate access details. JSON file { \"cert\":FILE , \"passwd\"; SECRET } ");
        this.add(argHttpsPort, "--httpsPort=NUM", "https port (default port is 3043)");
        this.add(argPasswdFile, "--passwd=FILE", "Password file");
        this.add(argWithPing, "--ping", "Enable /$/ping");
        this.add(argWithStats, "--stats", "Enable /$/stats");
        this.modVersion.addClass(Fuseki.class);
    }

    protected String getSummary() {
        return this.getCommandName() + " " + argUsage;
    }

    protected void processModulesAndArgs() {
        String filebase;
        String tag;
        boolean allowUpdate;
        this.serverConfig.verboseLogging = super.isVerbose();
        boolean allowEmpty = this.contains(argEmpty) || this.contains(argSparqler);
        int numDefinitions = 0;
        if (this.contains(argMem)) {
            ++numDefinitions;
        }
        if (this.contains(argFile)) {
            ++numDefinitions;
        }
        if (this.contains(ModAssembler.assemblerDescDecl)) {
            ++numDefinitions;
        }
        if (this.contains(argTDB)) {
            ++numDefinitions;
        }
        if (this.contains(argMemTDB)) {
            ++numDefinitions;
        }
        if (this.contains(argConfig)) {
            ++numDefinitions;
        }
        if (numDefinitions == 0 && !allowEmpty) {
            throw new CmdException("No dataset specified on the command line.");
        }
        if (numDefinitions > 1) {
            throw new CmdException("Multiple ways providing a dataset. Only one of --mem, --file, --loc or --conf");
        }
        if (numDefinitions > 0 && allowEmpty) {
            throw new CmdException("Dataset provided but 'no dataset' flag given");
        }
        if (this.contains(argConfig)) {
            if (this.getPositional().size() != 0) {
                throw new CmdException("Can't have both a configutation file and a service name");
            }
        } else if (!allowEmpty) {
            if (this.getPositional().size() == 0) {
                throw new CmdException("Missing service name");
            }
            if (this.getPositional().size() > 1) {
                throw new CmdException("Multiple dataset path names given");
            }
            this.serverConfig.datasetPath = DataAccessPoint.canonical((String)this.getPositionalArg(0));
        }
        this.serverConfig.datasetDescription = "<unset>";
        if (this.contains(argUpdate) && this.contains(argConfig)) {
            throw new CmdException("--update and a configuration file does not make sense (control using the configuration file only)");
        }
        this.serverConfig.allowUpdate = allowUpdate = this.contains(argUpdate);
        this.serverConfig.port = defaultPort;
        if (this.contains(argPort)) {
            this.serverConfig.port = this.portNumber(argPort);
        }
        if (this.contains(argLocalhost)) {
            this.serverConfig.loopback = true;
        }
        this.useTDB2 = this.contains(argTDB2mode);
        String string = tag = this.useTDB2 ? "TDB2" : "TDB";
        if (allowEmpty) {
            this.serverConfig.empty = true;
            this.serverConfig.datasetDescription = "No dataset";
        }
        if (this.contains(argConfig)) {
            Path path;
            String file = this.getValue(argConfig);
            if (file.startsWith("file:")) {
                file = file.substring("file:".length());
            }
            if (!Files.exists(path = Paths.get(file, new String[0]), new LinkOption[0])) {
                throw new CmdException("File not found: " + file);
            }
            if (Files.isDirectory(path, new LinkOption[0])) {
                throw new CmdException("Is a directory: " + file);
            }
            this.serverConfig.datasetDescription = "Configuration: " + path.toAbsolutePath();
            this.serverConfig.serverConfig = this.getValue(argConfig);
        }
        if (this.contains(argMem)) {
            this.serverConfig.datasetDescription = "in-memory";
            this.serverConfig.dsg = DatasetGraphFactory.createTxnMem();
            this.serverConfig.allowUpdate = true;
        }
        if (this.contains(argFile)) {
            String filename;
            String pathname = filename = this.getValue(argFile);
            if (filename.startsWith("file:")) {
                pathname = filename.substring("file:".length());
            }
            this.serverConfig.datasetDescription = "file:" + filename;
            if (!FileOps.exists((String)pathname)) {
                throw new CmdException("File not found: " + filename);
            }
            this.serverConfig.dsg = DatasetGraphFactory.createTxnMem();
            Lang language = RDFLanguages.filenameToLang((String)filename);
            if (language == null) {
                throw new CmdException("Can't guess language for file: " + filename);
            }
            Txn.executeWrite((Transactional)this.serverConfig.dsg, () -> RDFDataMgr.read((DatasetGraph)this.serverConfig.dsg, (String)filename));
        }
        if (this.contains(argMemTDB)) {
            this.serverConfig.datasetDescription = tag + " dataset in-memory";
            this.serverConfig.dsg = this.useTDB2 ? DatabaseMgr.createDatasetGraph() : TDBFactory.createDatasetGraph();
            this.serverConfig.allowUpdate = true;
        }
        if (this.contains(argTDB)) {
            String dir = this.getValue(argTDB);
            this.serverConfig.datasetDescription = tag + " dataset: " + dir;
            DatasetGraph datasetGraph = this.serverConfig.dsg = this.useTDB2 ? DatabaseMgr.connectDatasetGraph((String)dir) : TDBFactory.createDatasetGraph((String)dir);
        }
        if (this.contains(ModAssembler.assemblerDescDecl)) {
            this.serverConfig.datasetDescription = "Assembler: " + this.getValue(ModAssembler.assemblerDescDecl);
            Dataset ds = modDataset.createDataset();
            this.serverConfig.dsg = ds.asDatasetGraph();
        }
        if (this.contains(argTimeout)) {
            String str = this.getValue(argTimeout);
            ARQ.getContext().set(ARQ.queryTimeout, (Object)str);
        }
        if (this.contains(argSparqler)) {
            filebase = this.getValue(argSparqler);
            if (!FileOps.exists((String)filebase)) {
                throw new CmdException("File area not found: " + filebase);
            }
            this.serverConfig.contentDirectory = filebase;
            this.serverConfig.addGeneral = "/sparql";
            this.serverConfig.empty = true;
            this.serverConfig.validators = true;
        }
        if (this.contains(argGeneralQuerySvc)) {
            String z = this.getValue(argGeneralQuerySvc);
            if (!z.startsWith("/")) {
                z = "/" + z;
            }
            this.serverConfig.addGeneral = z;
        }
        if (this.contains(argValidators)) {
            this.serverConfig.validators = true;
        }
        if (this.contains(argBase)) {
            filebase = this.getValue(argBase);
            if (!FileOps.exists((String)filebase)) {
                throw new CmdException("File area not found: " + filebase);
            }
            this.serverConfig.contentDirectory = filebase;
        }
        if (this.contains(argPasswdFile)) {
            this.serverConfig.passwdFile = this.getValue(argPasswdFile);
        }
        if (this.contains(argRealm)) {
            this.serverConfig.realm = this.getValue(argRealm);
        }
        if (this.contains(argHttpsPort) && !this.contains(argHttps)) {
            throw new CmdException("https port given but not certificate dtails via --" + argHttps.getKeyName());
        }
        if (this.contains(argHttps)) {
            this.serverConfig.httpsPort = defaultHttpsPort;
            if (this.contains(argHttpsPort)) {
                this.serverConfig.httpsPort = this.portNumber(argHttpsPort);
            }
            String httpsSetup = this.getValue(argHttps);
            JsonObject httpsConf = JSON.read((String)httpsSetup);
            Path path = Paths.get(httpsSetup, new String[0]).toAbsolutePath();
            String keystore = httpsConf.get("keystore").getAsString().value();
            this.serverConfig.httpsKeystore = path.getParent().resolve(keystore).toString();
            this.serverConfig.httpsKeystorePasswd = httpsConf.get("passwd").getAsString().value();
        }
        if (this.contains(argAuth)) {
            String schemeStr = this.getValue(argAuth);
            this.serverConfig.authScheme = AuthScheme.scheme((String)schemeStr);
        }
        this.serverConfig.withPing = this.contains(argWithPing);
        this.serverConfig.withStats = this.contains(argWithStats);
    }

    private int portNumber(ArgDecl arg) {
        String portStr = this.getValue(arg);
        try {
            int port = Integer.parseInt(portStr);
            return port;
        }
        catch (NumberFormatException ex) {
            throw new CmdException(argPort.getKeyName() + " : bad port number: " + portStr);
        }
    }

    protected void exec() {
        try {
            FusekiServer server = this.buildServer(this.serverConfig);
            this.info(server);
            try {
                server.start();
            }
            catch (FusekiException ex) {
                if (ex.getCause() instanceof BindException) {
                    Fuseki.serverLog.error("Failed to start server: " + ex.getCause().getMessage() + ": port=" + this.serverConfig.port);
                    System.exit(1);
                }
                throw ex;
            }
            catch (Exception ex) {
                throw new FusekiException("Failed to start server: " + ex.getMessage(), (Throwable)ex);
            }
            server.join();
            System.exit(0);
        }
        catch (AssemblerException ex) {
            if (ex.getCause() != null) {
                System.err.println(ex.getCause().getMessage());
            }
            System.err.println(ex.getMessage());
        }
    }

    private FusekiServer buildServer() {
        return this.buildServer(this.serverConfig);
    }

    private FusekiServer buildServer(ServerConfig serverConfig) {
        FusekiServer.Builder builder = this.builder();
        return FusekiMain.buildServer(builder, serverConfig);
    }

    protected FusekiServer.Builder builder() {
        return FusekiServer.create();
    }

    private static FusekiServer buildServer(FusekiServer.Builder builder, ServerConfig serverConfig) {
        builder.port(serverConfig.port);
        builder.loopback(serverConfig.loopback);
        builder.verbose(serverConfig.verboseLogging);
        if (serverConfig.addGeneral != null) {
            builder.addServlet(serverConfig.addGeneral, (HttpServlet)new SPARQL_QueryGeneral());
        }
        if (serverConfig.validators) {
            builder.addServlet("/validate/query", (HttpServlet)new QueryValidator());
            builder.addServlet("/validate/update", (HttpServlet)new UpdateValidator());
            builder.addServlet("/validate/iri", (HttpServlet)new IRIValidator());
            builder.addServlet("/validate/data", (HttpServlet)new DataValidator());
        }
        if (!serverConfig.empty) {
            if (serverConfig.serverConfig != null) {
                builder.parseConfigFile(serverConfig.serverConfig);
            } else {
                builder.add(serverConfig.datasetPath, serverConfig.dsg, serverConfig.allowUpdate);
            }
        }
        if (serverConfig.contentDirectory != null) {
            builder.staticFileBase(serverConfig.contentDirectory);
        }
        if (serverConfig.passwdFile != null) {
            builder.passwordFile(serverConfig.passwdFile);
        }
        if (serverConfig.realm != null) {
            builder.realm(serverConfig.realm);
        }
        if (serverConfig.httpsKeystore != null) {
            builder.https(serverConfig.httpsPort, serverConfig.httpsKeystore, serverConfig.httpsKeystorePasswd);
        }
        if (serverConfig.authScheme != null) {
            builder.auth(serverConfig.authScheme);
        }
        if (serverConfig.withPing) {
            builder.enablePing(true);
        }
        if (serverConfig.withStats) {
            builder.enableStats(true);
        }
        return builder.build();
    }

    private void info(FusekiServer server) {
        if (super.isQuiet()) {
            return;
        }
        Logger log = Fuseki.serverLog;
        String version = Fuseki.VERSION;
        String buildDate = Fuseki.BUILD_DATE;
        if (version != null && version.equals("${project.version}")) {
            version = null;
        }
        if (buildDate != null && buildDate.equals("${build.time.xsd}")) {
            buildDate = DateTimeUtils.nowAsXSDDateTimeString();
        }
        String name = "Apache Jena Fuseki";
        if (version != null) {
            if (Fuseki.developmentMode && buildDate != null) {
                FmtLog.info((Logger)log, (String)"%s %s %s", (Object[])new Object[]{name, version, buildDate});
            } else {
                FmtLog.info((Logger)log, (String)"%s %s", (Object[])new Object[]{name, version});
            }
        }
        Map<String, List<String>> mapDatasetEndpoints = FusekiMain.description(DataAccessPointRegistry.get((ServletContext)server.getServletContext()));
        if (this.serverConfig.empty) {
            FmtLog.info((Logger)log, (String)"No SPARQL datasets services", (Object[])new Object[0]);
        } else if (this.serverConfig.datasetPath == null && this.serverConfig.serverConfig == null) {
            log.error("No dataset path nor server configuration file");
        }
        if (this.serverConfig.datasetPath != null) {
            if (mapDatasetEndpoints.size() != 1) {
                log.error("Expected only one dataset");
            }
            List<String> endpoints2 = mapDatasetEndpoints.get(this.serverConfig.datasetPath);
            FmtLog.info((Logger)log, (String)"Dataset Type = %s", (Object[])new Object[]{this.serverConfig.datasetDescription});
            FmtLog.info((Logger)log, (String)"Path = %s; Services = %s", (Object[])new Object[]{this.serverConfig.datasetPath, endpoints2});
        }
        if (this.serverConfig.serverConfig != null) {
            FmtLog.info((Logger)log, (String)"Configuration file %s", (Object[])new Object[]{this.serverConfig.serverConfig});
            mapDatasetEndpoints.forEach((path, endpoints) -> FmtLog.info((Logger)log, (String)"Path = %s; Services = %s", (Object[])new Object[]{path, endpoints}));
        }
        if (this.serverConfig.contentDirectory != null) {
            FmtLog.info((Logger)log, (String)"Static files = %s", (Object[])new Object[]{this.serverConfig.contentDirectory});
        }
        if (super.isVerbose()) {
            PlatformInfo.logDetailsVerbose(log);
        } else if (!super.isQuiet()) {
            PlatformInfo.logDetails(log);
        }
    }

    private static Map<String, List<String>> description(DataAccessPointRegistry reg) {
        LinkedHashMap<String, List<String>> desc = new LinkedHashMap<String, List<String>>();
        reg.forEach((ds, dap) -> {
            ArrayList endpoints = new ArrayList();
            desc.put((String)ds, endpoints);
            DataService dSrv = dap.getDataService();
            dSrv.getOperations().forEach(op -> dSrv.getEndpoints(op).forEach(ep -> {
                String x = ep.getName();
                x = "\"" + x + "\"";
                String opName = ep.getOperation().getName();
                String str = x + "=>" + opName;
                endpoints.add(str);
            }));
        });
        return desc;
    }

    protected String getCommandName() {
        return "fuseki";
    }
}

