/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.main;

import java.io.IOException;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.web.AuthScheme;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.access.DataAccessCtl;
import org.apache.jena.fuseki.auth.Auth;
import org.apache.jena.fuseki.auth.AuthPolicy;
import org.apache.jena.fuseki.build.FusekiConfig;
import org.apache.jena.fuseki.ctl.ActionPing;
import org.apache.jena.fuseki.ctl.ActionStats;
import org.apache.jena.fuseki.jetty.FusekiErrorHandler1;
import org.apache.jena.fuseki.jetty.JettyHttps;
import org.apache.jena.fuseki.jetty.JettyLib;
import org.apache.jena.fuseki.main.FusekiLib;
import org.apache.jena.fuseki.metrics.MetricsProviderRegistry;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.Endpoint;
import org.apache.jena.fuseki.server.FusekiVocab;
import org.apache.jena.fuseki.server.Operation;
import org.apache.jena.fuseki.server.OperationRegistry;
import org.apache.jena.fuseki.servlets.ActionProcessor;
import org.apache.jena.fuseki.servlets.ActionService;
import org.apache.jena.fuseki.servlets.AuthFilter;
import org.apache.jena.fuseki.servlets.FusekiFilter;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletAction;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.NotUniqueException;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.apache.jena.sys.JenaSystem;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.UserStore;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;

public class FusekiServer {
    public final Server server;
    private final int httpPort;
    private final int httpsPort;
    private final ServletContext servletContext;
    private final boolean accessCtlRequest;
    private final boolean accessCtlData;

    public static FusekiServer make(int port, String name, DatasetGraph dsg) {
        return FusekiServer.create().port(port).loopback(true).add(name, dsg).build();
    }

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(OperationRegistry serviceDispatchRegistry) {
        return new Builder(serviceDispatchRegistry);
    }

    private FusekiServer(int httpPort, int httpsPort, Server server, ServletContext fusekiServletContext) {
        this.server = server;
        this.httpPort = httpPort;
        this.httpsPort = httpsPort;
        this.servletContext = fusekiServletContext;
        this.accessCtlRequest = false;
        this.accessCtlData = false;
    }

    public int getPort() {
        return this.httpsPort > 0 ? this.httpsPort : this.httpPort;
    }

    public Server getJettyServer() {
        return this.server;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public DataAccessPointRegistry getDataAccessPointRegistry() {
        return DataAccessPointRegistry.get((ServletContext)this.getServletContext());
    }

    public OperationRegistry getOperationRegistry() {
        return OperationRegistry.get((ServletContext)this.getServletContext());
    }

    public boolean hasUserAccessControl() {
        return this.accessCtlRequest || this.accessCtlData;
    }

    public FusekiServer start() {
        try {
            this.server.start();
        }
        catch (IOException ex) {
            if (ex.getCause() instanceof UnrecoverableKeyException) {
                throw new FusekiException(ex.getMessage());
            }
            throw new FusekiException((Throwable)ex);
        }
        catch (IllegalStateException ex) {
            throw new FusekiException(ex.getMessage());
        }
        catch (Exception ex) {
            throw new FusekiException((Throwable)ex);
        }
        if (this.httpsPort > 0) {
            Fuseki.serverLog.info("Start Fuseki (port=" + this.httpPort + "/" + this.httpsPort + ")");
        } else {
            Fuseki.serverLog.info("Start Fuseki (port=" + this.getPort() + ")");
        }
        return this;
    }

    public void stop() {
        Fuseki.serverLog.info("Stop Fuseki (port=" + this.getPort() + ")");
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new FusekiException((Throwable)e);
        }
    }

    public void join() {
        try {
            this.server.join();
        }
        catch (Exception e) {
            throw new FusekiException((Throwable)e);
        }
    }

    static {
        JenaSystem.init();
    }

    public static class Builder {
        private final DataAccessPointRegistry dataAccessPoints = new DataAccessPointRegistry(MetricsProviderRegistry.get().getMeterRegistry());
        private final OperationRegistry operationRegistry;
        private int serverPort = 3330;
        private int serverHttpsPort = -1;
        private boolean networkLoopback = false;
        private boolean verbose = false;
        private boolean withStats = false;
        private boolean withPing = false;
        private AuthPolicy serverAuth = null;
        private String passwordFile = null;
        private String realm = null;
        private AuthScheme authScheme = null;
        private String httpsKeystore = null;
        private String httpsKeystorePasswd = null;
        private List<Pair<String, HttpServlet>> servlets = new ArrayList<Pair<String, HttpServlet>>();
        private List<Pair<String, Filter>> filters = new ArrayList<Pair<String, Filter>>();
        private String contextPath = "/";
        private String staticContentDir = null;
        private SecurityHandler securityHandler = null;
        private Map<String, Object> servletAttr = new HashMap<String, Object>();
        private boolean hasAuthenticationHandler = false;
        private boolean hasDataAccessControl = false;
        private boolean authenticateUser = false;
        private List<DatasetGraph> datasets = null;

        Builder() {
            this.operationRegistry = OperationRegistry.createStd();
        }

        Builder(OperationRegistry operationRegistry) {
            this.operationRegistry = OperationRegistry.createEmpty();
            OperationRegistry.copyConfig((OperationRegistry)operationRegistry, (OperationRegistry)this.operationRegistry);
        }

        @Deprecated
        public Builder setPort(int port) {
            return this.port(port);
        }

        public Builder port(int port) {
            if (port < 0) {
                throw new IllegalArgumentException("Illegal port=" + port + " : Port must be greater than or equal to zero.");
            }
            this.serverPort = port;
            return this;
        }

        @Deprecated
        public Builder setContextPath(String path) {
            return this.contextPath(path);
        }

        public Builder contextPath(String path) {
            Objects.requireNonNull(path, "path");
            this.contextPath = path;
            return this;
        }

        @Deprecated
        public Builder setLoopback(boolean loopback) {
            return this.loopback(loopback);
        }

        public Builder loopback(boolean loopback) {
            this.networkLoopback = loopback;
            return this;
        }

        @Deprecated
        public Builder setStaticFileBase(String directory) {
            return this.staticFileBase(directory);
        }

        public Builder staticFileBase(String directory) {
            Objects.requireNonNull(directory, "directory");
            this.staticContentDir = directory;
            return this;
        }

        @Deprecated
        public Builder setSecurityHandler(SecurityHandler securityHandler) {
            return this.securityHandler(securityHandler);
        }

        public Builder securityHandler(SecurityHandler securityHandler) {
            Objects.requireNonNull(securityHandler, "securityHandler");
            this.securityHandler = securityHandler;
            return this;
        }

        @Deprecated
        public Builder setVerbose(boolean verbose) {
            return this.verbose(verbose);
        }

        public Builder verbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public Builder enableStats(boolean withStats) {
            this.withStats = withStats;
            return this;
        }

        public Builder enablePing(boolean withPing) {
            this.withPing = withPing;
            return this;
        }

        public Builder add(String name, Dataset dataset) {
            Objects.requireNonNull(name, "name");
            Objects.requireNonNull(dataset, "dataset");
            return this.add(name, dataset.asDatasetGraph());
        }

        public Builder add(String name, DatasetGraph dataset) {
            Objects.requireNonNull(name, "name");
            Objects.requireNonNull(dataset, "dataset");
            return this.add(name, dataset, true);
        }

        public Builder add(String name, Dataset dataset, boolean allowUpdate) {
            Objects.requireNonNull(name, "name");
            Objects.requireNonNull(dataset, "dataset");
            return this.add(name, dataset.asDatasetGraph(), allowUpdate);
        }

        public Builder add(String name, DatasetGraph dataset, boolean allowUpdate) {
            Objects.requireNonNull(name, "name");
            Objects.requireNonNull(dataset, "dataset");
            DataService dSrv = FusekiConfig.buildDataServiceStd((DatasetGraph)dataset, (boolean)allowUpdate);
            return this.add(name, dSrv);
        }

        public Builder add(String name, DataService dataService) {
            Objects.requireNonNull(name, "name");
            Objects.requireNonNull(dataService, "dataService");
            return this.add$(name, dataService);
        }

        private Builder add$(String name, DataService dataService) {
            if (this.dataAccessPoints.isRegistered((Object)(name = DataAccessPoint.canonical((String)name)))) {
                throw new FusekiConfigException("Data service name already registered: " + name);
            }
            DataAccessPoint dap = new DataAccessPoint(name, dataService);
            this.addDataAccessPoint(dap);
            return this;
        }

        private Builder addDataAccessPoint(DataAccessPoint dap) {
            if (this.dataAccessPoints.isRegistered((Object)dap.getName())) {
                throw new FusekiConfigException("Data service name already registered: " + dap.getName());
            }
            this.dataAccessPoints.register(dap);
            return this;
        }

        public Builder parseConfigFile(String filename) {
            Objects.requireNonNull(filename, "filename");
            Model model = AssemblerUtils.readAssemblerFile((String)filename);
            this.parseConfig(model);
            return this;
        }

        public Builder parseConfig(Model model) {
            Objects.requireNonNull(model, "model");
            Resource server = FusekiConfig.findServer((Model)model);
            this.processServerLevel(server);
            List x = FusekiConfig.processServerConfiguration((Model)model, (Context)Fuseki.getContext());
            x.forEach(dap -> this.addDataAccessPoint((DataAccessPoint)dap));
            return this;
        }

        private void processServerLevel(Resource server) {
            String authStr;
            String realmStr;
            if (server == null) {
                return;
            }
            this.withPing = Builder.argBoolean(server, FusekiVocab.pServerPing, false);
            this.withStats = Builder.argBoolean(server, FusekiVocab.pServerStats, false);
            String passwdFile = GraphUtils.getAsStringValue((Resource)server, (Property)FusekiVocab.pPasswordFile);
            if (passwdFile != null) {
                this.passwordFile(passwdFile);
            }
            if ((realmStr = GraphUtils.getAsStringValue((Resource)server, (Property)FusekiVocab.pRealm)) != null) {
                this.realm(realmStr);
            }
            if ((authStr = GraphUtils.getAsStringValue((Resource)server, (Property)FusekiVocab.pAuth)) != null) {
                this.auth(AuthScheme.scheme((String)authStr));
            }
            this.serverAuth = FusekiConfig.allowedUsers((Resource)server);
        }

        private static boolean argBoolean(Resource r, Property p, boolean dftValue) {
            try {
                GraphUtils.atmostOneProperty((Resource)r, (Property)p);
            }
            catch (NotUniqueException ex) {
                throw new FusekiConfigException(ex.getMessage());
            }
            Statement stmt = r.getProperty(p);
            if (stmt == null) {
                return dftValue;
            }
            try {
                return stmt.getBoolean();
            }
            catch (JenaException ex) {
                throw new FusekiConfigException("Not a boolean for '" + p + "' : " + stmt.getObject());
            }
        }

        private void processAuthentication(Resource server) {
            String realmStr;
            String passwdFile = GraphUtils.getAsStringValue((Resource)server, (Property)FusekiVocab.pPasswordFile);
            if (passwdFile != null) {
                this.passwordFile(passwdFile);
            }
            if ((realmStr = GraphUtils.getAsStringValue((Resource)server, (Property)FusekiVocab.pRealm)) != null) {
                this.realm(realmStr);
            }
        }

        public Builder auth(AuthScheme authScheme) {
            this.authScheme = authScheme;
            return this;
        }

        public Builder serverAuthPolicy(AuthPolicy authPolicy) {
            this.serverAuth = authPolicy;
            return this;
        }

        public Builder realm(String realm) {
            this.realm = realm;
            return this;
        }

        public Builder passwordFile(String passwordFile) {
            this.passwordFile = passwordFile;
            return this;
        }

        public Builder https(int httpsPort, String certStore, String certStorePasswd) {
            Objects.requireNonNull(certStore, "certStore");
            Objects.requireNonNull(certStorePasswd, "certStorePasswd");
            this.httpsKeystore = certStore;
            this.httpsKeystorePasswd = certStorePasswd;
            this.serverHttpsPort = httpsPort;
            return this;
        }

        public Builder addProcessor(String pathSpec, ActionProcessor processor) {
            return this.addProcessor(pathSpec, processor, Fuseki.actionLog);
        }

        public Builder addProcessor(String pathSpec, ActionProcessor processor, Logger log) {
            Objects.requireNonNull(pathSpec, "pathSpec");
            Objects.requireNonNull(processor, "processor");
            Object servlet = processor instanceof HttpServlet ? (HttpServlet)processor : new ServletAction(processor, log);
            this.servlets.add((Pair<String, HttpServlet>)Pair.create((Object)pathSpec, (Object)servlet));
            return this;
        }

        public Builder addServlet(String pathSpec, HttpServlet servlet) {
            Objects.requireNonNull(pathSpec, "pathSpec");
            Objects.requireNonNull(servlet, "servlet");
            this.servlets.add((Pair<String, HttpServlet>)Pair.create((Object)pathSpec, (Object)servlet));
            return this;
        }

        public Builder addServletAttribute(String attrName, Object value) {
            Objects.requireNonNull(attrName, "attrName");
            if (value != null) {
                this.servletAttr.put(attrName, value);
            } else {
                this.servletAttr.remove(attrName);
            }
            return this;
        }

        public Builder addFilter(String pathSpec, Filter filter) {
            Objects.requireNonNull(pathSpec, "pathSpec");
            Objects.requireNonNull(filter, "filter");
            this.filters.add((Pair<String, Filter>)Pair.create((Object)pathSpec, (Object)filter));
            return this;
        }

        public Builder registerOperation(Operation operation, ActionService handler) {
            this.registerOperation(operation, null, handler);
            return this;
        }

        public Builder registerOperation(Operation operation, String contentType, ActionService handler) {
            Objects.requireNonNull(operation, "operation");
            if (handler == null) {
                this.operationRegistry.unregister(operation);
            } else {
                this.operationRegistry.register(operation, contentType, handler);
            }
            return this;
        }

        public Builder addEndpoint(String datasetName, String endpointName, Operation operation) {
            return this.addEndpoint(datasetName, endpointName, operation, null);
        }

        public Builder addEndpoint(String datasetName, String endpointName, Operation operation, AuthPolicy authPolicy) {
            Objects.requireNonNull(datasetName, "datasetName");
            Objects.requireNonNull(endpointName, "endpointName");
            Objects.requireNonNull(operation, "operation");
            this.serviceEndpointOperation(datasetName, endpointName, operation, authPolicy);
            return this;
        }

        public Builder addOperation(String datasetName, Operation operation) {
            this.addOperation(datasetName, operation, null);
            return this;
        }

        public Builder addOperation(String datasetName, Operation operation, AuthPolicy authPolicy) {
            Objects.requireNonNull(datasetName, "datasetName");
            Objects.requireNonNull(operation, "operation");
            this.serviceEndpointOperation(datasetName, null, operation, authPolicy);
            return this;
        }

        private void serviceEndpointOperation(String datasetName, String endpointName, Operation operation, AuthPolicy authPolicy) {
            String name = DataAccessPoint.canonical((String)datasetName);
            if (!this.operationRegistry.isRegistered(operation)) {
                throw new FusekiConfigException("Operation not registered: " + operation.getName());
            }
            if (!this.dataAccessPoints.isRegistered((Object)name)) {
                throw new FusekiConfigException("Dataset not registered: " + datasetName);
            }
            DataAccessPoint dap = this.dataAccessPoints.get(name);
            Endpoint endpoint = Endpoint.create().operation(operation).endpointName(endpointName).authPolicy(authPolicy).build();
            dap.getDataService().addEndpoint(endpoint);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FusekiServer build() {
            this.buildStart();
            try {
                this.validate();
                if (this.securityHandler == null && this.passwordFile != null) {
                    this.securityHandler = this.buildSecurityHandler();
                }
                ServletContextHandler handler = this.buildFusekiContext();
                Server server = this.serverHttpsPort == -1 ? Builder.jettyServer(handler, this.serverPort) : Builder.jettyServerHttps(handler, this.serverPort, this.serverHttpsPort, this.httpsKeystore, this.httpsKeystorePasswd);
                if (this.networkLoopback) {
                    Builder.applyLocalhost(server);
                }
                FusekiServer fusekiServer = new FusekiServer(this.serverPort, this.serverHttpsPort, server, (ServletContext)handler.getServletContext());
                return fusekiServer;
            }
            finally {
                this.buildFinish();
            }
        }

        private ConstraintSecurityHandler buildSecurityHandler() {
            if (this.passwordFile == null) {
                return null;
            }
            UserStore userStore = JettyLib.makeUserStore((String)this.passwordFile);
            return JettyLib.makeSecurityHandler((String)this.realm, (UserStore)userStore, (AuthScheme)this.authScheme);
        }

        private void buildStart() {
            boolean bl = this.hasAuthenticationHandler = this.passwordFile != null || this.securityHandler != null;
            if (this.realm == null) {
                this.realm = "TripleStore";
            }
            this.hasDataAccessControl = this.dataAccessPoints.keys().stream().map(name -> this.dataAccessPoints.get(name).getDataService().getDataset()).anyMatch(DataAccessCtl::isAccessControlled);
            boolean bl2 = this.authenticateUser = this.serverAuth != null;
            if (!this.authenticateUser) {
                this.authenticateUser = this.dataAccessPoints.keys().stream().map(name -> this.dataAccessPoints.get(name).getDataService()).anyMatch(dSvc -> dSvc.authPolicy() != null);
            }
            if (!this.authenticateUser) {
                this.authenticateUser = this.dataAccessPoints.keys().stream().map(name -> this.dataAccessPoints.get(name).getDataService()).flatMap(dSrv -> dSrv.getEndpoints().stream()).anyMatch(ep -> ep.getAuthPolicy() != null);
            }
            if (this.passwordFile != null && !this.authenticateUser && this.serverAuth == null) {
                this.serverAuth = Auth.ANY_USER;
                this.authenticateUser = true;
            }
        }

        private static boolean authAny(AuthPolicy policy) {
            return policy == null || policy == Auth.ANY_ANON || policy.isAllowed(null);
        }

        private boolean hasServerWideAuth() {
            return !Builder.authAny(this.serverAuth);
        }

        private void buildFinish() {
            this.hasAuthenticationHandler = false;
            this.hasDataAccessControl = false;
            this.datasets = null;
        }

        private void validate() {
            if (!this.hasAuthenticationHandler) {
                if (this.authenticateUser) {
                    Fuseki.configLog.warn("Authetication of users required (e.g. 'allowedUsers' is set) but there is no authentication setup (e.g. password file)");
                }
                if (this.hasDataAccessControl) {
                    Fuseki.configLog.warn("Data-level access control in the configuration but there is no authentication setup (e.g. password file)");
                }
            }
        }

        private ServletContextHandler buildFusekiContext() {
            ServletContextHandler handler = this.buildServletContext(this.contextPath);
            ContextHandler.Context cxt = handler.getServletContext();
            Fuseki.setVerbose((ServletContext)cxt, (boolean)this.verbose);
            this.servletAttr.forEach((arg_0, arg_1) -> Builder.lambda$buildFusekiContext$7((ServletContext)cxt, arg_0, arg_1));
            DataAccessPointRegistry dapRegistry = new DataAccessPointRegistry(this.dataAccessPoints);
            OperationRegistry operationReg = new OperationRegistry(this.operationRegistry);
            OperationRegistry.set((ServletContext)cxt, (OperationRegistry)operationReg);
            DataAccessPointRegistry.set((ServletContext)cxt, (DataAccessPointRegistry)dapRegistry);
            JettyLib.setMimeTypes((ServletContextHandler)handler);
            this.servletsAndFilters(handler);
            this.buildAccessControl(handler);
            dapRegistry.forEach((name, dap) -> {
                dap.getDataService().setEndpointProcessors(operationReg);
                dap.getDataService().forEachEndpoint(ep -> {
                    if (DataAccessCtl.isAccessControlled((DatasetGraph)dap.getDataService().getDataset())) {
                        FusekiLib.modifyForAccessCtl(ep, (Function<HttpAction, String>)DataAccessCtl.requestUserServlet);
                    }
                });
            });
            dapRegistry.forEach((name, dap) -> dap.getDataService().goActive());
            return handler;
        }

        private void buildAccessControl(ServletContextHandler cxt) {
            if (this.securityHandler != null) {
                cxt.setSecurityHandler(this.securityHandler);
                if (this.securityHandler instanceof ConstraintSecurityHandler) {
                    ConstraintSecurityHandler csh = (ConstraintSecurityHandler)this.securityHandler;
                    if (this.hasServerWideAuth()) {
                        JettyLib.addPathConstraint((ConstraintSecurityHandler)csh, (String)"/*");
                    } else {
                        DataAccessPointRegistry.get((ServletContext)cxt.getServletContext()).forEach((name, dap) -> {
                            DatasetGraph dsg = dap.getDataService().getDataset();
                            if (!Builder.authAny(dap.getDataService().authPolicy())) {
                                JettyLib.addPathConstraint((ConstraintSecurityHandler)csh, (String)DataAccessPoint.canonical((String)name));
                                JettyLib.addPathConstraint((ConstraintSecurityHandler)csh, (String)(DataAccessPoint.canonical((String)name) + "/*"));
                            } else {
                                dap.getDataService().forEachEndpoint(ep -> {
                                    if (!Builder.authAny(ep.getAuthPolicy())) {
                                        if (ep.getName().isEmpty()) {
                                            JettyLib.addPathConstraint((ConstraintSecurityHandler)csh, (String)DataAccessPoint.canonical((String)name));
                                            JettyLib.addPathConstraint((ConstraintSecurityHandler)csh, (String)(DataAccessPoint.canonical((String)name) + "/*"));
                                        } else {
                                            JettyLib.addPathConstraint((ConstraintSecurityHandler)csh, (String)(DataAccessPoint.canonical((String)name) + "/" + ep.getName()));
                                        }
                                    }
                                });
                            }
                        });
                    }
                }
            }
        }

        private ServletContextHandler buildServletContext(String contextPath) {
            if (contextPath == null || contextPath.isEmpty()) {
                contextPath = "/";
            } else if (!contextPath.startsWith("/")) {
                contextPath = "/" + contextPath;
            }
            ServletContextHandler context = new ServletContextHandler();
            context.setDisplayName(Fuseki.servletRequestLogName);
            context.setErrorHandler((ErrorHandler)new FusekiErrorHandler1());
            context.setContextPath(contextPath);
            return context;
        }

        private void servletsAndFilters(ServletContextHandler context) {
            if (this.hasServerWideAuth()) {
                Predicate<String> auth = arg_0 -> ((AuthPolicy)this.serverAuth).isAllowed(arg_0);
                AuthFilter authFilter = new AuthFilter(auth);
                this.addFilter(context, "/*", (Filter)authFilter);
            }
            FusekiFilter ff = new FusekiFilter();
            this.addFilter(context, "/*", (Filter)ff);
            if (this.withStats) {
                Builder.addServlet(context, "/$/stats/*", (HttpServlet)new ActionStats());
            }
            if (this.withPing) {
                Builder.addServlet(context, "/$/ping", (HttpServlet)new ActionPing());
            }
            this.servlets.forEach(p -> Builder.addServlet(context, (String)p.getLeft(), (HttpServlet)p.getRight()));
            this.filters.forEach(p -> this.addFilter(context, (String)p.getLeft(), (Filter)p.getRight()));
            if (this.staticContentDir != null) {
                DefaultServlet staticServlet = new DefaultServlet();
                ServletHolder staticContent = new ServletHolder((Servlet)staticServlet);
                staticContent.setInitParameter("resourceBase", this.staticContentDir);
                context.addServlet(staticContent, "/");
            }
        }

        private static void addServlet(ServletContextHandler context, String pathspec, HttpServlet httpServlet) {
            ServletHolder sh = new ServletHolder((Servlet)httpServlet);
            context.addServlet(sh, pathspec);
        }

        private void addFilter(ServletContextHandler context, String pathspec, Filter filter) {
            FilterHolder h = new FilterHolder(filter);
            context.addFilter(h, pathspec, null);
        }

        private static Server jettyServer(ServletContextHandler handler, int port) {
            Server server = new Server();
            HttpConnectionFactory f1 = new HttpConnectionFactory();
            f1.getHttpConfiguration().setRequestHeaderSize(524288);
            f1.getHttpConfiguration().setOutputBufferSize(0x100000);
            if (!Fuseki.outputJettyServerHeader) {
                f1.getHttpConfiguration().setSendServerVersion(false);
            }
            ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{f1});
            connector.setPort(port);
            server.addConnector((Connector)connector);
            server.setHandler((Handler)handler);
            return server;
        }

        private static Server jettyServerHttps(ServletContextHandler handler, int httpPort, int httpsPort, String keystore, String certPassword) {
            return JettyHttps.jettyServerHttps((ServletContextHandler)handler, (String)keystore, (String)certPassword, (int)httpPort, (int)httpsPort);
        }

        private static void applyLocalhost(Server server) {
            Connector[] connectors = server.getConnectors();
            for (int i = 0; i < connectors.length; ++i) {
                if (!(connectors[i] instanceof ServerConnector)) continue;
                ((ServerConnector)connectors[i]).setHost("localhost");
            }
        }

        private static /* synthetic */ void lambda$buildFusekiContext$7(ServletContext cxt, String n, Object v) {
            cxt.setAttribute(n, v);
        }
    }
}

