/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.hadoop.rdf.io.registry.writers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.commons.io.output.WriterOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.jena.hadoop.rdf.io.output.writers.StreamRdfQuadWriter;
import org.apache.jena.hadoop.rdf.io.output.writers.StreamRdfTripleWriter;
import org.apache.jena.hadoop.rdf.io.registry.writers.AbstractWriterFactory;
import org.apache.jena.hadoop.rdf.types.QuadWritable;
import org.apache.jena.hadoop.rdf.types.TripleWritable;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.thrift.StreamRDF2Thrift;

public class ThriftWriterFactory
extends AbstractWriterFactory {
    public ThriftWriterFactory() {
        super(RDFLanguages.THRIFT);
    }

    @Override
    public <TKey> RecordWriter<TKey, QuadWritable> createQuadWriter(Writer writer, Configuration config) throws IOException {
        return new StreamRdfQuadWriter((StreamRDF)new StreamRDF2Thrift((OutputStream)new WriterOutputStream(writer, Charset.forName("utf-8")), false), writer);
    }

    @Override
    public <TKey> RecordWriter<TKey, TripleWritable> createTripleWriter(Writer writer, Configuration config) throws IOException {
        return new StreamRdfTripleWriter((StreamRDF)new StreamRDF2Thrift((OutputStream)new WriterOutputStream(writer, Charset.forName("utf-8")), false), writer);
    }
}

