/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.hadoop.rdf.io.output.writers;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Quad;
import java.io.IOException;
import java.io.Writer;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.Writer2;
import org.apache.jena.atlas.lib.Tuple;
import org.apache.jena.hadoop.rdf.types.NodeTupleWritable;
import org.apache.jena.hadoop.rdf.types.NodeWritable;
import org.apache.jena.hadoop.rdf.types.QuadWritable;
import org.apache.jena.hadoop.rdf.types.TripleWritable;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.out.NodeFormatterNT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNodeWriter<TValue>
extends RecordWriter<NodeWritable, TValue> {
    public static final String DEFAULT_SEPARATOR = "\t";
    private static final Logger log = LoggerFactory.getLogger(AbstractNodeWriter.class);
    protected AWriter writer;
    private NodeFormatter formatter;

    public AbstractNodeWriter(Writer writer) {
        this(writer, (NodeFormatter)new NodeFormatterNT());
    }

    public AbstractNodeWriter(Writer writer, NodeFormatter formatter) {
        if (writer == null) {
            throw new NullPointerException("writer cannot be null");
        }
        if (formatter == null) {
            throw new NullPointerException("formatter cannot be null");
        }
        this.formatter = formatter;
        this.writer = Writer2.wrap((Writer)writer);
    }

    public final void write(NodeWritable key, TValue value) throws IOException, InterruptedException {
        this.writeKey(key);
        this.writer.write(this.getSeparator());
        this.writeValue(value);
        this.writer.write('\n');
    }

    protected void writeKey(NodeWritable key) {
        this.writeNode(key.get());
    }

    protected void writeNode(Node n) {
        this.getNodeFormatter().format(this.writer, n);
    }

    protected void writeNodes(Node ... ns) {
        String sep = this.getSeparator();
        for (int i = 0; i < ns.length; ++i) {
            this.writeNode(ns[i]);
            if (i >= ns.length - 1) continue;
            this.writer.write(sep);
        }
    }

    protected void writeValue(TValue value) {
        if (value instanceof NullWritable || value == null) {
            return;
        }
        if (value instanceof NodeWritable) {
            this.writeKey((NodeWritable)value);
        } else if (value instanceof TripleWritable) {
            Triple t = (Triple)((TripleWritable)value).get();
            this.writeNodes(t.getSubject(), t.getPredicate(), t.getObject());
        } else if (value instanceof QuadWritable) {
            Quad q = (Quad)((QuadWritable)value).get();
            this.writeNodes(q.getGraph(), q.getSubject(), q.getPredicate(), q.getObject());
        } else if (value instanceof NodeTupleWritable) {
            Tuple tuple = (Tuple)((NodeTupleWritable)value).get();
            this.writeNodes((Node[])tuple.tuple());
        } else {
            this.writer.write(value.toString());
        }
    }

    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        log.debug("close({})", (Object)context);
        this.writer.close();
    }

    protected NodeFormatter getNodeFormatter() {
        return this.formatter;
    }

    protected String getSeparator() {
        return DEFAULT_SEPARATOR;
    }
}

