/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.hadoop.rdf.io.output.writers;

import com.hp.hpl.jena.graph.Node;
import java.io.IOException;
import java.io.Writer;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.Writer2;
import org.apache.jena.hadoop.rdf.types.AbstractNodeTupleWritable;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.out.NodeFormatterNT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLineBasedNodeTupleWriter<TKey, TValue, T extends AbstractNodeTupleWritable<TValue>>
extends RecordWriter<TKey, T> {
    public static final String DEFAULT_SEPARATOR = " ";
    public static final String DEFAULT_TERMINATOR = ".";
    private static final Logger log = LoggerFactory.getLogger(AbstractLineBasedNodeTupleWriter.class);
    private AWriter writer;
    private NodeFormatter formatter;

    public AbstractLineBasedNodeTupleWriter(Writer writer) {
        this(writer, (NodeFormatter)new NodeFormatterNT());
    }

    public AbstractLineBasedNodeTupleWriter(Writer writer, NodeFormatter formatter) {
        if (writer == null) {
            throw new NullPointerException("writer cannot be null");
        }
        if (formatter == null) {
            throw new NullPointerException("formatter cannot be null");
        }
        this.formatter = formatter;
        this.writer = Writer2.wrap((Writer)writer);
    }

    public void write(TKey key, T value) throws IOException, InterruptedException {
        log.debug("write({}={})", key, value);
        Node[] ns = this.getNodes(value);
        String sep = this.getSeparator();
        NodeFormatter formatter = this.getNodeFormatter();
        for (int i = 0; i < ns.length; ++i) {
            formatter.format(this.writer, ns[i]);
            this.writer.print(sep);
        }
        this.writer.println(this.getTerminator());
        this.writer.flush();
    }

    protected abstract Node[] getNodes(T var1);

    protected NodeFormatter getNodeFormatter() {
        return this.formatter;
    }

    protected String getSeparator() {
        return DEFAULT_SEPARATOR;
    }

    protected String getTerminator() {
        return DEFAULT_TERMINATOR;
    }

    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        log.debug("close({})", (Object)context);
        this.writer.close();
    }
}

