/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.hadoop.rdf.io.output.writers;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.sparql.core.Quad;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.IteratorUtils;
import org.apache.jena.hadoop.rdf.io.output.writers.AbstractBatchedNodeTupleWriter;
import org.apache.jena.hadoop.rdf.types.QuadWritable;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFWriterRegistry;

public abstract class AbstractBatchedQuadWriter<TKey>
extends AbstractBatchedNodeTupleWriter<TKey, Quad, QuadWritable> {
    private DatasetGraph g = DatasetGraphFactory.createMem();

    protected AbstractBatchedQuadWriter(Writer writer, long batchSize) {
        super(writer, batchSize);
    }

    @Override
    protected final long add(QuadWritable value) {
        this.g.add((Quad)value.get());
        return this.g.size();
    }

    @Override
    protected final long writeOutput(Writer writer) {
        if (this.g.size() == 0L) {
            return 0L;
        }
        RDFDataMgr.write((Writer)writer, (DatasetGraph)this.g, (RDFFormat)RDFWriterRegistry.defaultSerialization((Lang)this.getRdfLanguage()));
        List graphNames = IteratorUtils.toList((Iterator)this.g.listGraphNodes());
        for (Node graphName : graphNames) {
            this.g.removeGraph(graphName);
        }
        this.g.getDefaultGraph().clear();
        return this.g.size();
    }

    protected abstract Lang getRdfLanguage();
}

