/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.hadoop.rdf.io.input.util;

import java.util.UUID;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.jena.riot.lang.LabelToNode;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.ParserProfileBase;
import org.apache.jena.riot.system.Prologue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdfIOUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RdfIOUtils.class);

    private RdfIOUtils() {
    }

    public static ParserProfile createParserProfile(JobContext context, Path path) {
        Prologue prologue = new Prologue(null, IRIResolver.createNoResolve());
        UUID seed = RdfIOUtils.getSeed(context, path);
        LabelToNode labelMapping = LabelToNode.createScopeByDocumentHash((UUID)seed);
        return new ParserProfileBase(prologue, ErrorHandlerFactory.errorHandlerStd, labelMapping);
    }

    public static UUID getSeed(JobContext context, Path path) {
        String jobId = context.getJobID().toString();
        if (jobId == null) {
            jobId = String.valueOf(System.currentTimeMillis());
            LOGGER.warn("Job ID was not set, using current milliseconds of {}. Sequence of MapReduce jobs must carefully handle blank nodes.", (Object)jobId);
        }
        if (!context.getConfiguration().getBoolean("rdf.io.input.bnodes.global-identity", false)) {
            LOGGER.debug("Generating Blank Node Seed from Job Details (ID={}, Input Path={})", (Object)jobId, (Object)path);
            return new UUID(jobId.hashCode(), path.hashCode());
        }
        LOGGER.warn("Using globally scoped blank node allocation policy from Job Details (ID={}) - this is unsafe if your RDF inputs did not originate from a previous job", (Object)jobId);
        return new UUID(jobId.hashCode(), 0L);
    }
}

