/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.hadoop.rdf.io.input.readers;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.jena.hadoop.rdf.io.input.readers.AbstractLineBasedNodeTupleReader;
import org.apache.jena.hadoop.rdf.io.input.util.RdfIOUtils;
import org.apache.jena.hadoop.rdf.io.input.util.TrackableInputStream;
import org.apache.jena.hadoop.rdf.io.input.util.TrackedInputStream;
import org.apache.jena.hadoop.rdf.io.input.util.TrackedPipedRDFStream;
import org.apache.jena.hadoop.rdf.types.AbstractNodeTupleWritable;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.lang.PipedRDFIterator;
import org.apache.jena.riot.lang.PipedRDFStream;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.StreamRDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWholeFileNodeTupleReader<TValue, T extends AbstractNodeTupleWritable<TValue>>
extends RecordReader<LongWritable, T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLineBasedNodeTupleReader.class);
    private CompressionCodec compressionCodecs;
    private TrackedInputStream input;
    private LongWritable key;
    private long length;
    private T tuple;
    private TrackedPipedRDFStream<TValue> stream;
    private PipedRDFIterator<TValue> iter;
    private Thread parserThread;
    private boolean finished = false;
    private boolean ignoreBadTuples = true;
    private boolean parserFinished = false;
    private Throwable parserError = null;

    public void initialize(InputSplit genericSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        LOG.debug("initialize({}, {})", (Object)genericSplit, (Object)context);
        if (!(genericSplit instanceof FileSplit)) {
            throw new IOException("This record reader only supports FileSplit inputs");
        }
        FileSplit split = (FileSplit)genericSplit;
        Configuration config = context.getConfiguration();
        this.ignoreBadTuples = config.getBoolean("rdf.io.input.ignore-bad-tuples", true);
        if (this.ignoreBadTuples) {
            LOG.warn("Configured to ignore bad tuples, parsing errors will be logged and further parsing aborted but no user visible errors will be thrown.  Consider setting {} to false to disable this behaviour", (Object)"rdf.io.input.ignore-bad-tuples");
        }
        if (split.getStart() > 0L) {
            throw new IOException("This record reader requires a file split which covers the entire file");
        }
        Path file = split.getPath();
        long totalLength = file.getFileSystem(context.getConfiguration()).getFileStatus(file).getLen();
        CompressionCodecFactory factory = new CompressionCodecFactory(config);
        this.compressionCodecs = factory.getCodec(file);
        LOG.info(String.format("Got split with start %d and length %d for file with total length of %d", split.getStart(), split.getLength(), totalLength));
        if (totalLength > split.getLength()) {
            throw new IOException("This record reader requires a file split which covers the entire file");
        }
        FileSystem fs = file.getFileSystem(config);
        FSDataInputStream fileIn = fs.open(file);
        this.length = split.getLength();
        this.input = this.compressionCodecs != null ? new TrackedInputStream((InputStream)this.compressionCodecs.createInputStream((InputStream)fileIn)) : new TrackedInputStream((InputStream)fileIn);
        this.iter = this.getPipedIterator();
        this.stream = this.getPipedStream(this.iter, this.input);
        ParserProfile profile = RdfIOUtils.createParserProfile((JobContext)context, file);
        Runnable parserRunnable = this.createRunnable(this, this.input, this.stream, this.getRdfLanguage(), profile);
        this.parserThread = new Thread(parserRunnable);
        this.parserThread.setDaemon(true);
        this.parserThread.start();
    }

    protected abstract PipedRDFIterator<TValue> getPipedIterator();

    protected abstract TrackedPipedRDFStream<TValue> getPipedStream(PipedRDFIterator<TValue> var1, TrackableInputStream var2);

    protected abstract Lang getRdfLanguage();

    private Runnable createRunnable(final AbstractWholeFileNodeTupleReader reader, final InputStream input, final PipedRDFStream<TValue> stream, final Lang lang, final ParserProfile profile) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    ReaderRIOT riotReader = RDFDataMgr.createReader((Lang)lang);
                    riotReader.setParserProfile(profile);
                    riotReader.read(input, null, lang.getContentType(), (StreamRDF)stream, null);
                    reader.setParserFinished(null);
                }
                catch (Throwable e) {
                    reader.setParserFinished(e);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setParserFinished(Throwable e) {
        Thread thread = this.parserThread;
        synchronized (thread) {
            this.parserError = e;
            this.parserFinished = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForParserFinished() throws InterruptedException {
        while (true) {
            Thread thread = this.parserThread;
            synchronized (thread) {
                if (this.parserFinished) {
                    return;
                }
            }
            Thread.sleep(50L);
        }
    }

    protected abstract T createInstance(TValue var1);

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.key == null) {
            this.key = new LongWritable();
        }
        if (this.finished) {
            return false;
        }
        try {
            if (this.iter.hasNext()) {
                Long l = this.stream.getPosition();
                if (l != null) {
                    this.key.set(l.longValue());
                    if (this.compressionCodecs != null && l > this.length) {
                        this.length = l + 1L;
                    }
                }
                this.tuple = this.createInstance(this.iter.next());
                return true;
            }
            this.waitForParserFinished();
            if (this.parserError != null) {
                LOG.error("Error parsing whole file, aborting further parsing", this.parserError);
                if (!this.ignoreBadTuples) {
                    throw new IOException("Error parsing whole file at position " + this.input.getBytesRead() + ", aborting further parsing", this.parserError);
                }
            }
            this.key = null;
            this.tuple = null;
            this.finished = true;
            if (this.compressionCodecs != null) {
                --this.length;
            }
            return false;
        }
        catch (Throwable e) {
            LOG.error("Error parsing whole file, aborting further parsing", e);
            if (!this.ignoreBadTuples) {
                this.iter.close();
                throw new IOException("Error parsing whole file at position " + this.input.getBytesRead() + ", aborting further parsing", e);
            }
            this.key = null;
            this.tuple = null;
            this.finished = true;
            return false;
        }
    }

    public LongWritable getCurrentKey() throws IOException, InterruptedException {
        return this.key;
    }

    public T getCurrentValue() throws IOException, InterruptedException {
        return this.tuple;
    }

    public float getProgress() throws IOException, InterruptedException {
        float progress = 0.0f;
        progress = this.key == null ? (this.finished ? 1.0f : 0.0f) : (this.key.get() == Long.MIN_VALUE ? (this.finished ? 1.0f : 0.5f) : (float)this.key.get() / (float)this.length);
        LOG.debug("getProgress() --> {}", (Object)Float.valueOf(progress));
        return progress;
    }

    public void close() throws IOException {
        this.iter.close();
        this.input.close();
        this.finished = true;
    }
}

