/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.trans.recovery;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.dboe.base.file.BufferChannel;
import org.apache.jena.dboe.base.file.BufferChannelFile;
import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.dboe.trans.data.TransBlob;
import org.apache.jena.dboe.transaction.txn.ComponentId;
import org.apache.jena.dboe.transaction.txn.TransactionCoordinator;
import org.apache.jena.dboe.transaction.txn.TransactionalComponent;
import org.apache.jena.dboe.transaction.txn.journal.Journal;
import org.apache.jena.dboe.transaction.txn.journal.JournalEntry;
import org.apache.jena.dboe.transaction.txn.journal.JournalEntryType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestRecovery {
    @Rule
    public TemporaryFolder dir = new TemporaryFolder();
    private String journal;
    private String data;
    private String data1;
    private String data2;

    @Before
    public void before() {
        this.journal = this.dir.getRoot().getAbsolutePath() + "/journal.jrnl";
        this.data = this.dir.getRoot().getAbsolutePath() + "/blob.data";
        this.data1 = this.dir.getRoot().getAbsolutePath() + "/blob.data-1";
        this.data2 = this.dir.getRoot().getAbsolutePath() + "/blob.data-2";
        FileOps.ensureDir((String)this.dir.getRoot().getAbsolutePath());
        FileOps.deleteSilent((String)this.journal);
        FileOps.deleteSilent((String)this.data);
        FileOps.deleteSilent((String)this.data1);
        FileOps.deleteSilent((String)this.data2);
    }

    @After
    public void after() {
        FileOps.deleteSilent((String)this.journal);
        FileOps.deleteSilent((String)this.data);
    }

    @Test
    public void recoverBlobFile_1() throws Exception {
        String str = "Hello Journal";
        ComponentId cid = ComponentId.allocLocal();
        Journal journal = Journal.create((Location)Location.create((String)this.dir.getRoot().getAbsolutePath()));
        journal.write(JournalEntryType.REDO, cid, IO.stringToByteBuffer((String)str));
        journal.writeJournal(JournalEntry.COMMIT);
        journal.close();
        TransactionCoordinator coord = new TransactionCoordinator(Location.create((String)this.dir.getRoot().getAbsolutePath()));
        BufferChannelFile chan = BufferChannelFile.create((String)this.data);
        TransBlob tBlob = new TransBlob(cid, (BufferChannel)chan);
        coord.add((TransactionalComponent)tBlob);
        coord.start();
        ByteBuffer blob = tBlob.getBlob();
        Assert.assertNotNull((Object)blob);
        String s = IO.byteBufferToString((ByteBuffer)blob);
        Assert.assertEquals((Object)str, (Object)s);
        coord.shutdown();
    }

    @Test
    public void recoverBlobFile_2() throws Exception {
        String str1 = "Recovery One";
        String str2 = "Recovery Two";
        ComponentId cid1 = ComponentId.allocLocal();
        ComponentId cid2 = ComponentId.allocLocal();
        Journal journal = Journal.create((Location)Location.create((String)this.dir.getRoot().getAbsolutePath()));
        journal.write(JournalEntryType.REDO, cid1, IO.stringToByteBuffer((String)str1));
        journal.write(JournalEntryType.REDO, cid2, IO.stringToByteBuffer((String)str2));
        journal.writeJournal(JournalEntry.COMMIT);
        journal.close();
        journal = Journal.create((Location)Location.create((String)this.dir.getRoot().getAbsolutePath()));
        BufferChannelFile chan = BufferChannelFile.create((String)this.data);
        TransBlob tBlob1 = new TransBlob(cid1, (BufferChannel)chan);
        TransBlob tBlob2 = new TransBlob(cid2, (BufferChannel)chan);
        TransactionCoordinator coord = new TransactionCoordinator(journal, Arrays.asList(tBlob1, tBlob2));
        coord.start();
        ByteBuffer blob1 = tBlob1.getBlob();
        Assert.assertNotNull((Object)blob1);
        String s1 = IO.byteBufferToString((ByteBuffer)blob1);
        Assert.assertEquals((Object)str1, (Object)s1);
        ByteBuffer blob2 = tBlob2.getBlob();
        Assert.assertNotNull((Object)blob2);
        String s2 = IO.byteBufferToString((ByteBuffer)blob2);
        Assert.assertEquals((Object)str2, (Object)s2);
        Assert.assertNotEquals((Object)str1, (Object)str2);
        coord.shutdown();
    }
}

