/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.trans.data;

import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.dboe.base.file.BufferChannel;
import org.apache.jena.dboe.base.file.BufferChannelFile;
import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.dboe.trans.data.TestTransBlob;
import org.apache.jena.dboe.trans.data.TransBlob;
import org.apache.jena.dboe.transaction.TransactionalFactory;
import org.apache.jena.dboe.transaction.txn.ComponentId;
import org.apache.jena.dboe.transaction.txn.TransactionalComponent;
import org.apache.jena.dboe.transaction.txn.journal.Journal;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.system.Txn;
import org.apache.jena.util.FileUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestTransBlobPersistent
extends Assert {
    private static final String DIR = "target/blobtest";
    private static final String JRNL = "target/blobtest/journal.jrnl";
    private static final String DATA = "target/blobtest/blob.data";

    @BeforeClass
    public static void beforeClass() {
        FileOps.ensureDir((String)DIR);
    }

    @Before
    public void before() {
        FileOps.deleteSilent((String)JRNL);
        FileOps.deleteSilent((String)DATA);
    }

    @AfterClass
    public static void afterClass() {
        FileOps.deleteSilent((String)JRNL);
        FileOps.deleteSilent((String)DATA);
    }

    @Test
    public void transBlobFile_1() throws Exception {
        Journal journal = Journal.create((Location)Location.create((String)DIR));
        BufferChannelFile chan = BufferChannelFile.create((String)DATA);
        ComponentId cid = ComponentId.allocLocal();
        TransBlob transBlob = new TransBlob(cid, (BufferChannel)chan);
        org.apache.jena.dboe.transaction.Transactional transactional = TransactionalFactory.createTransactional((Journal)journal, (TransactionalComponent[])new TransactionalComponent[]{transBlob});
        String str = "Hello";
        TestTransBlob.write(transactional, transBlob, str);
        chan.close();
        journal.close();
        String s = FileUtils.readWholeFileAsUTF8((String)DATA);
        TestTransBlobPersistent.assertEquals((Object)str, (Object)s);
    }

    @Test
    public void transBlobFile_2() throws Exception {
        Journal journal = Journal.create((Location)Location.create((String)DIR));
        BufferChannelFile chan = BufferChannelFile.create((String)DATA);
        ComponentId cid = ComponentId.allocLocal();
        TransBlob transBlob = new TransBlob(cid, (BufferChannel)chan);
        org.apache.jena.dboe.transaction.Transactional transactional = TransactionalFactory.createTransactional((Journal)journal, (TransactionalComponent[])new TransactionalComponent[]{transBlob});
        String str = "Hello1";
        Txn.executeWrite((Transactional)transactional, () -> transBlob.setString("one"));
        Txn.executeWrite((Transactional)transactional, () -> transBlob.setString("two"));
        chan.close();
        journal.close();
        String s = FileUtils.readWholeFileAsUTF8((String)DATA);
        TestTransBlobPersistent.assertEquals((Object)"two", (Object)s);
    }

    @Test
    public void transBlobFile_3() throws Exception {
        String str = "Hello World";
        Journal journal = Journal.create((Location)Location.create((String)DIR));
        BufferChannelFile chan = BufferChannelFile.create((String)DATA);
        ComponentId cid = ComponentId.allocLocal();
        TransBlob transBlob = new TransBlob(cid, (BufferChannel)chan);
        org.apache.jena.dboe.transaction.Transactional transactional = TransactionalFactory.createTransactional((Journal)journal, (TransactionalComponent[])new TransactionalComponent[]{transBlob});
        TestTransBlob.write(transactional, transBlob, str);
        chan.close();
        journal.close();
        journal = Journal.create((Location)Location.create((String)DIR));
        chan = BufferChannelFile.create((String)DATA);
        cid = ComponentId.allocLocal();
        transBlob = new TransBlob(cid, (BufferChannel)chan);
        transactional = TransactionalFactory.createTransactional((Journal)journal, (TransactionalComponent[])new TransactionalComponent[]{transBlob});
        String s = TestTransBlob.read(transactional, transBlob);
        TestTransBlobPersistent.assertEquals((Object)str, (Object)s);
    }
}

