/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.trans.data;

import org.apache.jena.dboe.base.file.AbstractTestBinaryDataFile;
import org.apache.jena.dboe.base.file.BinaryDataFile;
import org.apache.jena.dboe.base.file.BinaryDataFileMem;
import org.apache.jena.dboe.base.file.BufferChannel;
import org.apache.jena.dboe.base.file.FileFactory;
import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.dboe.trans.data.TransBinaryDataFile;
import org.apache.jena.dboe.transaction.Transactional;
import org.apache.jena.dboe.transaction.TransactionalFactory;
import org.apache.jena.dboe.transaction.txn.ComponentId;
import org.apache.jena.dboe.transaction.txn.TransactionalComponent;
import org.apache.jena.dboe.transaction.txn.journal.Journal;
import org.apache.jena.query.ReadWrite;

public class TestTransBinaryDataFileGeneral
extends AbstractTestBinaryDataFile {
    private Journal journal;
    private BinaryDataFile baseBinData;
    private TransBinaryDataFile transBinData;
    private Transactional transactional;

    protected BinaryDataFile createBinaryDataFile() {
        this.journal = Journal.create((Location)Location.mem());
        this.baseBinData = new BinaryDataFileMem();
        BufferChannel chan = FileFactory.createBufferChannelMem();
        ComponentId cid = ComponentId.allocLocal();
        this.transBinData = new TransBinaryDataFile(this.baseBinData, cid, chan);
        this.transBinData.open();
        this.transactional = TransactionalFactory.createTransactional((Journal)this.journal, (TransactionalComponent[])new TransactionalComponent[]{this.transBinData});
        this.transactional.begin(ReadWrite.WRITE);
        return this.transBinData;
    }

    protected void releaseBinaryDataFile(BinaryDataFile file) {
        if (file.isOpen()) {
            this.transactional.commit();
            this.transactional.end();
            this.baseBinData.close();
        }
    }
}

