/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.trans.bplustree;

import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.dboe.index.Index;
import org.apache.jena.dboe.index.test.IndexTestLib;
import org.apache.jena.dboe.trans.bplustree.BPlusTree;
import org.apache.jena.dboe.trans.bplustree.BPlusTreeFactory;
import org.apache.jena.dboe.transaction.TransactionalFactory;
import org.apache.jena.dboe.transaction.txn.TransactionalComponent;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.system.Txn;
import org.junit.Assert;
import org.junit.Test;

public class TestBPlusTreeTxn
extends Assert {
    static BPlusTree createBPTree() {
        return BPlusTreeFactory.makeMem((int)2, (int)2, (int)4, (int)0);
    }

    static org.apache.jena.dboe.transaction.Transactional transactional(TransactionalComponent ... components) {
        return TestBPlusTreeTxn.transactional(Location.mem(), components);
    }

    static org.apache.jena.dboe.transaction.Transactional transactional(Location location, TransactionalComponent ... components) {
        return TransactionalFactory.createTransactional((Location)location, (TransactionalComponent[])components);
    }

    @Test
    public void bptree_txn_01() {
        BPlusTree bpt = TestBPlusTreeTxn.createBPTree();
        TestBPlusTreeTxn.assertNotNull((Object)bpt.getComponentId());
        int outerRootIdx1 = bpt.getRootId();
        org.apache.jena.dboe.transaction.Transactional thing = TestBPlusTreeTxn.transactional(new TransactionalComponent[]{bpt});
        Txn.executeWrite((Transactional)thing, () -> IndexTestLib.add((Index)bpt, (int[])new int[]{1, 2, 3, 4}));
        int outerRootIdx2 = bpt.getRootId();
        TestBPlusTreeTxn.assertNotEquals((String)"After txn", (long)outerRootIdx1, (long)outerRootIdx2);
    }

    @Test
    public void bptree_txn_02() {
        BPlusTree bpt = TestBPlusTreeTxn.createBPTree();
        int outerRootIdx1 = bpt.getRootId();
        org.apache.jena.dboe.transaction.Transactional thing = TestBPlusTreeTxn.transactional(new TransactionalComponent[]{bpt});
        Txn.executeWrite((Transactional)thing, () -> {
            int rootIdx1 = bpt.getRootId();
            TestBPlusTreeTxn.assertEquals((String)"Inside txn (1)", (long)outerRootIdx1, (long)rootIdx1);
            IndexTestLib.add((Index)bpt, (int[])new int[]{1});
            int rootIdx2 = bpt.getRootId();
            TestBPlusTreeTxn.assertNotEquals((String)"Inside txn (2)", (long)rootIdx1, (long)rootIdx2);
            IndexTestLib.add((Index)bpt, (int[])new int[]{2, 3, 4});
            int rootIdx3 = bpt.getRootId();
            TestBPlusTreeTxn.assertEquals((String)"Inside txn (3)", (long)rootIdx2, (long)rootIdx3);
        });
        int outerRootIdx2 = bpt.getRootId();
        TestBPlusTreeTxn.assertNotEquals((String)"After txn", (long)outerRootIdx1, (long)outerRootIdx2);
    }

    @Test
    public void bptree_txn_03() {
        BPlusTree bpt = TestBPlusTreeTxn.createBPTree();
        int outerRootIdx1 = bpt.getRootId();
        org.apache.jena.dboe.transaction.Transactional thing = TestBPlusTreeTxn.transactional(new TransactionalComponent[]{bpt});
        thing.begin(ReadWrite.WRITE);
        IndexTestLib.add((Index)bpt, (int[])new int[]{1, 2, 3, 4});
        thing.abort();
        thing.end();
        int outerRootIdx2 = bpt.getRootId();
        TestBPlusTreeTxn.assertEquals((String)"After txn", (long)outerRootIdx1, (long)outerRootIdx2);
    }

    @Test
    public void bptree_txn_04() {
        BPlusTree bpt = TestBPlusTreeTxn.createBPTree();
        int outerRootIdx1 = bpt.getRootId();
        org.apache.jena.dboe.transaction.Transactional thing = TestBPlusTreeTxn.transactional(new TransactionalComponent[]{bpt});
        Txn.executeWrite((Transactional)thing, () -> IndexTestLib.add((Index)bpt, (int[])new int[]{1, 2, 3, 4}));
        int outerRootIdx2 = bpt.getRootId();
        TestBPlusTreeTxn.assertNotEquals((String)"After txn(1)", (long)outerRootIdx1, (long)outerRootIdx2);
        Txn.executeWrite((Transactional)thing, () -> IndexTestLib.add((Index)bpt, (int[])new int[]{5, 6}));
        int outerRootIdx3 = bpt.getRootId();
        TestBPlusTreeTxn.assertNotEquals((String)"After txn (2)", (long)outerRootIdx1, (long)outerRootIdx3);
        TestBPlusTreeTxn.assertNotEquals((String)"After txn (3)", (long)outerRootIdx2, (long)outerRootIdx3);
    }

    @Test
    public void bptree_txn_05() {
        BPlusTree bpt = TestBPlusTreeTxn.createBPTree();
        int outerRootIdx1 = bpt.getRootId();
        org.apache.jena.dboe.transaction.Transactional thing = TestBPlusTreeTxn.transactional(new TransactionalComponent[]{bpt});
        Txn.executeWrite((Transactional)thing, () -> IndexTestLib.add((Index)bpt, (int[])new int[]{1, 2, 3}));
        int outerRootIdx2 = bpt.getRootId();
        TestBPlusTreeTxn.assertNotEquals((String)"After txn(1)", (long)outerRootIdx1, (long)outerRootIdx2);
        Txn.executeWrite((Transactional)thing, () -> IndexTestLib.add((Index)bpt, (int[])new int[]{1, 2}));
        int outerRootIdx3 = bpt.getRootId();
        TestBPlusTreeTxn.assertNotEquals((String)"After txn (2)", (long)outerRootIdx1, (long)outerRootIdx3);
        TestBPlusTreeTxn.assertEquals((String)"After txn (3)", (long)outerRootIdx2, (long)outerRootIdx3);
    }

    @Test
    public void bptree_txn_06() {
        BPlusTree bpt = TestBPlusTreeTxn.createBPTree();
        int outerRootIdx1 = bpt.getRootId();
        org.apache.jena.dboe.transaction.Transactional thing = TestBPlusTreeTxn.transactional(new TransactionalComponent[]{bpt});
        Txn.executeWrite((Transactional)thing, () -> IndexTestLib.add((Index)bpt, (int[])new int[]{1, 2, 3}));
        int outerRootIdx2 = bpt.getRootId();
        TestBPlusTreeTxn.assertNotEquals((String)"After txn(1)", (long)outerRootIdx1, (long)outerRootIdx2);
        Txn.executeWrite((Transactional)thing, () -> IndexTestLib.delete((Index)bpt, (int[])new int[]{5, 6}));
        int outerRootIdx3 = bpt.getRootId();
        TestBPlusTreeTxn.assertNotEquals((String)"After txn (2)", (long)outerRootIdx1, (long)outerRootIdx3);
        TestBPlusTreeTxn.assertEquals((String)"After txn (3)", (long)outerRootIdx2, (long)outerRootIdx3);
    }

    @Test
    public void bptree_txn_10() {
        BPlusTree bpt1 = TestBPlusTreeTxn.createBPTree();
        BPlusTree bpt2 = TestBPlusTreeTxn.createBPTree();
        TestBPlusTreeTxn.assertNotEquals((Object)bpt1.getComponentId(), (Object)bpt2.getComponentId());
        org.apache.jena.dboe.transaction.Transactional thing = TestBPlusTreeTxn.transactional(new TransactionalComponent[]{bpt1, bpt2});
        Txn.executeWrite((Transactional)thing, () -> {
            IndexTestLib.add((Index)bpt1, (int[])new int[]{1, 2, 3});
            IndexTestLib.add((Index)bpt2, (int[])new int[]{4, 5});
        });
        Txn.executeRead((Transactional)thing, () -> {
            IndexTestLib.testIndexContents((Index)bpt2, (int[])new int[]{4, 5});
            IndexTestLib.testIndexContents((Index)bpt1, (int[])new int[]{1, 2, 3});
        });
    }

    @Test
    public void bptree_txn_11() {
        BPlusTree bpt1 = TestBPlusTreeTxn.createBPTree();
        BPlusTree bpt2 = TestBPlusTreeTxn.createBPTree();
        TestBPlusTreeTxn.assertNotEquals((Object)bpt1.getComponentId(), (Object)bpt2.getComponentId());
        org.apache.jena.dboe.transaction.Transactional thing = TestBPlusTreeTxn.transactional(new TransactionalComponent[]{bpt1, bpt2});
        Txn.executeWrite((Transactional)thing, () -> {
            IndexTestLib.add((Index)bpt1, (int[])new int[]{2, 1});
            IndexTestLib.add((Index)bpt2, (int[])new int[]{3, 4, 5});
        });
        Txn.executeRead((Transactional)thing, () -> {
            IndexTestLib.testIndexContents((Index)bpt2, (int[])new int[]{3, 4, 5});
            IndexTestLib.testIndexContents((Index)bpt1, (int[])new int[]{1, 2});
        });
        thing.begin(ReadWrite.WRITE);
        IndexTestLib.add((Index)bpt1, (int[])new int[]{9, 10});
        IndexTestLib.delete((Index)bpt2, (int[])new int[]{3, 11});
        thing.abort();
        Txn.executeRead((Transactional)thing, () -> {
            IndexTestLib.testIndexContents((Index)bpt2, (int[])new int[]{3, 4, 5});
            IndexTestLib.testIndexContents((Index)bpt1, (int[])new int[]{1, 2});
        });
        Txn.executeWrite((Transactional)thing, () -> {
            IndexTestLib.delete((Index)bpt1, (int[])new int[]{1, 3});
            IndexTestLib.add((Index)bpt1, (int[])new int[]{4});
            IndexTestLib.add((Index)bpt2, (int[])new int[]{11, 12, 13});
        });
        Txn.executeRead((Transactional)thing, () -> {
            IndexTestLib.testIndexContents((Index)bpt2, (int[])new int[]{3, 4, 5, 11, 12, 13});
            IndexTestLib.testIndexContents((Index)bpt1, (int[])new int[]{2, 4});
        });
    }
}

