/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.trans.bplustree;

import java.util.List;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.dboe.base.block.BlockMgr;
import org.apache.jena.dboe.base.record.Record;
import org.apache.jena.dboe.index.Index;
import org.apache.jena.dboe.index.test.AbstractTestRangeIndex;
import org.apache.jena.dboe.index.test.IndexTestLib;
import org.apache.jena.dboe.sys.SystemIndex;
import org.apache.jena.dboe.test.RecordLib;
import org.apache.jena.dboe.trans.bplustree.BPT;
import org.apache.jena.dboe.trans.bplustree.BPlusTree;
import org.apache.jena.dboe.trans.bplustree.BPlusTreeFactory;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public class TestBPlusTreeNonTxn
extends AbstractTestRangeIndex {
    static boolean addTracker = false;
    static boolean addLogger = false;
    static boolean originalNullOut;

    @BeforeClass
    public static void beforeClass() {
        BPT.CheckingNode = true;
        originalNullOut = SystemIndex.getNullOut();
        SystemIndex.setNullOut((boolean)true);
    }

    @AfterClass
    public static void afterClass() {
        SystemIndex.setNullOut((boolean)originalNullOut);
    }

    protected void testClearX(int N) {
        int[] keys = new int[N];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = i;
        }
        BPlusTree rIndex = this.makeRangeIndex(2, 2);
        IndexTestLib.add((Index)rIndex, (int[])keys);
        rIndex.dump();
        if (N > 0) {
            TestBPlusTreeNonTxn.assertFalse((boolean)rIndex.isEmpty());
        }
        List x = RecordLib.intToRecord((int[])keys, (int)4);
        for (int i = 0; i < keys.length; ++i) {
            System.out.println(i + ": " + x.get(i));
            rIndex.delete((Record)x.get(i));
        }
        TestBPlusTreeNonTxn.assertTrue((boolean)rIndex.isEmpty());
    }

    protected BPlusTree makeRangeIndex(int order, int minRecords) {
        BPlusTree bpt = BPlusTreeFactory.makeMem((int)order, (int)minRecords, (int)4, (int)0);
        if (addLogger) {
            LogCtl.disable(BlockMgr.class);
            bpt = BPlusTreeFactory.addLogging((BPlusTree)bpt);
        }
        if (addTracker) {
            bpt = BPlusTreeFactory.addTracking((BPlusTree)bpt);
        }
        bpt.nonTransactional();
        return bpt;
    }
}

