/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.trans.bplustree;

import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.dboe.base.block.BlockMgr;
import org.apache.jena.dboe.index.test.AbstractTestIndex;
import org.apache.jena.dboe.sys.SystemIndex;
import org.apache.jena.dboe.trans.bplustree.BPT;
import org.apache.jena.dboe.trans.bplustree.BPlusTree;
import org.apache.jena.dboe.trans.bplustree.BPlusTreeFactory;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public class TestBPlusTreeIndexNonTxn
extends AbstractTestIndex {
    static boolean addTracker = true;
    static boolean addLogger = false;
    static boolean originalNullOut;

    @BeforeClass
    public static void beforeClass() {
        BPT.CheckingNode = true;
        originalNullOut = SystemIndex.getNullOut();
        SystemIndex.setNullOut((boolean)true);
    }

    @AfterClass
    public static void afterClass() {
        SystemIndex.setNullOut((boolean)originalNullOut);
    }

    protected BPlusTree makeIndex(int order, int minRecords) {
        BPlusTree bpt = BPlusTreeFactory.makeMem((int)order, (int)minRecords, (int)4, (int)0);
        if (addLogger) {
            LogCtl.disable(BlockMgr.class);
            bpt = BPlusTreeFactory.addLogging((BPlusTree)bpt);
        }
        if (addTracker) {
            bpt = BPlusTreeFactory.addTracking((BPlusTree)bpt);
        }
        bpt.nonTransactional();
        return bpt;
    }
}

