/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.trans.bplustree;

import org.apache.jena.dboe.index.Index;
import org.apache.jena.dboe.index.RangeIndex;
import org.apache.jena.dboe.index.test.RangeIndexMaker;
import org.apache.jena.dboe.trans.bplustree.BPlusTree;
import org.apache.jena.dboe.trans.bplustree.BPlusTreeFactory;

public class BPlusTreeMaker
implements RangeIndexMaker {
    private int order;
    private int recordOrder;
    private boolean trackers;

    public BPlusTreeMaker(int order, int recordOrder, boolean trackers) {
        this.order = order;
        this.recordOrder = recordOrder;
        this.trackers = trackers;
    }

    public Index makeIndex() {
        return this.makeRangeIndex();
    }

    public RangeIndex makeRangeIndex() {
        BPlusTree bpTree = BPlusTreeFactory.makeMem((int)this.order, (int)this.recordOrder, (int)4, (int)0);
        if (this.trackers) {
            bpTree = BPlusTreeFactory.addTracking((BPlusTree)bpTree);
        }
        return bpTree;
    }

    public String getLabel() {
        return "B+Tree order = " + this.order;
    }
}

