/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.nodevalue;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Map;
import java.util.Set;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;

public class NodeValueDigest {
    private static Map<String, String> translateDigestFunctionNames = Map.of("md5", "MD-5", "sha1", "SHA-1", "sha224", "SHA-224", "sha256", "SHA-256", "sha384", "SHA-384", "sha512", "SHA-512");
    private static Set<String> digestFunctionName = Set.of("md5", "sha1", "sha224", "sha256", "sha384", "sha512");
    private static Cache<String, MessageDigest> digtests = CacheFactory.createCache((int)20);

    public static NodeValue calculateDigest(NodeValue nv, String digestName) {
        MessageDigest digest = NodeValueDigest.createDigest(digestName);
        return NodeValueDigest.calculate(nv, digest);
    }

    public static NodeValue function(NodeValue nv, String functionName) {
        if (!digestFunctionName.contains(functionName)) {
            throw new ExprEvalException("Digest not supported: " + functionName);
        }
        functionName = Lib.lowercase((String)functionName);
        String digestName = translateDigestFunctionNames.get(functionName);
        return NodeValueDigest.calculateDigest(nv, digestName);
    }

    private static MessageDigest getDigest(String digestName) {
        MessageDigest digest = (MessageDigest)digtests.get((Object)digestName, NodeValueDigest::createDigest);
        MessageDigest digest2 = null;
        try {
            digest2 = (MessageDigest)digest.clone();
            return digest2;
        }
        catch (CloneNotSupportedException ex) {
            digtests.remove((Object)digestName);
            return digest;
        }
    }

    private static MessageDigest createDigest(String digestName) {
        try {
            return MessageDigest.getInstance(digestName);
        }
        catch (Exception ex2) {
            throw new ARQInternalErrorException("Digest not provided in this Java system: " + digestName);
        }
    }

    private static NodeValue calculate(NodeValue nv, MessageDigest digest) {
        Node n = nv.asNode();
        if (!n.isLiteral()) {
            throw new ExprEvalException("Not a literal: " + String.valueOf(nv));
        }
        if (n.getLiteralLanguage() != null && !n.getLiteralLanguage().equals("")) {
            throw new ExprEvalException("Can't make a digest of an RDF term with a language tag");
        }
        if (n.getLiteralDatatype() != null && !XSDDatatype.XSDstring.equals((Object)n.getLiteralDatatype())) {
            throw new ExprEvalException("Not a simple literal nor an XSD string");
        }
        try {
            String x = n.getLiteralLexicalForm();
            byte[] b = x.getBytes(StandardCharsets.UTF_8);
            byte[] d = digest.digest(b);
            String y = Bytes.asHexLC((byte[])d);
            NodeValue result = NodeValue.makeString(y);
            return result;
        }
        catch (Exception ex2) {
            throw new ARQInternalErrorException(ex2);
        }
    }
}

