/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.util.Iterator;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIException0;
import org.apache.jena.iri.Violation;
import org.apache.jena.irix.IRIException;
import org.apache.jena.irix.IRIProviderJenaIRI;
import org.apache.jena.irix.SetupJenaIRI;
import org.apache.jena.irix.SystemIRIx;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;

class CheckerJenaIRI {
    private static ErrorHandler nullErrorHandler = new ErrorHandler(){

        @Override
        public void warning(String message, long line, long col) {
        }

        @Override
        public void error(String message, long line, long col) {
        }

        @Override
        public void fatal(String message, long line, long col) {
        }
    };

    CheckerJenaIRI() {
    }

    static boolean checkIRI(String iriStr, ErrorHandler errorHandler, long line, long col) {
        IRI iri = SetupJenaIRI.iriCheckerFactory().create(iriStr);
        boolean b = CheckerJenaIRI.iriViolations(iri, errorHandler, line, col);
        return b;
    }

    static boolean iriViolations(IRI iri, ErrorHandler errorHandler, long line, long col) {
        return CheckerJenaIRI.iriViolations(iri, errorHandler, false, true, line, col);
    }

    static boolean iriViolations(IRI iri, ErrorHandler errorHandler, boolean allowRelativeIRIs, boolean includeIRIwarnings, long line, long col) {
        if (!allowRelativeIRIs && iri.isRelative()) {
            CheckerJenaIRI.iriViolationMessage(iri.toString(), true, "Relative IRI: " + iri, line, col, errorHandler);
        }
        boolean isOK = true;
        if (iri.hasViolation(includeIRIwarnings)) {
            Iterator iter = iri.violations(includeIRIwarnings);
            while (iter.hasNext()) {
                Violation v = (Violation)iter.next();
                int code = v.getViolationCode();
                boolean isError = v.isError();
                if (code == 11 && v.getComponent() != 2) continue;
                isOK = false;
                String msg = v.getShortMessage();
                String iriStr = iri.toString();
                CheckerJenaIRI.iriViolationMessage(iriStr, isError, msg, line, col, errorHandler);
            }
        }
        return isOK;
    }

    static void iriViolationMessage(String iriStr, boolean isError, String msg, long line, long col, ErrorHandler errorHandler) {
        try {
            if (!(SystemIRIx.getProvider() instanceof IRIProviderJenaIRI)) {
                msg = "<" + iriStr + "> : " + (String)msg;
            }
            if (isError) {
                CheckerJenaIRI.errorHandler(errorHandler).warning("Bad IRI: " + (String)msg, line, col);
            } else {
                CheckerJenaIRI.errorHandler(errorHandler).warning("Not advised IRI: " + (String)msg, line, col);
            }
        }
        catch (IRIException0 | IRIException throwable) {
            // empty catch block
        }
    }

    private static ErrorHandler errorHandler(ErrorHandler handler) {
        return handler != null ? handler : ErrorHandlerFactory.errorHandlerStd;
    }
}

