/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.util.NodeUtils;

public class NodeCmp {
    public static int compareRDFTerms(Node node1, Node node2) {
        if (node1 == null) {
            if (node2 == null) {
                return 0;
            }
            return -1;
        }
        if (node2 == null) {
            return 1;
        }
        if (node1.isLiteral() && node2.isLiteral()) {
            return NodeCmp.compareLiteralsBySyntax(node1, node2);
        }
        if (node1.isVariable()) {
            if (node2.isVariable()) {
                return StrUtils.strCompare((String)node1.getName(), (String)node2.getName());
            }
            return -1;
        }
        if (node2.isVariable()) {
            return 1;
        }
        if (node1.isBlank()) {
            if (node2.isBlank()) {
                String s1 = node1.getBlankNodeLabel();
                String s2 = node2.getBlankNodeLabel();
                return StrUtils.strCompare((String)s1, (String)s2);
            }
            return -1;
        }
        if (node2.isBlank()) {
            return 1;
        }
        if (node1.isURI()) {
            if (node2.isURI()) {
                String s1 = node1.getURI();
                String s2 = node2.getURI();
                return StrUtils.strCompare((String)s1, (String)s2);
            }
            return -1;
        }
        if (node2.isURI()) {
            return 1;
        }
        if (node2.isLiteral()) {
            return 1;
        }
        if (node1.isLiteral()) {
            return -1;
        }
        if (node1.isNodeTriple() && node2.isNodeTriple()) {
            Triple t1 = node1.getTriple();
            Triple t2 = node2.getTriple();
            int x1 = NodeCmp.compareRDFTerms(t1.getSubject(), t2.getSubject());
            if (x1 != 0) {
                return x1;
            }
            int x2 = NodeCmp.compareRDFTerms(t1.getPredicate(), t2.getPredicate());
            if (x2 != 0) {
                return x2;
            }
            int x3 = NodeCmp.compareRDFTerms(t1.getObject(), t2.getObject());
            if (x3 != 0) {
                return x3;
            }
            return 0;
        }
        if (node2.isNodeTriple()) {
            return 1;
        }
        throw new ARQInternalErrorException("Compare: " + node1 + "  " + node2);
    }

    private static int compareLiteralsBySyntax(Node node1, Node node2) {
        String lex2;
        if (node1 == null || !node1.isLiteral() || node2 == null || !node2.isLiteral()) {
            throw new ARQInternalErrorException("compareLiteralsBySyntax called with non-literal: (" + node1 + "," + node2 + ")");
        }
        if (node1.equals((Object)node2)) {
            return 0;
        }
        if (NodeUtils.isSimpleString(node1) && NodeUtils.isSimpleString(node2)) {
            String lex1 = node1.getLiteralLexicalForm();
            String lex22 = node2.getLiteralLexicalForm();
            return StrUtils.strCompare((String)lex1, (String)lex22);
        }
        if (NodeUtils.isSimpleString(node1)) {
            return -1;
        }
        if (NodeUtils.isSimpleString(node2)) {
            return 1;
        }
        int x = NodeCmp.compareRDFLangTerms(node1, node2);
        if (x != 2) {
            return x;
        }
        boolean byDatatype = false;
        String lex1 = node1.getLiteralLexicalForm();
        int x2 = StrUtils.strCompare((String)lex1, (String)(lex2 = node2.getLiteralLexicalForm()));
        if (x2 != 0) {
            return x2;
        }
        String dt1 = node1.getLiteralDatatypeURI();
        String dt2 = node2.getLiteralDatatypeURI();
        return StrUtils.strCompare((String)dt1, (String)dt2);
    }

    private static int compareRDFLangTerms(Node node1, Node node2) {
        if (NodeUtils.isLangString(node1) && NodeUtils.isLangString(node2)) {
            String lex2;
            String lang2;
            String lang1 = node1.getLiteralLanguage();
            int x = StrUtils.strCompareIgnoreCase((String)lang1, (String)(lang2 = node2.getLiteralLanguage()));
            if (x != 0) {
                return x;
            }
            String lex1 = node1.getLiteralLexicalForm();
            x = StrUtils.strCompare((String)lex1, (String)(lex2 = node2.getLiteralLexicalForm()));
            if (x != 0) {
                return x;
            }
            x = StrUtils.strCompare((String)lang1, (String)lang2);
            if (x != 0) {
                return x;
            }
            throw new ARQInternalErrorException("Same lang tag (inc case, same lexical form but not node.equals");
        }
        if (NodeUtils.isLangString(node1)) {
            return -1;
        }
        if (NodeUtils.isLangString(node2)) {
            return 1;
        }
        return 2;
    }
}

