/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.exec;

import java.util.Iterator;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecAdapter;
import org.apache.jena.sparql.exec.ResultSetAdapter;
import org.apache.jena.sparql.util.Context;

public class QueryExecutionAdapter
implements QueryExecution {
    private final QueryExec qExec;
    private final Dataset dataset;

    public static QueryExecution adapt(QueryExec qExec) {
        if (qExec instanceof QueryExecAdapter) {
            return ((QueryExecAdapter)qExec).get();
        }
        return new QueryExecutionAdapter(qExec);
    }

    protected QueryExecutionAdapter(QueryExec qExec) {
        this.qExec = qExec;
        this.dataset = qExec == null ? null : (this.get().getDataset() != null ? DatasetFactory.wrap(this.get().getDataset()) : null);
    }

    protected QueryExec get() {
        return this.qExec;
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public Context getContext() {
        return this.get().getContext();
    }

    @Override
    public Query getQuery() {
        return this.get().getQuery();
    }

    @Override
    public String getQueryString() {
        return this.get().getQueryString();
    }

    @Override
    public ResultSet execSelect() {
        if (this.getDataset() != null) {
            return new ResultSetAdapter(this.get().select(), this.getDataset().getDefaultModel());
        }
        return ResultSet.adapt(this.get().select());
    }

    @Override
    public Model execConstruct() {
        return ModelFactory.createModelForGraph((Graph)this.get().construct());
    }

    @Override
    public Model execConstruct(Model model) {
        this.get().construct(model.getGraph());
        return model;
    }

    @Override
    public Iterator<Triple> execConstructTriples() {
        return this.get().constructTriples();
    }

    @Override
    public Iterator<Quad> execConstructQuads() {
        return this.get().constructQuads();
    }

    @Override
    public Dataset execConstructDataset() {
        return DatasetFactory.wrap(this.get().constructDataset());
    }

    @Override
    public Dataset execConstructDataset(Dataset dataset) {
        this.get().constructDataset(dataset.asDatasetGraph());
        return dataset;
    }

    @Override
    public Model execDescribe() {
        return ModelFactory.createModelForGraph((Graph)this.get().describe());
    }

    @Override
    public Model execDescribe(Model model) {
        this.get().describe(model.getGraph());
        return model;
    }

    @Override
    public Iterator<Triple> execDescribeTriples() {
        return this.get().describeTriples();
    }

    @Override
    public boolean execAsk() {
        return this.get().ask();
    }

    @Override
    public JsonArray execJson() {
        return this.get().execJson();
    }

    @Override
    public Iterator<JsonObject> execJsonItems() {
        return this.get().execJsonItems();
    }

    @Override
    public void abort() {
        this.get().abort();
    }

    @Override
    public void close() {
        this.get().close();
    }

    @Override
    public boolean isClosed() {
        return this.get().isClosed();
    }

    @Override
    public long getTimeout1() {
        return -1L;
    }

    @Override
    public long getTimeout2() {
        return -1L;
    }
}

