/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.data;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.data.AbortableComparator;
import org.apache.jena.atlas.data.AbstractDataBag;
import org.apache.jena.atlas.data.SerializationFactory;
import org.apache.jena.atlas.data.ThresholdPolicy;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorCloseable;
import org.apache.jena.atlas.lib.Sink;

public class SortedDataBag<E>
extends AbstractDataBag<E> {
    protected static int MAX_SPILL_FILES = 100;
    protected final ThresholdPolicy<E> policy;
    protected final SerializationFactory<E> serializationFactory;
    protected final AbortableComparator<E> comparator;
    protected boolean finishedAdding = false;
    protected boolean spilled = false;
    protected boolean closed = false;

    public SortedDataBag(ThresholdPolicy<E> policy, SerializationFactory<E> serializerFactory, Comparator<? super E> comparator) {
        this.policy = policy;
        this.serializationFactory = serializerFactory;
        this.comparator = new AbortableComparator<E>(comparator);
    }

    public void cancel() {
        this.comparator.cancel();
        this.close();
    }

    public boolean isCancelled() {
        return this.comparator.cancelled;
    }

    public boolean isClosed() {
        return this.closed;
    }

    protected void checkClosed() {
        if (this.closed) {
            throw new AtlasException("SortedDataBag is closed, no operations can be performed on it.");
        }
    }

    @Override
    public boolean isSorted() {
        return true;
    }

    @Override
    public boolean isDistinct() {
        return false;
    }

    @Override
    public void add(E item) {
        this.checkClosed();
        if (this.finishedAdding) {
            throw new AtlasException("SortedDataBag: Cannot add any more items after the writing phase is complete.");
        }
        if (this.policy.isThresholdExceeded()) {
            this.spill();
        }
        if (this.memory.add(item)) {
            this.policy.increment(item);
            ++this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void spill() {
        if (this.memory.size() > 0) {
            OutputStream out;
            try {
                out = this.getSpillStream();
            }
            catch (IOException e2) {
                throw new AtlasException((Throwable)e2);
            }
            Object[] array = this.memory.toArray();
            if (this.comparator.abortableSort(array) == AbortableComparator.Finish.COMPLETED) {
                try (Sink<E> serializer = this.serializationFactory.createSerializer(out);){
                    for (Object tuple : array) {
                        serializer.send(tuple);
                    }
                }
            }
            this.spilled = true;
            this.policy.reset();
            this.memory.clear();
        }
    }

    public void flush() {
        this.spill();
    }

    protected Iterator<E> getInputIterator(File spillFile) throws FileNotFoundException {
        InputStream in = SortedDataBag.getInputStream(spillFile);
        Iterator<E> deserializer = this.serializationFactory.createDeserializer(in);
        return Iter.onCloseIO(deserializer, (Closeable)in);
    }

    @Override
    public Iterator<E> iterator() {
        this.preMerge();
        return this.iterator(this.getSpillFiles().size());
    }

    private Iterator<E> iterator(int size) {
        this.checkClosed();
        int memSize = this.memory.size();
        if (!this.finishedAdding && memSize > 1) {
            Object[] array = this.memory.toArray();
            this.comparator.abortableSort(array);
            this.memory = Arrays.asList(array);
        }
        this.finishedAdding = true;
        if (this.spilled) {
            ArrayList inputs = new ArrayList(size + (memSize > 0 ? 1 : 0));
            if (memSize > 0) {
                inputs.add(this.memory.iterator());
            }
            for (int i = 0; i < size; ++i) {
                File spillFile = this.getSpillFiles().get(i);
                try {
                    Iterator<E> irc = this.getInputIterator(spillFile);
                    inputs.add(irc);
                    continue;
                }
                catch (FileNotFoundException e2) {
                    for (Iterator iterator : inputs) {
                        Iter.close((Iterator)iterator);
                    }
                    throw new AtlasException("Cannot find one of the spill files", (Throwable)e2);
                }
            }
            SpillSortIterator ssi = new SpillSortIterator(inputs, this.comparator);
            this.registerCloseableIterator(ssi);
            return ssi;
        }
        if (memSize > 0) {
            return this.memory.iterator();
        }
        return Iter.nullIterator();
    }

    private void preMerge() {
        if (this.getSpillFiles() == null || this.getSpillFiles().size() <= MAX_SPILL_FILES) {
            return;
        }
        try {
            while (this.getSpillFiles().size() > MAX_SPILL_FILES) {
                Sink<E> sink = this.serializationFactory.createSerializer(this.getSpillStream());
                Iterator<E> ssi = this.iterator(MAX_SPILL_FILES);
                try {
                    while (ssi.hasNext()) {
                        sink.send(ssi.next());
                    }
                }
                finally {
                    Iter.close(ssi);
                    sink.close();
                }
                ArrayList<File> toRemove = new ArrayList<File>(MAX_SPILL_FILES);
                for (int i = 0; i < MAX_SPILL_FILES; ++i) {
                    File file = this.getSpillFiles().get(i);
                    file.delete();
                    toRemove.add(file);
                }
                this.getSpillFiles().removeAll(toRemove);
                this.memory = new ArrayList();
            }
        }
        catch (IOException e2) {
            throw new AtlasException((Throwable)e2);
        }
    }

    public void close() {
        if (!this.closed) {
            this.closeIterators();
            this.deleteSpillFiles();
            this.memory = null;
            this.closed = true;
        }
    }

    protected static class SpillSortIterator<T>
    implements IteratorCloseable<T> {
        private final List<Iterator<T>> inputs;
        private final Comparator<? super T> comp;
        private final PriorityQueue<Item<T>> minHeap;

        public SpillSortIterator(List<Iterator<T>> inputs, Comparator<? super T> comp) {
            this.inputs = inputs;
            this.comp = comp;
            this.minHeap = new PriorityQueue(inputs.size());
            for (int i = 0; i < inputs.size(); ++i) {
                this.replaceItem(i);
            }
        }

        private void replaceItem(int index) {
            Iterator<T> it = this.inputs.get(index);
            if (it.hasNext()) {
                T tuple = it.next();
                this.minHeap.add(new Item<T>(index, tuple, this.comp));
            }
        }

        public boolean hasNext() {
            return this.minHeap.peek() != null;
        }

        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Item<T> curr = this.minHeap.poll();
            this.replaceItem(curr.getIndex());
            return curr.getTuple();
        }

        public void remove() {
            throw new UnsupportedOperationException("SpillSortIterator.remove");
        }

        public void close() {
            for (Iterator<T> it : this.inputs) {
                Iter.close(it);
            }
        }

        private final class Item<U>
        implements Comparable<Item<U>> {
            private final int index;
            private final U tuple;
            private final Comparator<? super U> c;

            public Item(int index, U tuple, Comparator<? super U> c) {
                this.index = index;
                this.tuple = tuple;
                this.c = c;
            }

            public int getIndex() {
                return this.index;
            }

            public U getTuple() {
                return this.tuple;
            }

            @Override
            public int compareTo(Item<U> o) {
                return null != this.c ? this.c.compare(this.tuple, o.getTuple()) : ((Comparable)this.tuple).compareTo(o.getTuple());
            }

            public boolean equals(Object obj) {
                if (obj instanceof Item) {
                    return this.compareTo((Item)obj) == 0;
                }
                return false;
            }

            public int hashCode() {
                return this.tuple.hashCode();
            }
        }
    }
}

