/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.rowset.rw.rs_json;

import java.util.function.Supplier;
import org.apache.jena.riot.rowset.rw.rs_json.ErrorEvent;
import org.apache.jena.riot.rowset.rw.rs_json.Severity;
import org.apache.jena.riot.system.ErrorHandler;

class ErrorHandlers {
    ErrorHandlers() {
    }

    static void relay(ErrorHandler errorHandler, Severity severity, ErrorEvent evt) {
        switch (severity) {
            case IGNORE: {
                break;
            }
            case WARNING: {
                errorHandler.warning(evt.getMessage(), evt.getLine(), evt.getCol());
                break;
            }
            case ERROR: {
                errorHandler.error(evt.getMessage(), evt.getLine(), evt.getCol());
                break;
            }
            case FATAL: {
                errorHandler.fatal(evt.getMessage(), evt.getLine(), evt.getCol());
            }
        }
    }

    static void relay(ErrorHandler errorHandler, Severity severity, Supplier<ErrorEvent> evtSupplier) {
        switch (severity) {
            case IGNORE: {
                break;
            }
            case WARNING: {
                ErrorEvent evt = evtSupplier.get();
                errorHandler.warning(evt.getMessage(), evt.getLine(), evt.getCol());
                break;
            }
            case ERROR: {
                ErrorEvent evt = evtSupplier.get();
                errorHandler.error(evt.getMessage(), evt.getLine(), evt.getCol());
                break;
            }
            case FATAL: {
                ErrorEvent evt = evtSupplier.get();
                errorHandler.fatal(evt.getMessage(), evt.getLine(), evt.getCol());
            }
        }
    }
}

