/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.rowset.rw;

import java.io.InputStream;
import java.io.Reader;
import java.util.Objects;
import org.apache.jena.atlas.lib.NotImplemented;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.rowset.RowSetReader;
import org.apache.jena.riot.rowset.RowSetReaderFactory;
import org.apache.jena.riot.thrift.ThriftRDF;
import org.apache.jena.sparql.exec.QueryExecResult;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.util.Context;

public class RowSetReaderThrift
implements RowSetReader {
    public static RowSetReaderFactory factory = lang -> {
        if (!Objects.equals(lang, ResultSetLang.RS_Thrift)) {
            throw new ResultSetException("RowSetReaderThrift for Thrift asked for a " + lang);
        }
        return new RowSetReaderThrift();
    };

    private RowSetReaderThrift() {
    }

    @Override
    public RowSet read(InputStream in, Context context2) {
        return ThriftRDF.readRowSet(in);
    }

    @Override
    public RowSet read(Reader in, Context context2) {
        throw new NotImplemented("Reading binary data from a java.io.Reader is not possible");
    }

    @Override
    public QueryExecResult readAny(InputStream in, Context context2) {
        return new QueryExecResult(this.read(in, context2));
    }
}

