/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.web;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.client.cache.CachingHttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.web.HttpException;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.ext.com.google.common.base.MoreObjects;
import org.apache.jena.query.ARQ;
import org.apache.jena.riot.web.HttpCaptureResponse;
import org.apache.jena.riot.web.HttpRequestTransformer;
import org.apache.jena.riot.web.HttpResponseHandler;
import org.apache.jena.riot.web.HttpResponseLib;
import org.apache.jena.sparql.engine.http.Params;
import org.apache.jena.web.HttpSC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpOp {
    private static Logger log = LoggerFactory.getLogger(HttpOp.class);
    private static AtomicLong counter = new AtomicLong(0L);
    private static final LaxRedirectStrategy laxRedirectStrategy = new LaxRedirectStrategy();
    private static HttpClient defaultHttpClient;
    public static final HttpClient initialDefaultHttpClient;
    public static final String ARQ_USER_AGENT;
    private static String userAgent;
    private static HttpResponseHandler nullHandler;
    private static HttpRequestTransformer reqTransformer;

    public static HttpClient createDefaultHttpClient() {
        return HttpOp.createPoolingHttpClient();
    }

    public static HttpClient getDefaultHttpClient() {
        return defaultHttpClient;
    }

    public static void setDefaultHttpClient(HttpClient client) {
        defaultHttpClient = (HttpClient)MoreObjects.firstNonNull((Object)client, (Object)initialDefaultHttpClient);
    }

    public static HttpRequestTransformer setRequestTransformer(HttpRequestTransformer tform) {
        HttpRequestTransformer tmp = reqTransformer;
        reqTransformer = tform;
        return tmp;
    }

    public static CloseableHttpClient createPoolingHttpClient() {
        return HttpOp.createPoolingHttpClientBuilder().build();
    }

    public static HttpClientBuilder createPoolingHttpClientBuilder() {
        String s = System.getProperty("http.maxConnections", "5");
        int max2 = Integer.parseInt(s);
        return HttpClientBuilder.create().useSystemProperties().setRedirectStrategy((RedirectStrategy)laxRedirectStrategy).setMaxConnPerRoute(max2).setMaxConnTotal(2 * max2);
    }

    public static CloseableHttpClient createCachingHttpClient() {
        String s = System.getProperty("http.maxConnections", "5");
        int max2 = Integer.parseInt(s);
        return CachingHttpClientBuilder.create().useSystemProperties().setRedirectStrategy((RedirectStrategy)laxRedirectStrategy).setMaxConnPerRoute(max2).setMaxConnTotal(2 * max2).build();
    }

    public static String getUserAgent() {
        return userAgent;
    }

    public static void setUserAgent(String userAgent) {
        HttpOp.userAgent = userAgent;
    }

    public static void execHttpGet(String url, String acceptHeader, HttpResponseHandler handler) {
        HttpOp.execHttpGet(url, acceptHeader, handler, null, null);
    }

    public static void execHttpGet(String url, String acceptHeader, HttpResponseHandler handler, HttpClient httpClient, HttpContext httpContext) {
        String requestURI = HttpOp.determineRequestURI(url);
        HttpGet httpget = new HttpGet(requestURI);
        HttpOp.exec(url, (HttpUriRequest)httpget, acceptHeader, handler, httpClient, httpContext);
    }

    public static TypedInputStream execHttpGet(String url) {
        CaptureInput handler = new CaptureInput();
        HttpOp.execHttpGet(url, null, handler, null, null);
        return (TypedInputStream)handler.get();
    }

    public static TypedInputStream execHttpGet(String url, String acceptHeader) {
        CaptureInput handler = new CaptureInput();
        HttpOp.execHttpGet(url, acceptHeader, handler, null, null);
        return (TypedInputStream)handler.get();
    }

    public static TypedInputStream execHttpGet(String url, String acceptHeader, HttpClient httpClient, HttpContext httpContext) {
        CaptureInput handler = new CaptureInput();
        try {
            HttpOp.execHttpGet(url, acceptHeader, handler, httpClient, httpContext);
        }
        catch (HttpException ex) {
            if (ex.getStatusCode() == 404) {
                return null;
            }
            throw ex;
        }
        return (TypedInputStream)handler.get();
    }

    public static String execHttpGetString(String url) {
        return HttpOp.execHttpGetString(url, null);
    }

    public static String execHttpGetString(String url, String acceptHeader) {
        CaptureString handler = new CaptureString();
        try {
            HttpOp.execHttpGet(url, acceptHeader, handler);
        }
        catch (HttpException ex) {
            if (ex.getStatusCode() == 404) {
                return null;
            }
            throw ex;
        }
        return handler.get();
    }

    public static void execHttpPost(String url, String contentType, String content) {
        HttpOp.execHttpPost(url, contentType, content, null, nullHandler, null, null);
    }

    public static TypedInputStream execHttpPostStream(String url, String contentType, String content, String acceptType) {
        return HttpOp.execHttpPostStream(url, contentType, content, acceptType, null, null);
    }

    public static void execHttpPost(String url, String contentType, String content, HttpClient httpClient, HttpContext httpContext) {
        HttpOp.execHttpPost(url, contentType, content, null, nullHandler, httpClient, httpContext);
    }

    public static TypedInputStream execHttpPostStream(String url, String contentType, String content, String acceptType, HttpClient httpClient, HttpContext httpContext) {
        CaptureInput handler = new CaptureInput();
        try {
            HttpOp.execHttpPost(url, contentType, content, acceptType, handler, httpClient, httpContext);
        }
        catch (HttpException ex) {
            if (ex.getStatusCode() == 404) {
                return null;
            }
            throw ex;
        }
        return handler.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execHttpPost(String url, String contentType, String content, String acceptType, HttpResponseHandler handler, HttpClient httpClient, HttpContext httpContext) {
        StringEntity e2 = null;
        try {
            if (content != null) {
                e2 = new StringEntity(content, StandardCharsets.UTF_8);
                e2.setContentType(contentType);
            }
            HttpOp.execHttpPost(url, (HttpEntity)e2, acceptType, handler, httpClient, httpContext);
        }
        catch (Throwable throwable) {
            HttpOp.closeEntity(e2);
            throw throwable;
        }
        HttpOp.closeEntity((HttpEntity)e2);
    }

    public static void execHttpPost(String url, String contentType, InputStream input, long length) {
        HttpOp.execHttpPost(url, contentType, input, length, null, nullHandler, null, null);
    }

    public static void execHttpPost(String url, String contentType, InputStream input, long length, String acceptType, HttpResponseHandler handler) {
        HttpOp.execHttpPost(url, contentType, input, length, acceptType, handler, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execHttpPost(String url, String contentType, InputStream input, long length, String acceptType, HttpResponseHandler handler, HttpClient httpClient, HttpContext httpContext) {
        InputStreamEntity e2 = new InputStreamEntity(input, length);
        String ct = HttpOp.decideContentType(contentType);
        e2.setContentType(ct);
        try {
            HttpOp.execHttpPost(url, (HttpEntity)e2, acceptType, handler, httpClient, httpContext);
        }
        finally {
            HttpOp.closeEntity((HttpEntity)e2);
        }
    }

    public static void execHttpPost(String url, HttpEntity entity) {
        HttpOp.execHttpPost(url, entity, null, nullHandler);
    }

    public static TypedInputStream execHttpPostStream(String url, HttpEntity entity, String acceptHeader) {
        CaptureInput handler = new CaptureInput();
        HttpOp.execHttpPost(url, entity, acceptHeader, handler);
        return handler.get();
    }

    public static void execHttpPost(String url, HttpEntity entity, String acceptString, HttpResponseHandler handler) {
        HttpOp.execHttpPost(url, entity, acceptString, handler, null, null);
    }

    public static void execHttpPost(String url, HttpEntity entity, HttpClient httpClient, HttpContext httpContext) {
        HttpOp.execHttpPost(url, entity, null, nullHandler, httpClient, httpContext);
    }

    public static TypedInputStream execHttpPostStream(String url, HttpEntity entity, String acceptHeader, HttpClient httpClient, HttpContext httpContext) {
        CaptureInput handler = new CaptureInput();
        HttpOp.execHttpPost(url, entity, acceptHeader, handler, httpClient, httpContext);
        return handler.get();
    }

    public static void execHttpPost(String url, HttpEntity entity, String acceptHeader, HttpResponseHandler handler, HttpClient httpClient, HttpContext httpContext) {
        String requestURI = HttpOp.determineRequestURI(url);
        HttpPost httppost = new HttpPost(requestURI);
        if (entity != null) {
            httppost.setEntity(entity);
        }
        HttpOp.exec(url, (HttpUriRequest)httppost, acceptHeader, handler, httpClient, httpContext);
    }

    public static void execHttpPostForm(String url, Params params) {
        HttpOp.execHttpPostForm(url, params, null, nullHandler);
    }

    public static TypedInputStream execHttpPostFormStream(String url, Params params, String acceptHeader) {
        return HttpOp.execHttpPostFormStream(url, params, acceptHeader, null, null);
    }

    public static TypedInputStream execHttpPostFormStream(String url, Params params, String acceptHeader, HttpClient httpClient, HttpContext httpContext) {
        CaptureInput handler = new CaptureInput();
        try {
            HttpOp.execHttpPostForm(url, params, acceptHeader, handler, httpClient, httpContext);
        }
        catch (HttpException ex) {
            if (ex.getStatusCode() == 404) {
                return null;
            }
            throw ex;
        }
        return handler.get();
    }

    public static void execHttpPostForm(String url, Params params, String acceptString, HttpResponseHandler handler) {
        HttpOp.execHttpPostForm(url, params, acceptString, handler, null, null);
    }

    public static void execHttpPostForm(String url, Params params, String acceptHeader, HttpResponseHandler handler, HttpClient httpClient, HttpContext httpContext) {
        if (handler == null) {
            throw new IllegalArgumentException("A HttpResponseHandler must be provided (e.g. HttpResponseLib.nullhandler)");
        }
        String requestURI = url;
        HttpPost httppost = new HttpPost(requestURI);
        httppost.setEntity(HttpOp.convertFormParams(params));
        HttpOp.exec(url, (HttpUriRequest)httppost, acceptHeader, handler, httpClient, httpContext);
    }

    public static void execHttpPut(String url, String contentType, String content) {
        HttpOp.execHttpPut(url, contentType, content, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execHttpPut(String url, String contentType, String content, HttpClient httpClient, HttpContext httpContext) {
        StringEntity e2 = null;
        try {
            e2 = new StringEntity(content, StandardCharsets.UTF_8);
            e2.setContentType(contentType);
            HttpOp.execHttpPut(url, (HttpEntity)e2, httpClient, httpContext);
        }
        catch (Throwable throwable) {
            HttpOp.closeEntity(e2);
            throw throwable;
        }
        HttpOp.closeEntity((HttpEntity)e2);
    }

    public static void execHttpPut(String url, String contentType, InputStream input, long length) {
        HttpOp.execHttpPut(url, contentType, input, length, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execHttpPut(String url, String contentType, InputStream input, long length, HttpClient httpClient, HttpContext httpContext) {
        InputStreamEntity e2 = new InputStreamEntity(input, length);
        String ct = HttpOp.decideContentType(contentType);
        e2.setContentType(ct);
        try {
            HttpOp.execHttpPut(url, (HttpEntity)e2, httpClient, httpContext);
        }
        finally {
            HttpOp.closeEntity((HttpEntity)e2);
        }
    }

    public static void execHttpPut(String url, HttpEntity entity) {
        HttpOp.execHttpPut(url, entity, null, null);
    }

    public static void execHttpPut(String url, HttpEntity entity, HttpClient httpClient, HttpContext httpContext) {
        String requestURI = HttpOp.determineRequestURI(url);
        HttpPut httpput = new HttpPut(requestURI);
        httpput.setEntity(entity);
        HttpOp.exec(url, (HttpUriRequest)httpput, null, nullHandler, httpClient, httpContext);
    }

    public static void execHttpHead(String url) {
        HttpOp.execHttpHead(url, null, nullHandler);
    }

    public static void execHttpHead(String url, String acceptString, HttpResponseHandler handler) {
        HttpOp.execHttpHead(url, acceptString, handler, null, null);
    }

    public static void execHttpHead(String url, String acceptString, HttpResponseHandler handler, HttpClient httpClient, HttpContext httpContext) {
        String requestURI = HttpOp.determineRequestURI(url);
        HttpHead httpHead = new HttpHead(requestURI);
        HttpOp.exec(url, (HttpUriRequest)httpHead, acceptString, handler, httpClient, httpContext);
    }

    public static void execHttpDelete(String url) {
        HttpOp.execHttpDelete(url, nullHandler);
    }

    public static void execHttpDelete(String url, HttpResponseHandler handler) {
        HttpOp.execHttpDelete(url, handler, null, null);
    }

    public static void execHttpDelete(String url, HttpResponseHandler handler, HttpClient httpClient, HttpContext httpContext) {
        HttpDelete httpDelete = new HttpDelete(url);
        HttpOp.exec(url, (HttpUriRequest)httpDelete, null, handler, null, httpContext);
    }

    private static void exec(String url, HttpUriRequest req, String acceptHeader, HttpResponseHandler handler, HttpClient httpClient, HttpContext httpContext) {
        httpClient = (HttpClient)MoreObjects.firstNonNull((Object)httpClient, (Object)HttpOp.getDefaultHttpClient());
        try {
            if (handler == null) {
                handler = nullHandler;
            }
            HttpUriRequest request = reqTransformer == null ? req : (HttpUriRequest)reqTransformer.apply(req);
            long id = counter.incrementAndGet();
            String baseURI = HttpOp.determineBaseIRI(url);
            if (log.isDebugEnabled()) {
                log.debug(String.format("[%d] %s %s", id, request.getMethod(), request.getURI().toString()));
            }
            if (acceptHeader != null) {
                request.addHeader("Accept", acceptHeader);
            }
            HttpOp.applyUserAgent((HttpMessage)request);
            HttpResponse response = httpClient.execute(request, httpContext);
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            if (HttpSC.isClientError(statusCode) || HttpSC.isServerError(statusCode)) {
                log.debug(String.format("[%d] %s %s", id, statusLine.getStatusCode(), statusLine.getReasonPhrase()));
                String contentPayload = HttpOp.readPayload(response.getEntity());
                throw new HttpException(statusLine.getStatusCode(), statusLine.getReasonPhrase(), contentPayload);
            }
            if (handler != null) {
                handler.handle(baseURI, response);
            }
        }
        catch (IOException ex) {
            throw new HttpException(ex);
        }
    }

    public static String readPayload(HttpEntity entity) throws IOException {
        return entity == null ? null : EntityUtils.toString((HttpEntity)entity, (Charset)ContentType.getOrDefault((HttpEntity)entity).getCharset());
    }

    public static void applyUserAgent(HttpMessage message) {
        if (userAgent != null) {
            message.setHeader("User-Agent", userAgent);
        }
    }

    private static HttpEntity convertFormParams(Params params) {
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        for (Params.Pair p : params.pairs()) {
            nvps.add(new BasicNameValuePair(p.getName(), p.getValue()));
        }
        UrlEncodedFormEntity e2 = new UrlEncodedFormEntity(nvps, StandardCharsets.UTF_8);
        return e2;
    }

    private static void closeEntity(HttpEntity entity) {
        if (entity == null) {
            return;
        }
        try {
            entity.getContent().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String decideContentType(String contentType) {
        Object ct = contentType;
        if (ct != null && !((String)ct).contains("charset=")) {
            ct = (String)ct + "; charset=UTF-8";
        }
        return ct;
    }

    private static String determineRequestURI(String uri) {
        String requestURI = uri;
        if (requestURI.contains("#")) {
            int i = requestURI.indexOf(35);
            requestURI = requestURI.substring(0, i);
        }
        return requestURI;
    }

    private static String determineBaseIRI(String uri) {
        String baseIRI = HttpOp.determineRequestURI(uri);
        if (baseIRI.contains("?")) {
            int i = baseIRI.indexOf(63);
            baseIRI = baseIRI.substring(0, i);
        }
        return baseIRI;
    }

    static {
        initialDefaultHttpClient = defaultHttpClient = HttpOp.createDefaultHttpClient();
        ARQ_USER_AGENT = "Apache-Jena-ARQ/" + ARQ.VERSION;
        userAgent = ARQ_USER_AGENT;
        nullHandler = HttpResponseLib.nullResponse;
        reqTransformer = null;
    }

    static class EOFInputStream
    extends InputStream {
        static InputStream empty = new EOFInputStream();

        EOFInputStream() {
        }

        @Override
        public int available() {
            return 0;
        }

        @Override
        public int read() {
            return -1;
        }
    }

    public static class CaptureInput
    implements HttpCaptureResponse<TypedInputStream> {
        private TypedInputStream stream;

        @Override
        public void handle(String baseIRI, HttpResponse response) throws IOException {
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                this.stream = new TypedInputStream(EOFInputStream.empty, (String)null);
                return;
            }
            String ct = entity.getContentType() == null ? null : entity.getContentType().getValue();
            this.stream = new TypedInputStream(entity.getContent(), ct);
        }

        @Override
        public TypedInputStream get() {
            return this.stream;
        }
    }

    public static class CaptureString
    implements HttpCaptureResponse<String> {
        private String result;

        @Override
        public void handle(String baseIRI, HttpResponse response) throws IOException {
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                this.result = null;
                return;
            }
            try (InputStream instream = entity.getContent();){
                this.result = IO.readWholeFileAsUTF8((InputStream)instream);
            }
        }

        @Override
        public String get() {
            return this.result;
        }
    }
}

