/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.binding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.Binding0;
import org.apache.jena.sparql.engine.binding.Binding1;
import org.apache.jena.sparql.engine.binding.Binding2;
import org.apache.jena.sparql.engine.binding.Binding3;
import org.apache.jena.sparql.engine.binding.Binding4;
import org.apache.jena.sparql.engine.binding.BindingOverMap;
import org.apache.jena.sparql.engine.binding.itr.Itr;
import org.apache.jena.sparql.util.FmtUtils;

public class BindingBuilder {
    public static final Binding noParent = null;
    static boolean CHECKING = true;
    static final boolean UNIQUE_NAMES_CHECK = true;
    static final boolean UNIQUE_NAMES_CHECK_PARENT = false;
    private boolean haveBuilt = false;
    protected final Binding parent;
    private Var var1 = null;
    private Node node1 = null;
    private Var var2 = null;
    private Node node2 = null;
    private Var var3 = null;
    private Node node3 = null;
    private Var var4 = null;
    private Node node4 = null;
    private Map<Var, Node> map = null;

    private int countSlots() {
        if (this.map != null) {
            return this.map.size();
        }
        if (this.var1 == null) {
            return 0;
        }
        if (this.var2 == null) {
            return 1;
        }
        if (this.var3 == null) {
            return 2;
        }
        if (this.var4 == null) {
            return 3;
        }
        if (this.map == null) {
            return 4;
        }
        throw new InternalErrorException("Inconsistent internal state");
    }

    public static BindingBuilder create() {
        return new BindingBuilder();
    }

    public static BindingBuilder create(Binding parent) {
        return new BindingBuilder(parent);
    }

    BindingBuilder() {
        this(noParent);
    }

    BindingBuilder(Binding parent) {
        this.parent = parent;
    }

    public BindingBuilder set(Var var, Node node) {
        this.checkAdd(var, node, true);
        this.set$(var, node);
        return this;
    }

    public BindingBuilder add(Var var, Node node) {
        this.checkAdd(var, node, false);
        this.add$(var, node);
        return this;
    }

    public BindingBuilder addAll(Binding other) {
        Iterator<Var> vIter = other.vars();
        while (vIter.hasNext()) {
            Var v = vIter.next();
            Node n = other.get(v);
            this.add(v, n);
        }
        return this;
    }

    private void add$(Var var, Node node) {
        if (this.haveBuilt) {
            throw new IllegalStateException("Attempt to add a binding pair after build() without reset()");
        }
        if (this.map != null) {
            this.map.put(var, node);
            return;
        }
        if (this.var1 == null) {
            this.var1 = var;
            this.node1 = node;
            return;
        }
        if (this.var2 == null) {
            this.var2 = var;
            this.node2 = node;
            return;
        }
        if (this.var3 == null) {
            this.var3 = var;
            this.node3 = node;
            return;
        }
        if (this.var4 == null) {
            this.var4 = var;
            this.node4 = node;
            return;
        }
        this.map = new HashMap<Var, Node>();
        this.map.put(this.var1, this.node1);
        this.map.put(this.var2, this.node2);
        this.map.put(this.var3, this.node3);
        this.map.put(this.var4, this.node4);
        this.map.put(var, node);
        this.var1 = null;
        this.node1 = null;
        this.var2 = null;
        this.node2 = null;
        this.var3 = null;
        this.node3 = null;
        this.var4 = null;
        this.node4 = null;
    }

    private void set$(Var var, Node node) {
        if (this.haveBuilt) {
            throw new IllegalStateException("Attempt to set a binding pair after build() without reset()");
        }
        if (this.map != null) {
            this.map.put(var, node);
            return;
        }
        if (this.var1 == null || var.equals((Object)this.var1)) {
            this.var1 = var;
            this.node1 = node;
            return;
        }
        if (this.var2 == null || var.equals((Object)this.var2)) {
            this.var2 = var;
            this.node2 = node;
            return;
        }
        if (this.var3 == null || var.equals((Object)this.var3)) {
            this.var3 = var;
            this.node3 = node;
            return;
        }
        if (this.var4 == null || var.equals((Object)this.var4)) {
            this.var4 = var;
            this.node4 = node;
            return;
        }
        this.map = new HashMap<Var, Node>();
        this.map.put(this.var1, this.node1);
        this.map.put(this.var2, this.node2);
        this.map.put(this.var3, this.node3);
        this.map.put(this.var4, this.node4);
        this.var1 = null;
        this.node1 = null;
        this.var2 = null;
        this.node2 = null;
        this.var3 = null;
        this.node3 = null;
        this.var4 = null;
        this.node4 = null;
        this.map.put(var, node);
    }

    public Node getOrSame(Var var) {
        Node x = this.get1(var);
        if (x == null) {
            x = this.parent.get(var);
        }
        return x == null ? var : x;
    }

    private void requireBeingBuilt(String method) {
        if (this.haveBuilt) {
            throw new IllegalStateException("Method " + method + " called after .build(), before a .reset()");
        }
    }

    public Node get(Var var) {
        Node x = this.get1(var);
        if (x == null && this.parent != null) {
            x = this.parent.get(var);
        }
        return x;
    }

    public boolean contains(Var var) {
        boolean x = this.contains1(var);
        if (x) {
            return true;
        }
        if (this.parent == null) {
            return false;
        }
        return this.parent.contains(var);
    }

    private Node get1(Var var) {
        this.requireBeingBuilt("get1");
        if (var == null) {
            return null;
        }
        if (this.map != null) {
            return this.map.get((Object)var);
        }
        if (this.var1 == null) {
            return null;
        }
        if (var.equals((Object)this.var1)) {
            return this.node1;
        }
        if (this.var2 == null) {
            return null;
        }
        if (var.equals((Object)this.var2)) {
            return this.node2;
        }
        if (this.var3 == null) {
            return null;
        }
        if (var.equals((Object)this.var3)) {
            return this.node3;
        }
        if (this.var4 == null) {
            return null;
        }
        if (var.equals((Object)this.var4)) {
            return this.node4;
        }
        return null;
    }

    private boolean contains1(Var var) {
        Objects.requireNonNull(var);
        this.requireBeingBuilt("contains1");
        if (this.map != null) {
            return this.map.containsKey((Object)var);
        }
        if (this.var1 == null) {
            return false;
        }
        if (var.equals((Object)this.var1)) {
            return true;
        }
        if (this.var2 == null) {
            return false;
        }
        if (var.equals((Object)this.var2)) {
            return true;
        }
        if (this.var3 == null) {
            return false;
        }
        if (var.equals((Object)this.var3)) {
            return true;
        }
        if (this.var4 == null) {
            return false;
        }
        return var.equals((Object)this.var4);
    }

    private int size1() {
        this.requireBeingBuilt("size1");
        return this.countSlots();
    }

    public boolean isEmpty() {
        if (!this.isEmpty1()) {
            return false;
        }
        if (this.parent == null) {
            return true;
        }
        return this.parent.isEmpty();
    }

    private boolean isEmpty1() {
        this.requireBeingBuilt("isEmpty1");
        return this.var1 == null && this.map == null;
    }

    public Iterator<Var> vars1() {
        this.requireBeingBuilt("vars1");
        if (this.map != null) {
            return new ArrayList<Var>(this.map.keySet()).iterator();
        }
        if (this.var4 != null) {
            return Itr.iter4(this.var1, this.var2, this.var3, this.var4);
        }
        if (this.var3 != null) {
            return Itr.iter3(this.var1, this.var2, this.var3);
        }
        if (this.var2 != null) {
            return Itr.iter2(this.var1, this.var2);
        }
        if (this.var1 != null) {
            return Itr.iter1(this.var1);
        }
        return Itr.iter0();
    }

    private void forEach1(BiConsumer<Var, Node> action) {
        this.requireBeingBuilt("forEach1");
        this.vars1().forEachRemaining(v -> {
            Node n = this.get1((Var)((Object)v));
            action.accept((Var)((Object)v), n);
        });
    }

    private void checkAdd(Var var, Node node, boolean parentOnly) {
        if (!CHECKING) {
            return;
        }
        if (var == null) {
            throw new NullPointerException("check(" + var + ", " + node + "): null var");
        }
        if (node == null) {
            throw new NullPointerException("check(" + var + ", " + node + "): null node value");
        }
        if (this.parent != null) {
            // empty if block
        }
        if (parentOnly) {
            return;
        }
        if (this.contains1(var)) {
            throw new IllegalArgumentException("Attempt to reassign '" + var + "' from '" + FmtUtils.stringForNode(this.get(var)) + "' to '" + FmtUtils.stringForNode(node) + "'");
        }
    }

    public BindingBuilder reset() {
        this.clear();
        this.haveBuilt = false;
        return this;
    }

    private void clear() {
        this.var1 = null;
        this.node1 = null;
        this.var2 = null;
        this.node2 = null;
        this.var3 = null;
        this.node3 = null;
        this.var4 = null;
        this.node4 = null;
        this.map = null;
    }

    public Binding build() {
        if (this.haveBuilt) {
            throw new IllegalStateException("Already built (need to call .reset()?");
        }
        Binding b = this.construct(true);
        this.haveBuilt = true;
        return b;
    }

    public Binding snapshot() {
        return this.construct(false);
    }

    private Binding construct(boolean isFinal) {
        if (this.map != null) {
            Map<Var, Node> m = this.map;
            return new BindingOverMap(this.parent, m);
        }
        if (this.var4 != null) {
            return new Binding4(this.parent, this.var1, this.node1, this.var2, this.node2, this.var3, this.node3, this.var4, this.node4);
        }
        if (this.var3 != null) {
            return new Binding3(this.parent, this.var1, this.node1, this.var2, this.node2, this.var3, this.node3);
        }
        if (this.var2 != null) {
            return new Binding2(this.parent, this.var1, this.node1, this.var2, this.node2);
        }
        if (this.var1 != null) {
            return new Binding1(this.parent, this.var1, this.node1);
        }
        return new Binding0(this.parent);
    }

    public String toString() {
        if (this.isEmpty1()) {
            return "<empty>" + BindingBuilder.parentStr(this.parent);
        }
        StringJoiner sj = new StringJoiner(" ", "( ", " )");
        this.forEach1((v, n) -> sj.add(String.format("%s=>%s", v, n)));
        return sj.toString() + BindingBuilder.parentStr(this.parent);
    }

    private static String parentStr(Binding parent) {
        if (parent == noParent) {
            return "";
        }
        return " -> " + parent.toString();
    }
}

