/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.assembler;

import java.util.Map;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.JA;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.sparql.core.assembler.DatasetAssemblerVocab;
import org.apache.jena.sparql.core.assembler.NamedDatasetAssembler;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.apache.jena.system.Txn;
import org.apache.jena.vocabulary.RDF;

public class InMemDatasetAssembler
extends NamedDatasetAssembler {
    @Override
    public Map<String, DatasetGraph> pool() {
        return sharedDatasetPool;
    }

    public static Resource getType() {
        return DatasetAssemblerVocab.tMemoryDataset;
    }

    @Override
    public DatasetGraph createDataset(Assembler a, Resource root2) {
        if (!root2.hasProperty(RDF.type, (RDFNode)DatasetAssemblerVocab.tDatasetTxnMem)) {
            this.checkType(root2, DatasetAssemblerVocab.tMemoryDataset);
        }
        DatasetGraph dataset = DatasetGraphFactory.createTxnMem();
        Txn.executeWrite(dataset, () -> {
            GraphUtils.multiValueAsString(root2, JA.data).forEach(dataURI -> RDFDataMgr.read(dataset, dataURI));
            GraphUtils.multiValueResource(root2, DatasetAssemblerVocab.pNamedGraph).forEach(namedGraphResource -> {
                String graphName = GraphUtils.getAsStringValue(namedGraphResource, DatasetAssemblerVocab.pGraphName);
                if (namedGraphResource.hasProperty(JA.data)) {
                    GraphUtils.multiValueAsString(namedGraphResource, JA.data).forEach(namedGraphData -> {
                        Node gn = NodeFactory.createURI((String)graphName);
                        RDFDataMgr.read(dataset.getGraph(gn), namedGraphData);
                    });
                }
            });
        });
        AssemblerUtils.mergeContext(root2, dataset.getContext());
        return dataset;
    }
}

