/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.json.io.parser;

import org.apache.jena.atlas.json.io.JSONHandler;
import org.apache.jena.atlas.json.io.parser.JSONParserBase;
import org.apache.jena.atlas.json.io.parser.TokenizerJSON;
import org.apache.jena.riot.tokens.TokenType;

public class JSONP
extends JSONParserBase {
    private JSONHandler handler;

    public JSONP(TokenizerJSON tokens2, JSONHandler handler) {
        super(tokens2);
        this.handler = handler;
    }

    public void parse() {
        if (!this.peekToken().hasType(TokenType.LBRACE)) {
            this.exception("Not a JSON object START: " + this.peekToken(), new Object[0]);
        }
        this.parseObject();
    }

    private void parseObject() {
        this.nextToken();
        this.handler.startObject(this.currLine, this.currCol);
        if (this.lookingAt(TokenType.RBRACE)) {
            this.nextToken();
            this.handler.finishObject(this.currLine, this.currCol);
            return;
        }
        while (true) {
            this.handler.startPair(this.currLine, this.currCol);
            if (!this.lookingAt(TokenType.KEYWORD) && !this.lookingAtString()) {
                this.exception("Not a key for a JSON object: " + this.peekToken(), new Object[0]);
            }
            String key = this.peekToken().getImage();
            this.nextToken();
            this.handler.valueString(key, this.currLine, this.currCol);
            if (!this.lookingAt(TokenType.COLON)) {
                this.exception("Not a colon: " + this.peekToken(), new Object[0]);
            }
            this.nextToken();
            this.handler.keyPair(this.currLine, this.currCol);
            this.parseAny();
            this.handler.finishPair(this.currLine, this.currCol);
            if (!this.lookingAt(TokenType.COMMA)) break;
            this.nextToken();
        }
        if (!this.lookingAt(TokenType.RBRACE)) {
            this.exception("Illegal: " + this.peekToken(), new Object[0]);
        }
        this.nextToken();
        this.handler.finishObject(this.currLine, this.currCol);
    }

    public void parseAny() {
        switch (this.peekToken().getType()) {
            case LBRACE: {
                this.parseObject();
                return;
            }
            case LBRACKET: {
                this.parseArray();
                return;
            }
            case INTEGER: {
                this.handler.valueInteger(this.peekToken().getImage(), this.currLine, this.currCol);
                this.nextToken();
                return;
            }
            case DECIMAL: {
                this.handler.valueDecimal(this.peekToken().getImage(), this.currLine, this.currCol);
                this.nextToken();
                return;
            }
            case DOUBLE: {
                this.handler.valueDouble(this.peekToken().getImage(), this.currLine, this.currCol);
                this.nextToken();
                return;
            }
            case STRING1: 
            case STRING2: 
            case LONG_STRING1: 
            case LONG_STRING2: {
                this.handler.valueString(this.peekToken().getImage(), this.currLine, this.currCol);
                this.nextToken();
                return;
            }
            case KEYWORD: {
                String image = this.peekToken().getImage();
                if (image.equalsIgnoreCase("true")) {
                    this.handler.valueBoolean(true, this.currLine, this.currCol);
                    this.nextToken();
                    return;
                }
                if (image.equalsIgnoreCase("false")) {
                    this.handler.valueBoolean(false, this.currLine, this.currCol);
                    this.nextToken();
                    return;
                }
                if (image.equalsIgnoreCase("null")) {
                    this.handler.valueNull(this.currLine, this.currCol);
                    this.nextToken();
                    return;
                }
                this.handler.valueString(image, this.currLine, this.currCol);
                break;
            }
            default: {
                this.exception("Unrecognized token: " + this.peekToken(), new Object[0]);
            }
        }
    }

    private void parseArray() {
        this.handler.startArray(this.currLine, this.currCol);
        this.nextToken();
        if (this.lookingAt(TokenType.RBRACKET)) {
            this.nextToken();
            this.handler.finishArray(this.currLine, this.currCol);
            return;
        }
        while (true) {
            this.parseAny();
            this.handler.element(this.currLine, this.currCol);
            if (!this.lookingAt(TokenType.COMMA)) break;
            this.nextToken();
        }
        if (!this.lookingAt(TokenType.RBRACKET)) {
            this.exception("Illegal: " + this.peekToken(), new Object[0]);
        }
        this.nextToken();
        this.handler.finishArray(this.currLine, this.currCol);
    }
}

