/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.Calendar;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerFactory;

public class NodeFactoryExtra {
    private static final PrefixMap prefixMappingDefault = PrefixMapFactory.createForInput(SSE.getDefaultPrefixMapRead());
    private static PrefixMap pmapEmpty = PrefixMapFactory.create();

    public static Node parseNode(String nodeString) {
        return NodeFactoryExtra.parseNode(nodeString, prefixMappingDefault);
    }

    public static Node parseNode(String nodeString, PrefixMap pmap) {
        String x;
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerString(nodeString);
        if (!tokenizer.hasNext()) {
            throw new RiotException("Empty RDF term");
        }
        Token token = tokenizer.next();
        Node node = token.asNode(pmap);
        if (node == null) {
            throw new RiotException("Bad RDF Term: " + nodeString);
        }
        if (tokenizer.hasNext()) {
            throw new RiotException("Trailing characters in string: " + nodeString);
        }
        if (node.isURI() && (x = node.getURI()).indexOf(32) >= 0) {
            throw new RiotException("Space(s) in  IRI: " + nodeString);
        }
        return node;
    }

    private static QueryParseException makeException(String msg, int line, int column) {
        return new QueryParseException(msg, line, column);
    }

    public static Node createLiteralNode(String lex, String lang, String datatypeURI) {
        if (datatypeURI != null && datatypeURI.equals("")) {
            datatypeURI = null;
        }
        if (lang != null && lang.equals("")) {
            lang = null;
        }
        RDFDatatype dType = null;
        if (datatypeURI != null) {
            dType = TypeMapper.getInstance().getSafeTypeByName(datatypeURI);
        }
        Node n = NodeFactory.createLiteral((String)lex, (String)lang, (RDFDatatype)dType);
        return n;
    }

    public static int nodeToInt(Node node) {
        LiteralLabel lit = node.getLiteral();
        if (!XSDDatatype.XSDint.isValidLiteral(lit)) {
            return Integer.MIN_VALUE;
        }
        int i = ((Number)lit.getValue()).intValue();
        return i;
    }

    public static long nodeToLong(Node node) {
        LiteralLabel lit = node.getLiteral();
        if (!XSDDatatype.XSDlong.isValidLiteral(lit)) {
            return Long.MIN_VALUE;
        }
        long i = ((Number)lit.getValue()).longValue();
        return i;
    }

    public static float nodeToFloat(Node node) {
        LiteralLabel lit = node.getLiteral();
        if (!XSDDatatype.XSDfloat.isValidLiteral(lit)) {
            return Float.NaN;
        }
        float f = ((Number)lit.getValue()).floatValue();
        return f;
    }

    public static double nodeToDouble(Node node) {
        LiteralLabel lit = node.getLiteral();
        if (!XSDDatatype.XSDdouble.isValidLiteral(lit)) {
            return Double.NaN;
        }
        double d = ((Number)lit.getValue()).doubleValue();
        return d;
    }

    public static Node intToNode(int integer) {
        return NodeFactory.createLiteral((String)Integer.toString(integer), (RDFDatatype)XSDDatatype.XSDinteger);
    }

    public static Node intToNode(long integer) {
        return NodeFactory.createLiteral((String)Long.toString(integer), (RDFDatatype)XSDDatatype.XSDinteger);
    }

    public static Node floatToNode(float value) {
        return NodeFactory.createLiteral((String)Float.toString(value), (RDFDatatype)XSDDatatype.XSDfloat);
    }

    public static Node doubleToNode(double value) {
        return NodeFactory.createLiteral((String)Double.toString(value), (RDFDatatype)XSDDatatype.XSDdouble);
    }

    public static Node dateTimeToNode(Calendar c) {
        String lex = Utils.calendarToXSDDateTimeString(c);
        return NodeFactory.createLiteral((String)lex, (RDFDatatype)XSDDatatype.XSDdateTime);
    }

    public static Node dateToNode(Calendar c) {
        String lex = Utils.calendarToXSDDateString(c);
        return NodeFactory.createLiteral((String)lex, (RDFDatatype)XSDDatatype.XSDdate);
    }

    public static Node timeToNode(Calendar c) {
        String lex = Utils.calendarToXSDTimeString(c);
        return NodeFactory.createLiteral((String)lex, (RDFDatatype)XSDDatatype.XSDtime);
    }

    public static Node nowAsDateTime() {
        String lex = Utils.nowAsXSDDateTimeString();
        return NodeFactory.createLiteral((String)lex, (RDFDatatype)XSDDatatype.XSDdateTime);
    }

    public static Node todayAsDate() {
        String lex = Utils.todayAsXSDDateString();
        return NodeFactory.createLiteral((String)lex, (RDFDatatype)XSDDatatype.XSDdate);
    }
}

