/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.resultset;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ResultSetStream;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import com.hp.hpl.jena.sparql.resultset.JSONResultsKW;
import com.hp.hpl.jena.sparql.resultset.ResultSetException;
import com.hp.hpl.jena.sparql.resultset.SPARQLResult;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.jena.atlas.json.JSON;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.riot.lang.LabelToNode;
import org.apache.jena.riot.system.SyntaxLabels;

public class JSONInput
extends SPARQLResult {
    Boolean booleanResult = null;
    List<Binding> rows = null;
    List<Var> vars = null;
    LabelToNode labelMap = SyntaxLabels.createLabelToNode();

    public static ResultSet fromJSON(InputStream input) {
        SPARQLResult r = new JSONInput().process(input, null);
        return r.getResultSet();
    }

    public static boolean booleanFromJSON(InputStream input) {
        SPARQLResult r = new JSONInput().process(input, null);
        return r.getBooleanResult();
    }

    public static SPARQLResult make(InputStream input) {
        return JSONInput.make(input, null);
    }

    public static SPARQLResult make(InputStream input, Model model) {
        return new JSONInput().process(input, model);
    }

    public JSONInput() {
    }

    public JSONInput(InputStream in) {
        this(in, null);
    }

    public JSONInput(InputStream in, Model model) {
        if (model == null) {
            model = GraphFactory.makeJenaDefaultModel();
        }
        this.process(in, model);
    }

    private SPARQLResult process(InputStream in, Model model) {
        this.parse(in);
        if (model == null) {
            model = GraphFactory.makeJenaDefaultModel();
        }
        if (this.rows != null) {
            QueryIterPlainWrapper qIter = new QueryIterPlainWrapper(this.rows.iterator());
            ResultSetStream rs = new ResultSetStream(Var.varNames(this.vars), model, qIter);
            super.set(rs);
        } else {
            super.set(this.booleanResult);
        }
        return this;
    }

    private void parse(InputStream in) {
        JsonObject obj = JSON.parse(in);
        if (obj.hasKey(JSONResultsKW.kBoolean)) {
            JSONInput.checkContains(obj, true, true, JSONResultsKW.kHead, JSONResultsKW.kBoolean);
            this.booleanResult = obj.get(JSONResultsKW.kBoolean).getAsBoolean().value();
            this.rows = null;
            return;
        }
        this.rows = new ArrayList<Binding>(1000);
        JSONInput.checkContains(obj, true, true, JSONResultsKW.kHead, JSONResultsKW.kResults);
        if (!obj.get(JSONResultsKW.kHead).isObject()) {
            throw new ResultSetException("Key 'head' must have a JSON object as value: found: " + obj.get(JSONResultsKW.kHead));
        }
        JsonObject head = obj.get(JSONResultsKW.kHead).getAsObject();
        if (head.hasKey(JSONResultsKW.kLink)) {
            ArrayList<String> links = new ArrayList<String>();
            if (head.get(JSONResultsKW.kLink).isString()) {
                Log.warn(this, "Link field is a string, should be an array of strings");
                links.add(head.get(JSONResultsKW.kLink).getAsString().value());
            } else {
                if (!head.get(JSONResultsKW.kLink).isArray()) {
                    throw new ResultSetException("Key 'link' must have be an array: found: " + obj.get(JSONResultsKW.kLink));
                }
                for (JsonValue v : head.get(JSONResultsKW.kLink).getAsArray()) {
                    if (!v.isString()) {
                        throw new ResultSetException("Key 'link' must have be an array of strings: found: " + v);
                    }
                    links.add(v.getAsString().value());
                }
            }
        }
        this.vars = this.parseVars(head);
        JsonObject results = obj.get(JSONResultsKW.kResults).getAsObject();
        if (!results.get(JSONResultsKW.kBindings).isArray()) {
            throw new ResultSetException("'bindings' must be an array");
        }
        JsonArray array = results.get(JSONResultsKW.kBindings).getAsArray();
        Iterator<JsonValue> iter = array.iterator();
        while (iter.hasNext()) {
            BindingMap b = BindingFactory.create();
            JsonValue v = iter.next();
            if (!v.isObject()) {
                throw new ResultSetException("Entry in 'bindings' array must be an object {}");
            }
            JsonObject x = v.getAsObject();
            Set<String> varNames = x.keys();
            for (String vn : varNames) {
                JsonValue vt = x.get(vn);
                if (!vt.isObject()) {
                    throw new ResultSetException("Binding for variable '" + vn + "' is not a JSON object: " + vt);
                }
                Node n = this.parseOneTerm(vt.getAsObject());
                b.add(Var.alloc(vn), n);
            }
            this.rows.add(b);
        }
    }

    private List<Var> parseVars(JsonObject obj) {
        if (!obj.get(JSONResultsKW.kVars).isArray()) {
            throw new ResultSetException("Key 'vars' must be a JSON array");
        }
        JsonArray a = obj.get(JSONResultsKW.kVars).getAsArray();
        Iterator<JsonValue> iter = a.iterator();
        ArrayList<Var> vars = new ArrayList<Var>();
        while (iter.hasNext()) {
            JsonValue v = iter.next();
            if (!v.isString()) {
                throw new ResultSetException("Entries in vars array must be strings");
            }
            Var var = Var.alloc(v.getAsString().value());
            vars.add(var);
        }
        return vars;
    }

    private Node parseOneTerm(JsonObject term) {
        JSONInput.checkContains(term, false, false, JSONResultsKW.kType, JSONResultsKW.kValue, JSONResultsKW.kXmlLang, JSONResultsKW.kDatatype);
        String type = JSONInput.stringOrNull(term, JSONResultsKW.kType);
        String v = JSONInput.stringOrNull(term, JSONResultsKW.kValue);
        if (JSONResultsKW.kUri.equals(type)) {
            JSONInput.checkContains(term, false, true, JSONResultsKW.kType, JSONResultsKW.kValue);
            String uri = v;
            Node n = NodeFactory.createURI((String)v);
            return n;
        }
        if (JSONResultsKW.kLiteral.equals(type) || JSONResultsKW.kTypedLiteral.equals(type)) {
            String lang = JSONInput.stringOrNull(term, JSONResultsKW.kXmlLang);
            String dtStr = JSONInput.stringOrNull(term, JSONResultsKW.kDatatype);
            if (lang != null && dtStr != null) {
                throw new ResultSetException("Both language and datatype defined: " + term);
            }
            RDFDatatype dt = TypeMapper.getInstance().getSafeTypeByName(dtStr);
            return NodeFactory.createLiteral((String)v, (String)lang, (RDFDatatype)dt);
        }
        if (JSONResultsKW.kBnode.equals(type)) {
            return (Node)this.labelMap.get(null, v);
        }
        throw new ResultSetException("Object key not recognized as valid for an RDF term: " + term);
    }

    private static String stringOrNull(JsonObject obj, String key) {
        JsonValue v = obj.get(key);
        if (v == null) {
            return null;
        }
        if (!v.isString()) {
            throw new ResultSetException("Not a string: key: " + key);
        }
        return v.getAsString().value();
    }

    private static void checkContains(JsonObject term, boolean allowUndefinedKeys, boolean requireAllExpectedKeys, String ... keys) {
        List<String> expectedKeys = Arrays.asList(keys);
        HashSet<String> declared = new HashSet<String>();
        for (String k : term.keys()) {
            if (!expectedKeys.contains(k) && !allowUndefinedKeys) {
                throw new ResultSetException("Expected only object keys " + Arrays.asList(keys) + " but encountered '" + k + "'");
            }
            if (!expectedKeys.contains(k)) continue;
            declared.add(k);
        }
        if (requireAllExpectedKeys && declared.size() < expectedKeys.size()) {
            throw new ResultSetException("One or more of the required keys " + expectedKeys + " was not found");
        }
    }
}

